/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.introspect.impl;

import java.lang.reflect.Constructor;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.implementation.java.IntrospectionException;
import org.apache.tuscany.sca.implementation.java.JavaConstructorImpl;
import org.apache.tuscany.sca.implementation.java.JavaImplementation;
import org.apache.tuscany.sca.implementation.java.JavaParameterImpl;
import org.apache.tuscany.sca.implementation.java.introspect.BaseJavaClassVisitor;
import org.apache.tuscany.sca.implementation.java.introspect.impl.DuplicateConstructorException;
import org.apache.tuscany.sca.implementation.java.introspect.impl.InvalidConstructorException;

public class ConstructorProcessor
extends BaseJavaClassVisitor {
    public ConstructorProcessor(AssemblyFactory factory) {
        super(factory);
    }

    public ConstructorProcessor(ExtensionPointRegistry registry) {
        super(registry);
    }

    @Override
    public <T> void visitClass(Class<T> clazz, JavaImplementation type) throws IntrospectionException {
        Constructor<?>[] ctors = clazz.getConstructors();
        boolean found = false;
        for (Constructor<?> constructor : ctors) {
            JavaConstructorImpl definition = new JavaConstructorImpl(constructor);
            type.getConstructors().put(constructor, definition);
            if (constructor.getAnnotation(org.oasisopen.sca.annotation.Constructor.class) == null) continue;
            if (found) {
                throw new DuplicateConstructorException("[JCI50002] Multiple constructors marked with @Constructor", constructor);
            }
            found = true;
            type.setConstructor(definition);
        }
    }

    @Override
    public <T> void visitConstructor(Constructor<T> constructor, JavaImplementation type) throws IntrospectionException {
        JavaParameterImpl[] parameters;
        org.oasisopen.sca.annotation.Constructor annotation = constructor.getAnnotation(org.oasisopen.sca.annotation.Constructor.class);
        if (annotation == null) {
            return;
        }
        JavaConstructorImpl<Object> definition = type.getConstructor();
        if (definition == null) {
            definition = new JavaConstructorImpl<T>(constructor);
            type.setConstructor(definition);
        }
        for (JavaParameterImpl p : parameters = definition.getParameters()) {
            if (this.hasAnnotation(p)) continue;
            throw new InvalidConstructorException("JCA90003 constructor parameters for class " + type.getName() + " must have @Property or @Reference annotation");
        }
        type.setConstructor(definition);
    }

    private boolean hasAnnotation(JavaParameterImpl p) {
        return p.getAnnotations() != null && p.getAnnotations().length > 0;
    }
}

