/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.introspect.impl;

import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.implementation.java.IntrospectionException;
import org.apache.tuscany.sca.implementation.java.JavaImplementation;
import org.apache.tuscany.sca.implementation.java.JavaScopeImpl;
import org.apache.tuscany.sca.implementation.java.introspect.BaseJavaClassVisitor;
import org.oasisopen.sca.annotation.Scope;

public class ScopeProcessor
extends BaseJavaClassVisitor {
    public ScopeProcessor(AssemblyFactory factory) {
        super(factory);
    }

    public ScopeProcessor(ExtensionPointRegistry registry) {
        super(registry);
    }

    @Override
    public <T> void visitClass(Class<T> clazz, JavaImplementation type) throws IntrospectionException {
        Scope annotation = clazz.getAnnotation(Scope.class);
        if (annotation == null) {
            type.setJavaScope(JavaScopeImpl.STATELESS);
            return;
        }
        String name = annotation.value();
        JavaScopeImpl scope = "COMPOSITE".equals(name) ? JavaScopeImpl.COMPOSITE : ("STATELESS".equals(name) ? JavaScopeImpl.STATELESS : JavaScopeImpl.INVALID);
        type.setJavaScope(scope);
        if (type.getJavaScope().equals(JavaScopeImpl.INVALID)) {
            throw new IntrospectionException("Invalid scope :" + name + " for " + type.getName());
        }
    }
}

