/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.jaxrs.xml;

import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.binding.rest.RESTBinding;
import org.apache.tuscany.sca.binding.rest.RESTBindingFactory;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ClassReference;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.implementation.jaxrs.JAXRSImplementation;
import org.apache.tuscany.sca.implementation.jaxrs.JAXRSImplementationFactory;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceContract;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceFactory;
import org.oasisopen.sca.ServiceRuntimeException;

public class JAXRSImplementationProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<JAXRSImplementation> {
    private static final QName IMPLEMENTATION_JAXRS = JAXRSImplementation.TYPE;
    private AssemblyFactory assemblyFactory;
    private JAXRSImplementationFactory implementationFactory;
    private RESTBindingFactory restBindingFactory;
    private JavaInterfaceFactory javaInterfaceFactory;

    public JAXRSImplementationProcessor(ExtensionPointRegistry extensionPoints) {
        FactoryExtensionPoint modelFactories = extensionPoints.getExtensionPoint(FactoryExtensionPoint.class);
        this.assemblyFactory = modelFactories.getFactory(AssemblyFactory.class);
        this.implementationFactory = modelFactories.getFactory(JAXRSImplementationFactory.class);
        this.restBindingFactory = modelFactories.getFactory(RESTBindingFactory.class);
        this.javaInterfaceFactory = modelFactories.getFactory(JavaInterfaceFactory.class);
    }

    @Override
    public QName getArtifactType() {
        return IMPLEMENTATION_JAXRS;
    }

    @Override
    public Class<JAXRSImplementation> getModelType() {
        return JAXRSImplementation.class;
    }

    @Override
    public JAXRSImplementation read(XMLStreamReader reader, ProcessorContext context) throws ContributionReadException, XMLStreamException {
        JAXRSImplementation implementation = this.implementationFactory.createJAXRSImplementation();
        implementation.setUnresolved(true);
        String application = reader.getAttributeValue(null, "application");
        if (application != null) {
            implementation.setApplication(application);
        }
        while (reader.hasNext() && (reader.next() != 2 || !IMPLEMENTATION_JAXRS.equals(reader.getName()))) {
        }
        return implementation;
    }

    @Override
    public void resolve(JAXRSImplementation implementation, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        Application application;
        ClassReference classReference = new ClassReference(implementation.getApplication());
        classReference = resolver.resolveModel(ClassReference.class, classReference, context);
        implementation.setApplicationClass(classReference.getJavaClass());
        implementation.setUnresolved(false);
        try {
            application = (Application)implementation.getApplicationClass().newInstance();
        }
        catch (Exception e) {
            throw new ContributionResolveException(e);
        }
        for (Class<?> rootResourceClass : application.getClasses()) {
            this.addService(implementation, rootResourceClass);
        }
        for (Object rootResource : application.getSingletons()) {
            this.addService(implementation, rootResource.getClass());
        }
    }

    private void addService(JAXRSImplementation implementation, Class<?> rootResourceClass) {
        JavaInterface javaInterface;
        Service service = this.assemblyFactory.createService();
        JavaInterfaceContract contract = this.javaInterfaceFactory.createJavaInterfaceContract();
        try {
            javaInterface = this.javaInterfaceFactory.createJavaInterface(rootResourceClass);
        }
        catch (InvalidInterfaceException e) {
            throw new ServiceRuntimeException(e);
        }
        contract.setInterface(javaInterface);
        service.setInterfaceContract(contract);
        RESTBinding binding = this.restBindingFactory.createRESTBinding();
        Path path = rootResourceClass.getAnnotation(Path.class);
        if (path != null) {
            binding.setURI(path.value());
        }
        service.getBindings().add(binding);
        service.setName(rootResourceClass.getSimpleName());
        implementation.getServices().add(service);
    }

    @Override
    public void write(JAXRSImplementation implementation, XMLStreamWriter writer, ProcessorContext context) throws ContributionWriteException, XMLStreamException {
        this.writeStart(writer, IMPLEMENTATION_JAXRS.getNamespaceURI(), IMPLEMENTATION_JAXRS.getLocalPart(), new BaseStAXArtifactProcessor.XAttr("application", implementation.getApplication()));
        this.writeEnd(writer);
    }
}

