/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.interfacedef.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.util.WrapperInfo;
import org.apache.tuscany.sca.policy.ExtensionType;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.PolicySet;

public class InterfaceImpl
implements Interface {
    private Boolean remotable;
    private boolean remotableSetFromSCDL = false;
    private boolean conversational;
    private OperationList operations = new OperationList();
    private boolean unresolved;
    private ExtensionType type;
    private List<PolicySet> policySets = new ArrayList<PolicySet>();
    private List<Intent> requiredIntents = new ArrayList<Intent>();
    private Map<Object, Object> attributes = new ConcurrentHashMap<Object, Object>();

    @Override
    public boolean isRemotable() {
        boolean value = false;
        if (this.remotable != null && this.remotable.booleanValue()) {
            value = true;
        }
        return value;
    }

    @Override
    public void setRemotable(boolean remotable) {
        this.remotable = remotable;
    }

    @Override
    public boolean isRemotableSet() {
        return this.remotable != null;
    }

    @Override
    public boolean isRemotableSetFromSCDL() {
        return this.remotableSetFromSCDL;
    }

    @Override
    public void setRemotableSetFromSCDL() {
        this.remotableSetFromSCDL = true;
    }

    @Override
    public List<Operation> getOperations() {
        return this.operations;
    }

    public boolean isUnresolved() {
        return this.unresolved;
    }

    public void setUnresolved(boolean undefined) {
        this.unresolved = undefined;
    }

    public boolean isConversational() {
        return this.conversational;
    }

    public void setConversational(boolean conversational) {
        this.conversational = conversational;
    }

    @Override
    @Deprecated
    public void setDefaultDataBinding(String dataBinding) {
        for (Operation op : this.getOperations()) {
            DataType<List<DataType>> unwrappedOutputType;
            DataType<List<DataType>> unwrappedInputType;
            WrapperInfo wrapper;
            List<DataType> faultTypes;
            DataType<List<DataType>> outputType;
            if (op.getDataBinding() != null) continue;
            op.setDataBinding(dataBinding);
            DataType<List<DataType>> inputType = op.getInputType();
            if (inputType != null) {
                for (DataType d : inputType.getLogical()) {
                    if (d.getDataBinding() != null) continue;
                    d.setDataBinding(dataBinding);
                }
            }
            if ((outputType = op.getOutputType()) != null && outputType.getDataBinding() == null) {
                outputType.setDataBinding(dataBinding);
            }
            if ((faultTypes = op.getFaultTypes()) != null) {
                for (DataType d : faultTypes) {
                    DataType ft;
                    if (d.getDataBinding() == null) {
                        d.setDataBinding(dataBinding);
                    }
                    if ((ft = (DataType)d.getLogical()).getDataBinding() != null) continue;
                    ft.setDataBinding(dataBinding);
                }
            }
            if (op.isInputWrapperStyle() && (wrapper = op.getInputWrapper()) != null && (unwrappedInputType = wrapper.getUnwrappedType()) != null) {
                for (DataType d : unwrappedInputType.getLogical()) {
                    if (d.getDataBinding() != null) continue;
                    d.setDataBinding(dataBinding);
                }
            }
            if (!op.isOutputWrapperStyle() || (wrapper = op.getOutputWrapper()) == null || (unwrappedOutputType = wrapper.getUnwrappedType()) == null) continue;
            for (DataType d : unwrappedOutputType.getLogical()) {
                if (d.getDataBinding() != null) continue;
                d.setDataBinding(dataBinding);
            }
        }
    }

    private void setDataBinding(DataType dataType, String dataBinding) {
        if ("java:array".equals(dataType.getDataBinding())) {
            this.setDataBinding((DataType)dataType.getLogical(), dataBinding);
        } else {
            dataType.setDataBinding(dataBinding);
        }
    }

    @Override
    public void resetDataBinding(String dataBinding) {
        for (Operation op : this.getOperations()) {
            DataType<List<DataType>> unwrappedOutputType;
            WrapperInfo outputWrapper;
            DataType<List<DataType>> unwrappedInputType;
            WrapperInfo inputWrapper;
            op.setDataBinding(dataBinding);
            DataType<List<DataType>> inputType = op.getInputType();
            if (inputType != null) {
                for (DataType d : inputType.getLogical()) {
                    this.setDataBinding(d, dataBinding);
                }
            }
            List<DataType> outputTypes = op.getOutputType().getLogical();
            for (DataType outputType : outputTypes) {
                if (outputType == null) continue;
                this.setDataBinding(outputType, dataBinding);
            }
            List<DataType> faultTypes = op.getFaultTypes();
            if (faultTypes != null) {
                for (DataType d : faultTypes) {
                    this.setDataBinding(d, dataBinding);
                    this.setDataBinding((DataType)d.getLogical(), dataBinding);
                }
            }
            if (op.isInputWrapperStyle() && (inputWrapper = op.getInputWrapper()) != null && (unwrappedInputType = inputWrapper.getUnwrappedType()) != null) {
                for (DataType d : unwrappedInputType.getLogical()) {
                    this.setDataBinding(d, dataBinding);
                }
            }
            if (!op.isOutputWrapperStyle() || (outputWrapper = op.getOutputWrapper()) == null || (unwrappedOutputType = outputWrapper.getUnwrappedType()) == null) continue;
            for (DataType d : unwrappedOutputType.getLogical()) {
                this.setDataBinding(d, dataBinding);
            }
        }
    }

    @Override
    public void resetInterfaceInputTypes(Interface newInterface) {
        for (int i = 0; i < this.getOperations().size(); ++i) {
            Operation oldOperation = this.getOperations().get(i);
            Operation newOperation = null;
            for (Operation tmpOperation : newInterface.getOperations()) {
                if (!tmpOperation.getName().equals(oldOperation.getName())) continue;
                newOperation = tmpOperation;
            }
            if (newOperation == null) break;
            oldOperation.setInputType(newOperation.getInputType());
            if (!newOperation.isInputWrapperStyle()) continue;
            oldOperation.setInputWrapperStyle(true);
            oldOperation.setInputWrapper(newOperation.getInputWrapper());
        }
    }

    @Override
    public void resetInterfaceOutputTypes(Interface newInterface) {
        for (int i = 0; i < this.getOperations().size(); ++i) {
            Operation oldOperation = this.getOperations().get(i);
            Operation newOperation = null;
            for (Operation tmpOperation : newInterface.getOperations()) {
                if (!tmpOperation.getName().equals(oldOperation.getName())) continue;
                newOperation = tmpOperation;
            }
            if (newOperation == null) break;
            oldOperation.setOutputType(newOperation.getOutputType());
            oldOperation.setFaultTypes(newOperation.getFaultTypes());
            if (!newOperation.isOutputWrapperStyle()) continue;
            oldOperation.setOutputWrapperStyle(true);
            oldOperation.setOutputWrapper(newOperation.getOutputWrapper());
        }
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public List<PolicySet> getPolicySets() {
        return this.policySets;
    }

    @Override
    public List<Intent> getRequiredIntents() {
        return this.requiredIntents;
    }

    @Override
    public ExtensionType getExtensionType() {
        return this.type;
    }

    @Override
    public void setExtensionType(ExtensionType type) {
        this.type = type;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        InterfaceImpl copy = (InterfaceImpl)super.clone();
        copy.operations = new OperationList();
        for (Operation operation : this.operations) {
            Operation clonedOperation = (Operation)operation.clone();
            copy.operations.add(clonedOperation);
        }
        copy.attributes = new ConcurrentHashMap<Object, Object>();
        copy.attributes.putAll(this.attributes);
        return copy;
    }

    @Override
    public Map<Object, Object> getAttributes() {
        return this.attributes;
    }

    private class OperationList
    extends ArrayList<Operation> {
        private static final long serialVersionUID = -903469106307606099L;

        private OperationList() {
        }

        @Override
        public Operation set(int index, Operation element) {
            element.setInterface(InterfaceImpl.this);
            return super.set(index, element);
        }

        @Override
        public void add(int index, Operation element) {
            element.setInterface(InterfaceImpl.this);
            super.add(index, element);
        }

        @Override
        public boolean add(Operation o) {
            o.setInterface(InterfaceImpl.this);
            return super.add(o);
        }

        @Override
        public boolean addAll(Collection<? extends Operation> c) {
            for (Operation operation : c) {
                operation.setInterface(InterfaceImpl.this);
            }
            return super.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends Operation> c) {
            for (Operation operation : c) {
                operation.setInterface(InterfaceImpl.this);
            }
            return super.addAll(index, c);
        }
    }
}

