/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.interfacedef.java;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.extensibility.ServiceDeclaration;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceFactory;
import org.apache.tuscany.sca.interfacedef.java.impl.JavaInterfaceFactoryImpl;
import org.apache.tuscany.sca.interfacedef.java.introspect.JavaInterfaceVisitor;

public class DefaultJavaInterfaceFactory
extends JavaInterfaceFactoryImpl
implements JavaInterfaceFactory {
    private static final Logger logger = Logger.getLogger(DefaultJavaInterfaceFactory.class.getName());
    private ExtensionPointRegistry registry;
    private boolean loadedVisitors;

    public DefaultJavaInterfaceFactory(ExtensionPointRegistry registry) {
        this.registry = registry;
    }

    @Override
    public List<JavaInterfaceVisitor> getInterfaceVisitors() {
        this.loadVisitors();
        return super.getInterfaceVisitors();
    }

    private synchronized void loadVisitors() {
        Collection<ServiceDeclaration> visitorDeclarations;
        if (this.loadedVisitors) {
            return;
        }
        try {
            visitorDeclarations = this.registry.getServiceDiscovery().getServiceDeclarations(JavaInterfaceVisitor.class, true);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        for (ServiceDeclaration visitorDeclaration : visitorDeclarations) {
            JavaInterfaceVisitor visitor = null;
            try {
                Class<?> visitorClass = visitorDeclaration.loadClass();
                try {
                    Constructor<?> constructor = visitorClass.getConstructor(ExtensionPointRegistry.class);
                    visitor = (JavaInterfaceVisitor)constructor.newInstance(this.registry);
                }
                catch (NoSuchMethodException e) {
                    visitor = (JavaInterfaceVisitor)visitorClass.newInstance();
                }
            }
            catch (Exception e) {
                IllegalStateException ie = new IllegalStateException(e);
                throw ie;
            }
            logger.fine("Adding Java Interface visitor: " + visitor.getClass().getName());
            this.addInterfaceVisitor(visitor);
        }
        this.loadedVisitors = true;
    }
}

