/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.interfacedef.java.jaxws;

import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.jws.WebParam;
import javax.jws.WebResult;
import org.apache.tuscany.sca.interfacedef.java.impl.JavaInterfaceUtil;
import org.apache.tuscany.sca.interfacedef.java.jaxws.BaseBeanGenerator;
import org.apache.tuscany.sca.interfacedef.java.jaxws.CodeGenerationHelper;
import org.apache.tuscany.sca.interfacedef.java.jaxws.GeneratedClassLoader;
import org.oasisopen.sca.ResponseDispatch;

public class WrapperBeanGenerator
extends BaseBeanGenerator {
    public List<Class<?>> generateWrapperBeans(Class<?> sei) {
        GeneratedClassLoader cl = new GeneratedClassLoader(sei.getClassLoader());
        ArrayList classes = new ArrayList();
        for (Method m : sei.getMethods()) {
            if (m.getDeclaringClass() == Object.class) continue;
            classes.add(this.generateRequestWrapper(sei, m, cl));
            classes.add(this.generateResponseWrapper(sei, m, cl));
        }
        return classes;
    }

    public Class<?> generateRequestWrapper(Class<?> sei, Method m, GeneratedClassLoader cl) {
        String wrapperNamespace = JavaInterfaceUtil.getNamespace(sei);
        String wrapperName = m.getName();
        String wrapperBeanName = WrapperBeanGenerator.capitalize(wrapperName);
        String wrapperClassName = CodeGenerationHelper.getPackagePrefix(sei) + wrapperBeanName;
        return this.generateRequestWrapper(m, wrapperClassName, wrapperNamespace, wrapperName, cl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> generateRequestWrapper(Method m, String wrapperClassName, String wrapperNamespace, String wrapperName, GeneratedClassLoader cl) {
        Class<?> clazz = m.getDeclaringClass();
        synchronized (clazz) {
            MethodKey key = new MethodKey(m, true);
            WeakReference wr = (WeakReference)generatedClasses.get(key);
            Class<?> wrapperClass = null;
            if (wr != null) {
                wrapperClass = (Class<?>)wr.get();
            }
            if (wrapperClass == null) {
                String wrapperClassDescriptor = wrapperClassName.replace('.', '/');
                String wrapperClassSignature = "L" + wrapperClassDescriptor + ";";
                Class<?>[] paramTypes = m.getParameterTypes();
                Type[] genericParamTypes = m.getGenericParameterTypes();
                Annotation[][] paramAnnotations = m.getParameterAnnotations();
                ArrayList<BaseBeanGenerator.BeanProperty> properties = new ArrayList<BaseBeanGenerator.BeanProperty>();
                boolean asyncMethod = m.getName().endsWith("Async") && paramTypes.length > 0 && ResponseDispatch.class.equals(paramTypes[paramTypes.length - 1]);
                int length = paramTypes.length;
                if (asyncMethod) {
                    --length;
                }
                for (int i = 0; i < length; ++i) {
                    String propNS = "";
                    String propName = "arg" + i;
                    WebParam webParam = WrapperBeanGenerator.findAnnotation(paramAnnotations[i], WebParam.class);
                    if (webParam != null && webParam.header()) continue;
                    WebParam.Mode mode = WebParam.Mode.IN;
                    if (webParam != null) {
                        mode = webParam.mode();
                        if (webParam.name().length() > 0) {
                            propName = webParam.name();
                        }
                        propNS = webParam.targetNamespace();
                    }
                    if (!mode.equals((Object)WebParam.Mode.IN) && !mode.equals((Object)WebParam.Mode.INOUT)) continue;
                    Type genericParamType = WrapperBeanGenerator.getHolderValueType(genericParamTypes[i]);
                    Class<?> paramType = CodeGenerationHelper.getErasure(genericParamType);
                    BaseBeanGenerator.BeanProperty prop = new BaseBeanGenerator.BeanProperty(propNS, propName, paramType, genericParamType, true);
                    prop.getJaxbAnnotaions().addAll(WrapperBeanGenerator.findJAXBAnnotations(paramAnnotations[i]));
                    properties.add(prop);
                }
                wrapperClass = this.generate(wrapperClassDescriptor, wrapperClassSignature, wrapperNamespace, wrapperName, properties.toArray(new BaseBeanGenerator.BeanProperty[properties.size()]), cl);
                generatedClasses.put(key, new WeakReference(wrapperClass));
            }
            return wrapperClass;
        }
    }

    public Class<?> generateResponseWrapper(Class<?> sei, Method m, GeneratedClassLoader cl) {
        String wrapperNamespace = JavaInterfaceUtil.getNamespace(sei);
        String wrapperName = m.getName() + "Response";
        String wrapperBeanName = WrapperBeanGenerator.capitalize(wrapperName);
        String wrapperClassName = CodeGenerationHelper.getPackagePrefix(sei) + wrapperBeanName;
        return this.generateResponseWrapper(m, wrapperClassName, wrapperNamespace, wrapperName, cl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> generateResponseWrapper(Method m, String wrapperClassName, String wrapperNamespace, String wrapperName, GeneratedClassLoader cl) {
        Class<?> clazz = m.getDeclaringClass();
        synchronized (clazz) {
            MethodKey key = new MethodKey(m, false);
            WeakReference wr = (WeakReference)generatedClasses.get(key);
            Class<?> wrapperClass = null;
            if (wr != null) {
                wrapperClass = (Class<?>)wr.get();
            }
            if (wrapperClass == null) {
                String wrapperClassDescriptor = wrapperClassName.replace('.', '/');
                String wrapperClassSignature = "L" + wrapperClassDescriptor + ";";
                ArrayList<BaseBeanGenerator.BeanProperty> properties = new ArrayList<BaseBeanGenerator.BeanProperty>();
                Annotation[][] paramAnns = m.getParameterAnnotations();
                Class<?>[] paramTypes = m.getParameterTypes();
                Type[] genericParamTypes = m.getGenericParameterTypes();
                boolean asyncMethod = m.getName().endsWith("Async") && paramTypes.length > 0 && ResponseDispatch.class.equals(paramTypes[paramTypes.length - 1]);
                int length = paramTypes.length;
                if (asyncMethod) {
                    --length;
                }
                for (int i = 0; i < length; ++i) {
                    WebParam webParam = WrapperBeanGenerator.findAnnotation(paramAnns[i], WebParam.class);
                    if (webParam != null && (webParam.header() || webParam.mode() == WebParam.Mode.IN) || !WrapperBeanGenerator.isHolder(genericParamTypes[i])) continue;
                    List<Annotation> jaxb = WrapperBeanGenerator.findJAXBAnnotations(paramAnns[i]);
                    Type genericParamType = WrapperBeanGenerator.getHolderValueType(genericParamTypes[i]);
                    Class<?> paramType = CodeGenerationHelper.getErasure(genericParamType);
                    String paramNamespace = "";
                    String paramName = "arg" + i;
                    if (webParam != null) {
                        if (webParam.name().length() > 0) {
                            paramName = webParam.name();
                        }
                        if (webParam.targetNamespace().length() > 0) {
                            paramNamespace = webParam.targetNamespace();
                        }
                    }
                    BaseBeanGenerator.BeanProperty prop = new BaseBeanGenerator.BeanProperty(paramNamespace, paramName, paramType, genericParamType, true);
                    prop.getJaxbAnnotaions().addAll(jaxb);
                    properties.add(prop);
                }
                WebResult webResult = m.getAnnotation(WebResult.class);
                Class returnType = m.getReturnType();
                if (asyncMethod) {
                    returnType = (Class)((ParameterizedType)genericParamTypes[genericParamTypes.length - 1]).getActualTypeArguments()[0];
                }
                if (!(webResult != null && webResult.header() || returnType == Void.TYPE)) {
                    String propName = "return";
                    String propNS = "";
                    if (webResult != null) {
                        if (webResult.name().length() > 0) {
                            propName = webResult.name();
                        }
                        if (webResult.targetNamespace().length() > 1) {
                            propNS = webResult.targetNamespace();
                        }
                    }
                    List<Annotation> jaxb = WrapperBeanGenerator.findJAXBAnnotations(m.getAnnotations());
                    Type genericReturnType = asyncMethod ? returnType : m.getGenericReturnType();
                    BaseBeanGenerator.BeanProperty prop = new BaseBeanGenerator.BeanProperty(propNS, propName, returnType, genericReturnType, true);
                    prop.getJaxbAnnotaions().addAll(jaxb);
                    properties.add(0, prop);
                }
                wrapperClass = this.generate(wrapperClassDescriptor, wrapperClassSignature, wrapperNamespace, wrapperName, properties.toArray(new BaseBeanGenerator.BeanProperty[properties.size()]), cl);
                generatedClasses.put(key, new WeakReference(wrapperClass));
            }
            return wrapperClass;
        }
    }

    private static class MethodKey {
        private Method m;
        private boolean request;

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.m == null ? 0 : this.m.hashCode());
            result = 31 * result + (this.request ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MethodKey other = (MethodKey)obj;
            if (this.m == null ? other.m != null : !this.m.equals(other.m)) {
                return false;
            }
            return this.request == other.request;
        }

        public MethodKey(Method m, boolean request) {
            this.m = m;
            this.request = request;
        }
    }
}

