/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.interfacedef.wsdl.xml;

import java.io.PrintWriter;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.interfacedef.wsdl.RequiresExt;
import org.w3c.dom.Element;

public class PolicyExtensionHandler
implements ExtensionSerializer,
ExtensionDeserializer {
    @Override
    public void marshall(Class parentType, QName elementType, ExtensibilityElement theElement, PrintWriter writer, Definition def, ExtensionRegistry extReg) throws WSDLException {
        RequiresExt requires = (RequiresExt)theElement;
        QName theType = requires.getElementType();
        writer.println("<" + theType.toString() + " intents=\"");
        for (QName intentName : requires.getIntents()) {
            writer.println(intentName + " ");
        }
        writer.println("\">");
    }

    @Override
    public ExtensibilityElement unmarshall(Class theClass, QName elementType, Element theElement, Definition def, ExtensionRegistry extReg) throws WSDLException {
        if (!elementType.getLocalPart().equals("requires")) {
            return null;
        }
        RequiresExt requires = new RequiresExt();
        requires.setElementType(elementType);
        String intents = theElement.getAttribute("intents");
        String[] intentArray = intents.split(" +");
        for (int i = 0; i < intentArray.length; ++i) {
            String intentNameString = intentArray[i];
            QName intentQName = this.getQNameValue(def, intentNameString);
            requires.getIntents().add(intentQName);
        }
        return requires;
    }

    protected QName getQNameValue(Definition definition, String value) {
        if (value != null && definition != null) {
            int index = value.indexOf(58);
            String prefix = index == -1 ? "" : value.substring(0, index);
            String localName = index == -1 ? value : value.substring(index + 1);
            String ns = definition.getNamespace(prefix);
            if (ns == null) {
                ns = "";
            }
            return new QName(ns, localName, prefix);
        }
        return null;
    }
}

