/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.interfacedef.wsdl.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensionDeserializer;
import javax.wsdl.extensions.UnknownExtensionSerializer;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import org.apache.tuscany.sca.common.java.io.IOHelper;
import org.apache.tuscany.sca.common.xml.XMLDocumentHelper;
import org.apache.tuscany.sca.contribution.Artifact;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.ContributionFactory;
import org.apache.tuscany.sca.contribution.DefaultImport;
import org.apache.tuscany.sca.contribution.Import;
import org.apache.tuscany.sca.contribution.namespace.NamespaceImport;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionRuntimeException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLDefinition;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLFactory;
import org.apache.tuscany.sca.interfacedef.wsdl.impl.WSDLDefinitionImpl;
import org.apache.tuscany.sca.interfacedef.wsdl.xml.BPELExtensionHandler;
import org.apache.tuscany.sca.interfacedef.wsdl.xml.PolicyExtensionHandler;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.xsd.XSDFactory;
import org.apache.tuscany.sca.xsd.XSDefinition;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class WSDLModelResolver
implements ModelResolver {
    public static final String ELEM_SCHEMA = "schema";
    public static final QName WSDL11_IMPORT = new QName("http://schemas.xmlsoap.org/wsdl/", "import");
    public static final String NS_URI_XSD_1999 = "http://www.w3.org/1999/XMLSchema";
    public static final String NS_URI_XSD_2000 = "http://www.w3.org/2000/10/XMLSchema";
    public static final String NS_URI_XSD_2001 = "http://www.w3.org/2001/XMLSchema";
    public static final QName Q_ELEM_XSD_1999 = new QName("http://www.w3.org/1999/XMLSchema", "schema");
    public static final QName Q_ELEM_XSD_2000 = new QName("http://www.w3.org/2000/10/XMLSchema", "schema");
    public static final QName Q_ELEM_XSD_2001 = new QName("http://www.w3.org/2001/XMLSchema", "schema");
    public static final List<QName> XSD_QNAME_LIST = Arrays.asList(Q_ELEM_XSD_1999, Q_ELEM_XSD_2000, Q_ELEM_XSD_2001);
    public static final QName Q_POLICY_ATTRIBUTE_EXTENSION = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "requires");
    public static final QName Q_POLICY_ELEMENT_EXTENSION = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "requires");
    public static final QName Q_POLICY_END_CONVERSATION_ATTRIBUTE_EXTENSION = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "endsConversation");
    public static final QName Q_CALLBACK_ATTRIBUTE_EXTENSION = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "callback");
    public static final String ELEM_PLINKTYPE = "partnerLinkType";
    public static final String NS_BPEL_1_1 = "http://schemas.xmlsoap.org/ws/2004/03/partner-link/";
    public static final QName BPEL_PLINKTYPE = new QName("http://schemas.xmlsoap.org/ws/2004/03/partner-link/", "partnerLinkType");
    public static final String NS_BPEL_2_0 = "http://docs.oasis-open.org/wsbpel/2.0/plnktype";
    public static final QName BPEL_PLINKTYPE_2_0 = new QName("http://docs.oasis-open.org/wsbpel/2.0/plnktype", "partnerLinkType");
    private Contribution contribution;
    private Map<String, List<WSDLDefinition>> map = new HashMap<String, List<WSDLDefinition>>();
    private ExtensionRegistry wsdlExtensionRegistry;
    private WSDLFactory wsdlFactory;
    private javax.wsdl.factory.WSDLFactory wsdl4jFactory;
    private ContributionFactory contributionFactory;
    private XSDFactory xsdFactory;

    public WSDLModelResolver(Contribution contribution, FactoryExtensionPoint modelFactories) {
        this.contribution = contribution;
        this.wsdlFactory = modelFactories.getFactory(WSDLFactory.class);
        this.wsdl4jFactory = modelFactories.getFactory(javax.wsdl.factory.WSDLFactory.class);
        this.contributionFactory = modelFactories.getFactory(ContributionFactory.class);
        this.xsdFactory = modelFactories.getFactory(XSDFactory.class);
        this.wsdlExtensionRegistry = this.wsdl4jFactory.newPopulatedExtensionRegistry();
        ExtensionDeserializer deserializer = new UnknownExtensionDeserializer();
        ExtensionSerializer serializer = new UnknownExtensionSerializer();
        for (QName schema : XSD_QNAME_LIST) {
            this.wsdlExtensionRegistry.registerSerializer(Types.class, schema, serializer);
            this.wsdlExtensionRegistry.registerDeserializer(Types.class, schema, deserializer);
        }
        try {
            this.wsdlExtensionRegistry.registerExtensionAttributeType(PortType.class, Q_POLICY_ATTRIBUTE_EXTENSION, 3);
            this.wsdlExtensionRegistry.registerExtensionAttributeType(Operation.class, Q_POLICY_END_CONVERSATION_ATTRIBUTE_EXTENSION, 0);
            this.wsdlExtensionRegistry.registerExtensionAttributeType(PortType.class, Q_CALLBACK_ATTRIBUTE_EXTENSION, 1);
            serializer = new PolicyExtensionHandler();
            deserializer = new PolicyExtensionHandler();
            this.wsdlExtensionRegistry.registerSerializer(PortType.class, Q_POLICY_ELEMENT_EXTENSION, serializer);
            this.wsdlExtensionRegistry.registerDeserializer(PortType.class, Q_POLICY_ELEMENT_EXTENSION, deserializer);
        }
        catch (NoSuchMethodError e) {
            // empty catch block
        }
        serializer = new BPELExtensionHandler();
        deserializer = new BPELExtensionHandler();
        this.wsdlExtensionRegistry.registerSerializer(Definition.class, BPEL_PLINKTYPE, serializer);
        this.wsdlExtensionRegistry.registerDeserializer(Definition.class, BPEL_PLINKTYPE, deserializer);
        this.wsdlExtensionRegistry.registerSerializer(Definition.class, BPEL_PLINKTYPE_2_0, serializer);
        this.wsdlExtensionRegistry.registerDeserializer(Definition.class, BPEL_PLINKTYPE_2_0, deserializer);
    }

    @Override
    public void addModel(Object resolved, ProcessorContext context) {
        WSDLDefinition definition = (WSDLDefinition)resolved;
        for (XSDefinition d : definition.getXmlSchemas()) {
            if (this.contribution == null) continue;
            this.contribution.getModelResolver().addModel(d, context);
        }
        List<WSDLDefinition> list = this.map.get(definition.getNamespace());
        if (list == null) {
            list = new ArrayList<WSDLDefinition>();
            this.map.put(definition.getNamespace(), list);
        }
        list.add(definition);
    }

    @Override
    public Object removeModel(Object resolved, ProcessorContext context) {
        WSDLDefinition definition = (WSDLDefinition)resolved;
        List<WSDLDefinition> list = this.map.get(definition.getNamespace());
        if (list == null) {
            return null;
        }
        return list.remove(definition);
    }

    private WSDLDefinition aggregate(List<WSDLDefinition> definitions, ProcessorContext context) throws ContributionReadException {
        if (definitions == null || definitions.size() == 0) {
            return null;
        }
        if (definitions.size() == 1) {
            WSDLDefinition d = definitions.get(0);
            this.loadDefinition(d, context);
            return d;
        }
        WSDLDefinition aggregated = this.wsdlFactory.createWSDLDefinition();
        for (WSDLDefinition d : definitions) {
            this.loadDefinition(d, context);
        }
        Definition facade = this.wsdl4jFactory.newDefinition();
        String ns = definitions.get(0).getNamespace();
        facade.setQName(new QName(ns, "$aggregated$"));
        facade.setTargetNamespace(ns);
        for (WSDLDefinition d : definitions) {
            if (d.getDefinition() == null) continue;
            javax.wsdl.Import imp = facade.createImport();
            imp.setNamespaceURI(d.getNamespace());
            imp.setDefinition(d.getDefinition());
            imp.setLocationURI(d.getDefinition().getDocumentBaseURI());
            facade.addImport(imp);
            aggregated.getImportedDefinitions().add(d);
            List extElements = d.getDefinition().getExtensibilityElements();
            for (ExtensibilityElement extElement : extElements) {
                facade.addExtensibilityElement(extElement);
            }
        }
        aggregated.setDefinition(facade);
        definitions.clear();
        definitions.add(aggregated);
        return aggregated;
    }

    @Override
    public <T> T resolveModel(Class<T> modelClass, T unresolved, ProcessorContext context) {
        WSDLDefinition resolved = null;
        String namespace = ((WSDLDefinition)unresolved).getNamespace();
        if (namespace == null) {
            return modelClass.cast(unresolved);
        }
        if (((WSDLDefinition)unresolved).getWsdliLocations().containsKey(namespace)) {
            try {
                this.loadDefinition((WSDLDefinition)unresolved, context);
            }
            catch (ContributionReadException e) {
                context.getMonitor();
                Monitor.error(context.getMonitor(), (Object)this, "interface-wsdlxml-validation-messages", "wsdliLocationException", e, ((WSDLDefinition)unresolved).getNamespace());
            }
            return modelClass.cast((WSDLDefinition)unresolved);
        }
        for (Import import_ : this.contribution.getImports()) {
            NamespaceImport namespaceImport;
            if (!(import_ instanceof NamespaceImport ? (namespaceImport = (NamespaceImport)import_).getNamespace().equals(namespace) && !(resolved = namespaceImport.getModelResolver().resolveModel(WSDLDefinition.class, (WSDLDefinition)unresolved, context)).isUnresolved() : import_ instanceof DefaultImport && !(resolved = import_.getModelResolver().resolveModel(WSDLDefinition.class, (WSDLDefinition)unresolved, context)).isUnresolved())) continue;
            return modelClass.cast(resolved);
        }
        List<WSDLDefinition> list = this.map.get(namespace);
        try {
            resolved = this.aggregate(list, context);
        }
        catch (ContributionReadException e) {
            throw new RuntimeException(e);
        }
        if (resolved != null && !resolved.isUnresolved()) {
            WSDLDefinition inputWSDL = (WSDLDefinition)unresolved;
            WSDLDefinition outputWSDL = resolved;
            if (inputWSDL.getNameOfPortTypeToResolve() != null && outputWSDL.getWSDLObject(PortType.class, inputWSDL.getNameOfPortTypeToResolve()) == null) {
                return modelClass.cast(unresolved);
            }
            if (inputWSDL.getNameOfBindingToResolve() != null && outputWSDL.getWSDLObject(Binding.class, inputWSDL.getNameOfBindingToResolve()) == null) {
                return modelClass.cast(unresolved);
            }
            if (inputWSDL.getNameOfServiceToResolve() != null && outputWSDL.getWSDLObject(Service.class, inputWSDL.getNameOfServiceToResolve()) == null) {
                return modelClass.cast(unresolved);
            }
            return modelClass.cast(resolved);
        }
        return modelClass.cast(unresolved);
    }

    private <T> T resolveImports(Class<T> modelClass, WSDLDefinition unresolved, ProcessorContext context) throws ContributionReadException {
        WSDLDefinition resolved = null;
        if (unresolved.getDefinition() == null && unresolved.getLocation() != null) {
            try {
                ArrayList<WSDLDefinition> list = new ArrayList<WSDLDefinition>();
                list.add(unresolved);
                this.map.put(unresolved.getNamespace(), list);
                resolved = this.aggregate(list, context);
                if (unresolved.getNamespace().equals(resolved.getDefinition().getTargetNamespace())) {
                    resolved.setNamespace(resolved.getDefinition().getTargetNamespace());
                    resolved.setUnresolved(false);
                    resolved.setURI(unresolved.getURI());
                    return modelClass.cast(resolved);
                }
            }
            catch (ContributionReadException e) {
                for (Artifact artifact : this.contribution.getArtifacts()) {
                    if (!(artifact.getModel() instanceof WSDLDefinitionImpl)) continue;
                    String namespace = ((WSDLDefinitionImpl)artifact.getModel()).getNamespace();
                    if (!unresolved.getNamespace().equals(namespace)) continue;
                    WSDLDefinition wsdlDefinition = (WSDLDefinition)artifact.getModel();
                    if (wsdlDefinition.getDefinition() == null) {
                        this.loadDefinition(wsdlDefinition, context);
                    }
                    return modelClass.cast(wsdlDefinition);
                }
            }
        }
        return modelClass.cast(unresolved);
    }

    private void loadDefinition(WSDLDefinition wsdlDef, ProcessorContext context) throws ContributionReadException {
        if (wsdlDef.getDefinition() != null) {
            return;
        }
        try {
            URL artifactURL;
            String loc = wsdlDef.getWsdliLocations().get(wsdlDef.getNamespace());
            if (loc != null) {
                artifactURL = new URL(loc);
            } else {
                if (wsdlDef.getLocation() == null) {
                    return;
                }
                artifactURL = wsdlDef.getLocation().toURL();
            }
            InputStream is = IOHelper.openStream(artifactURL);
            WSDLReader reader = this.wsdl4jFactory.newWSDLReader();
            reader.setFeature("javax.wsdl.verbose", false);
            reader.setFeature("javax.wsdl.importDocuments", true);
            reader.setExtensionRegistry(this.wsdlExtensionRegistry);
            Map<String, String> wsdlImports = this.indexRead(artifactURL);
            wsdlImports.putAll(wsdlDef.getWsdliLocations());
            WSDLLocatorImpl locator = new WSDLLocatorImpl(context, artifactURL, is, wsdlImports);
            Definition definition = reader.readWSDL(locator);
            wsdlDef.setDefinition(definition);
            for (Map.Entry entry : definition.getImports().entrySet()) {
                if (((String)entry.getKey()).equals(definition.getTargetNamespace())) continue;
                WSDLDefinition wsdlDefinition = this.wsdlFactory.createWSDLDefinition();
                wsdlDefinition.setUnresolved(true);
                wsdlDefinition.setNamespace((String)entry.getKey());
                WSDLDefinition resolved = null;
                block7: for (javax.wsdl.Import imp : (List)entry.getValue()) {
                    if (imp.getDefinition() == null) {
                        throw new IllegalArgumentException("Required attribute 'location' is missing.");
                    }
                    try {
                        wsdlDefinition.setLocation(new URI(imp.getDefinition().getDocumentBaseURI()));
                        wsdlDefinition.setURI(new URI(imp.getLocationURI()));
                        resolved = this.resolveImports(WSDLDefinition.class, wsdlDefinition, context);
                        if (resolved.isUnresolved()) continue;
                        if (resolved.getImportedDefinitions().isEmpty()) {
                            if (!resolved.getDefinition().getTargetNamespace().equals(imp.getDefinition().getTargetNamespace())) continue;
                            wsdlDef.getImportedDefinitions().add(resolved);
                            imp.setLocationURI(resolved.getURI().toString());
                            continue;
                        }
                        for (WSDLDefinition def : resolved.getImportedDefinitions()) {
                            if (!def.getDefinition().getTargetNamespace().equals(imp.getDefinition().getTargetNamespace())) continue;
                            wsdlDef.getImportedDefinitions().add(def);
                            imp.setLocationURI(def.getURI().toString());
                            continue block7;
                        }
                    }
                    catch (Exception e) {
                        throw new ContributionReadException(e);
                    }
                }
            }
            this.readInlineSchemas(wsdlDef, definition, context);
        }
        catch (WSDLException e) {
            throw new ContributionReadException(e);
        }
        catch (XMLStreamException e) {
            throw new ContributionReadException(e);
        }
        catch (IOException e) {
            throw new ContributionReadException(e);
        }
    }

    private Document promote(Element element) {
        Document doc = (Document)element.getOwnerDocument().cloneNode(false);
        Element schema = (Element)doc.importNode(element, true);
        doc.appendChild(schema);
        Node parent = element.getParentNode();
        while (parent instanceof Element) {
            Element root = (Element)parent;
            NamedNodeMap nodeMap = root.getAttributes();
            if (nodeMap != null) {
                for (int i = 0; i < nodeMap.getLength(); ++i) {
                    Attr attr = (Attr)nodeMap.item(i);
                    String name = attr.getName();
                    if (!"xmlns".equals(name) && !name.startsWith("xmlns:") || schema.getAttributeNode(name) != null) continue;
                    schema.setAttributeNodeNS((Attr)doc.importNode(attr, true));
                }
            }
            parent = parent.getParentNode();
        }
        doc.setDocumentURI(element.getOwnerDocument().getDocumentURI());
        return doc;
    }

    private void readInlineSchemas(WSDLDefinition wsdlDefinition, Definition definition, ProcessorContext context) {
        if (this.contribution == null) {
            return;
        }
        Types types = definition.getTypes();
        if (types != null) {
            int index = 0;
            for (Object ext : types.getExtensibilityElements()) {
                ExtensibilityElement extElement = (ExtensibilityElement)ext;
                Element element = null;
                if (XSD_QNAME_LIST.contains(extElement.getElementType())) {
                    if (extElement instanceof Schema) {
                        element = ((Schema)extElement).getElement();
                    } else if (extElement instanceof UnknownExtensibilityElement) {
                        element = ((UnknownExtensibilityElement)extElement).getElement();
                    }
                }
                if (element == null) continue;
                Document doc = this.promote(element);
                XSDefinition xsDefinition = this.xsdFactory.createXSDefinition();
                xsDefinition.setUnresolved(true);
                xsDefinition.setNamespace(element.getAttribute("targetNamespace"));
                xsDefinition.setDocument(doc);
                xsDefinition.setLocation(URI.create(doc.getDocumentURI() + "#" + index));
                XSDefinition resolved = this.contribution.getModelResolver().resolveModel(XSDefinition.class, xsDefinition, context);
                if (resolved != null && !resolved.isUnresolved() && !wsdlDefinition.getXmlSchemas().contains(resolved)) {
                    wsdlDefinition.getXmlSchemas().add(xsDefinition);
                }
                ++index;
            }
        }
        for (Object imports : definition.getImports().values()) {
            List impList = (List)imports;
            for (Object i : impList) {
                javax.wsdl.Import anImport = (javax.wsdl.Import)i;
                if (anImport.getDefinition() == null) continue;
                this.readInlineSchemas(wsdlDefinition, anImport.getDefinition(), context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, String> indexRead(URL doc) throws IOException, XMLStreamException {
        HashMap<String, String> wsdlImports = new HashMap<String, String>();
        InputStream is = doc.openStream();
        try {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            StreamSource wsdlSource = new StreamSource(is, doc.toString());
            XMLStreamReader reader = inputFactory.createXMLStreamReader(wsdlSource);
            int eventType = reader.getEventType();
            while (true) {
                if (eventType == 1 && WSDL11_IMPORT.equals(reader.getName())) {
                    String ns = reader.getAttributeValue(null, "namespace");
                    String loc = reader.getAttributeValue(null, "location");
                    wsdlImports.put(ns, loc);
                }
                if (!reader.hasNext()) break;
                eventType = reader.next();
            }
            HashMap<String, String> hashMap = wsdlImports;
            return hashMap;
        }
        finally {
            is.close();
        }
    }

    private class WSDLLocatorImpl
    implements WSDLLocator {
        private ProcessorContext context;
        private InputStream inputStream;
        private URL base;
        private String latestImportURI;
        private Map<String, String> wsdlImports;

        public WSDLLocatorImpl(ProcessorContext context, URL base, InputStream is, Map<String, String> imports) {
            this.context = context;
            this.base = base;
            this.inputStream = is;
            this.wsdlImports = imports;
        }

        @Override
        public void close() {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public InputSource getBaseInputSource() {
            try {
                return XMLDocumentHelper.getInputSource(this.base, this.inputStream);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }

        @Override
        public String getBaseURI() {
            return this.base.toString();
        }

        @Override
        public InputSource getImportInputSource(String parentLocation, String importLocation) {
            try {
                if (importLocation == null) {
                    throw new IllegalArgumentException("Required attribute 'location' is missing.");
                }
                if (importLocation.trim().equals("")) {
                    throw new IllegalArgumentException("Required attribute 'location' is empty.");
                }
                URL url = null;
                if (importLocation.startsWith("/")) {
                    String uri = importLocation.substring(1);
                    Artifact proxyArtifact = WSDLModelResolver.this.contributionFactory.createArtifact();
                    proxyArtifact.setURI(uri);
                    Artifact importedArtifact = WSDLModelResolver.this.contribution.getModelResolver().resolveModel(Artifact.class, proxyArtifact, this.context);
                    if (importedArtifact.getLocation() != null) {
                        url = new URL(importedArtifact.getLocation());
                    }
                } else {
                    url = new URL(new URL(parentLocation), importLocation);
                }
                if (url == null) {
                    return null;
                }
                this.latestImportURI = url.toString();
                return XMLDocumentHelper.getInputSource(url);
            }
            catch (IOException e) {
                try {
                    if (!this.wsdlImports.isEmpty()) {
                        for (Artifact artifact : WSDLModelResolver.this.contribution.getArtifacts()) {
                            if (!(artifact.getModel() instanceof WSDLDefinitionImpl)) continue;
                            String namespace = ((WSDLDefinitionImpl)artifact.getModel()).getNamespace();
                            for (Map.Entry<String, String> entry : this.wsdlImports.entrySet()) {
                                if (!entry.getKey().equals(namespace)) continue;
                                URL url = ((WSDLDefinitionImpl)artifact.getModel()).getLocation().toURL();
                                return XMLDocumentHelper.getInputSource(url);
                            }
                        }
                    }
                }
                catch (IOException ex) {
                    throw new ContributionRuntimeException(ex);
                }
                throw new ContributionRuntimeException(e);
            }
        }

        @Override
        public String getLatestImportURI() {
            return this.latestImportURI;
        }
    }
}

