/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.node.impl;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.common.java.io.IOHelper;
import org.apache.tuscany.sca.contribution.Artifact;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.ValidationSchemaExtensionPoint;
import org.apache.tuscany.sca.core.DefaultExtensionPointRegistry;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.core.ModuleActivatorExtensionPoint;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.core.assembly.RuntimeAssemblyFactory;
import org.apache.tuscany.sca.core.invocation.ExtensibleProxyFactory;
import org.apache.tuscany.sca.core.invocation.ProxyFactory;
import org.apache.tuscany.sca.deployment.Deployer;
import org.apache.tuscany.sca.extensibility.ServiceDiscovery;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.MonitorFactory;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.node.Node;
import org.apache.tuscany.sca.node.NodeFactory;
import org.apache.tuscany.sca.node.configuration.BindingConfiguration;
import org.apache.tuscany.sca.node.configuration.ContributionConfiguration;
import org.apache.tuscany.sca.node.configuration.DefaultNodeConfigurationFactory;
import org.apache.tuscany.sca.node.configuration.DeploymentComposite;
import org.apache.tuscany.sca.node.configuration.NodeConfiguration;
import org.apache.tuscany.sca.node.extensibility.NodeExtension;
import org.apache.tuscany.sca.node.impl.NodeImpl;
import org.apache.tuscany.sca.runtime.ExtensibleDomainRegistryFactory;
import org.apache.tuscany.sca.runtime.RuntimeProperties;
import org.apache.tuscany.sca.work.WorkScheduler;
import org.oasisopen.sca.ServiceRuntimeException;

public class NodeFactoryImpl
extends NodeFactory {
    protected static final Logger logger = Logger.getLogger(NodeImpl.class.getName());
    protected boolean inited;
    protected Map<Object, Node> nodes = new ConcurrentHashMap<Object, Node>();
    protected Deployer deployer;
    protected ExtensionPointRegistry registry;
    protected ProxyFactory proxyFactory;
    protected MonitorFactory monitorFactory;
    protected boolean autoDestroy = true;
    boolean quietLogging;

    @Override
    public Node createNode(NodeConfiguration configuration) {
        if (configuration.getURI() == null) {
            configuration.setURI(this.generateNodeURI());
        }
        return new NodeImpl(this, configuration);
    }

    protected Node removeNode(NodeConfiguration configuration) {
        Node node = this.nodes.remove(this.getNodeKey(configuration));
        if (this.autoDestroy && this.nodes.isEmpty()) {
            this.destroy();
        }
        return node;
    }

    @Override
    public Node createNode(List<?> contributions) {
        DefaultNodeConfigurationFactory nodeConfigurationFactory = new DefaultNodeConfigurationFactory();
        return new NodeImpl(this, nodeConfigurationFactory.createNodeConfiguration(), new ArrayList<Contribution>(contributions));
    }

    protected void addNode(NodeConfiguration configuration, Node node) {
        this.nodes.put(this.getNodeKey(configuration), node);
    }

    @Override
    public NodeConfiguration loadConfiguration(InputStream xml, URL base) {
        try {
            this.init();
            InputStreamReader reader = new InputStreamReader(xml, "UTF-8");
            ProcessorContext context = this.deployer.createProcessorContext();
            NodeConfiguration config = (NodeConfiguration)this.deployer.loadXMLDocument(reader, context.getMonitor());
            if (base != null && config != null) {
                for (ContributionConfiguration c : config.getContributions()) {
                    String location = c.getLocation();
                    if (location == null) continue;
                    URL url = new URL(base, location);
                    url = IOHelper.normalize(url);
                    c.setLocation(url.toString());
                }
            }
            return config;
        }
        catch (Throwable e) {
            throw new ServiceRuntimeException(e);
        }
    }

    public Map<Object, Node> getNodes() {
        return this.nodes;
    }

    public List<Node> getNodesInDomain(String domainName) {
        ArrayList<Node> domainNodes = new ArrayList<Node>();
        if (this.nodes != null) {
            for (Node n : this.nodes.values()) {
                if (!domainName.equals(((NodeImpl)n).getConfiguration().getDomainURI())) continue;
                domainNodes.add(n);
            }
        }
        return domainNodes;
    }

    protected Object getNodeKey(NodeConfiguration configuration) {
        return new NodeKey(configuration);
    }

    @Override
    public synchronized void destroy() {
        if (this.inited) {
            for (Node node : this.nodes.values()) {
                node.stop();
            }
            this.nodes.clear();
            this.deployer.stop();
            this.registry.stop();
            super.destroy();
            this.inited = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyzeProblems(Monitor monitor) throws Throwable {
        try {
            for (Problem problem : monitor.getProblems()) {
                if (problem.getSeverity() != Problem.Severity.ERROR) continue;
                if (problem.getCause() != null) {
                    throw problem.getCause();
                }
                throw new ServiceRuntimeException(problem.toString());
            }
        }
        finally {
            monitor.reset();
        }
    }

    private boolean attachDeploymentComposite(Contribution contribution, Reader xml, String location, boolean attached, ProcessorContext context) throws XMLStreamException, ContributionReadException {
        Composite composite = (Composite)this.deployer.loadXMLDocument(xml, context.getMonitor());
        this.deployer.attachDeploymentComposite(contribution, composite, attached);
        if (!attached) {
            attached = true;
        }
        return attached;
    }

    @Override
    public ExtensionPointRegistry getExtensionPointRegistry() {
        if (this.registry == null) {
            this.registry = this.createExtensionPointRegistry();
            this.registry.start();
        }
        return this.registry;
    }

    @Override
    public synchronized void init() {
        if (this.inited) {
            return;
        }
        long start = System.currentTimeMillis();
        this.getExtensionPointRegistry();
        UtilityExtensionPoint utilities = this.registry.getExtensionPoint(UtilityExtensionPoint.class);
        this.monitorFactory = utilities.getUtility(MonitorFactory.class);
        utilities.getUtility(RuntimeProperties.class).setProperties(this.properties);
        this.quietLogging = Boolean.parseBoolean(this.properties.getProperty("org.apache.tuscany.sca.quietLogging"));
        FactoryExtensionPoint modelFactories = this.registry.getExtensionPoint(FactoryExtensionPoint.class);
        RuntimeAssemblyFactory assemblyFactory = new RuntimeAssemblyFactory(this.registry);
        modelFactories.addFactory(assemblyFactory);
        this.deployer = utilities.getUtility(Deployer.class);
        this.deployer.setSchemaValidationEnabled(this.isSchemaValidationEnabled());
        this.registry.getExtensionPoint(ModuleActivatorExtensionPoint.class);
        this.proxyFactory = ExtensibleProxyFactory.getInstance(this.registry);
        utilities.getUtility(WorkScheduler.class);
        this.inited = true;
        if (logger.isLoggable(Level.FINE)) {
            long end = System.currentTimeMillis();
            logger.fine("The tuscany runtime started in " + (end - start) + " ms.");
        }
    }

    public void start() {
        this.init();
        ExtensibleDomainRegistryFactory domainRegistryFactory = ExtensibleDomainRegistryFactory.getInstance(this.registry);
        domainRegistryFactory.getEndpointRegistry(this.properties.getProperty("reguri"), this.properties.getProperty("defaultDomainName"));
    }

    protected ExtensionPointRegistry createExtensionPointRegistry() {
        return new DefaultExtensionPointRegistry();
    }

    protected boolean isSchemaValidationEnabled() {
        String enabled = NodeFactoryImpl.getSystemProperty(ValidationSchemaExtensionPoint.class.getName() + ".enabled");
        if (enabled == null) {
            enabled = "true";
        }
        boolean debug = logger.isLoggable(Level.FINE);
        return "true".equals(enabled) || debug;
    }

    protected Composite configureNode(NodeConfiguration configuration, List<Contribution> contributions, ProcessorContext context) throws Throwable {
        if (contributions == null) {
            contributions = this.loadContributions(configuration, context);
        }
        Monitor monitor = context.getMonitor();
        HashMap<QName, List<String>> bindingBaseURIs = new HashMap<QName, List<String>>();
        for (BindingConfiguration config : configuration.getBindings()) {
            bindingBaseURIs.put(config.getBindingType(), config.getBaseURIs());
        }
        List<Contribution> allContributions = this.getAllContributions(configuration.getDomainURI());
        Composite domainComposite = this.deployer.build(contributions, allContributions, bindingBaseURIs, monitor);
        this.analyzeProblems(monitor);
        return domainComposite;
    }

    private List<Contribution> getAllContributions(String domainName) {
        ArrayList<Contribution> contributions = new ArrayList<Contribution>();
        for (NodeFactory f : NodeFactoryImpl.getNodeFactories()) {
            for (Node node : ((NodeFactoryImpl)f).getNodesInDomain(domainName)) {
                contributions.addAll(((NodeImpl)node).getContributions());
            }
        }
        return contributions;
    }

    protected List<Contribution> loadContributions(NodeConfiguration configuration, ProcessorContext context) throws Throwable {
        ArrayList<Contribution> contributions = new ArrayList<Contribution>();
        for (ContributionConfiguration contrib : configuration.getContributions()) {
            URI contributionURI = IOHelper.createURI(contrib.getURI());
            URI uri = IOHelper.createURI(contrib.getLocation());
            if (uri != null && uri.getScheme() == null) {
                uri = new File(contrib.getLocation()).toURI();
            }
            URL contributionURL = null;
            if (uri != null) {
                contributionURL = uri.toURL();
            }
            logger.log(this.quietLogging ? Level.FINE : Level.INFO, "Loading contribution: " + contributionURL);
            Contribution contribution = this.deployer.loadContribution(contributionURI, contributionURL, context.getMonitor());
            contributions.add(contribution);
            boolean attached = false;
            for (DeploymentComposite dc : contrib.getDeploymentComposites()) {
                if (dc.getContent() != null) {
                    StringReader xml = new StringReader(dc.getContent());
                    attached = this.attachDeploymentComposite(contribution, xml, null, attached, context);
                    continue;
                }
                if (dc.getLocation() == null) continue;
                URI dcURI = IOHelper.createURI(dc.getLocation());
                if (!dcURI.isAbsolute()) {
                    Composite composite = null;
                    for (Artifact a : contribution.getArtifacts()) {
                        if (!dcURI.toString().equals(a.getURI())) continue;
                        composite = (Composite)a.getModel();
                        if (!attached) {
                            contribution.getDeployables().clear();
                            attached = true;
                        }
                        contribution.getDeployables().add(composite);
                        break;
                    }
                    if (composite != null) continue;
                    throw new ServiceRuntimeException("Deployment composite " + dcURI + " cannot be found within contribution " + contribution.getLocation());
                }
                URL url = dcURI.toURL();
                InputStream is = IOHelper.openStream(url);
                InputStreamReader xml = new InputStreamReader(is, "UTF-8");
                attached = this.attachDeploymentComposite(contribution, xml, url.toString(), attached, context);
            }
            this.analyzeProblems(context.getMonitor());
        }
        return contributions;
    }

    protected static String getSystemProperty(final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(name);
            }
        });
    }

    @Override
    public void configure(Map<String, Map<String, String>> attributes) {
        ServiceDiscovery discovery = this.getExtensionPointRegistry().getServiceDiscovery();
        for (Map.Entry<String, Map<String, String>> e : attributes.entrySet()) {
            discovery.setAttribute(e.getKey(), e.getValue());
        }
        for (Object o : this.properties.keySet()) {
            String p = (String)o;
            if (p.indexOf(46) <= -1) continue;
            String serviceType = p.substring(0, p.lastIndexOf(46));
            String attribute = p.substring(p.lastIndexOf(46) + 1);
            discovery.setAttribute(serviceType, attribute, this.properties.getProperty(p));
        }
        this.quietLogging = Boolean.parseBoolean(this.properties.getProperty("org.apache.tuscany.sca.quietLogging"));
        super.configure(attributes);
    }

    public Deployer getDeployer() {
        return this.deployer;
    }

    @Override
    public void setAutoDestroy(boolean b) {
        this.autoDestroy = b;
    }

    @Override
    public NodeExtension loadNode(NodeConfiguration configuration) {
        Node node = this.createNode(configuration);
        try {
            NodeImpl nodeImpl = (NodeImpl)node;
            nodeImpl.load();
            return nodeImpl;
        }
        catch (Throwable e) {
            throw new ServiceRuntimeException(e);
        }
    }

    protected static class NodeKey {
        private String domainURI;
        private String nodeURI;

        public NodeKey(NodeConfiguration configuration) {
            this.domainURI = configuration.getDomainURI();
            this.nodeURI = configuration.getURI();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.domainURI == null ? 0 : this.domainURI.hashCode());
            result = 31 * result + (this.nodeURI == null ? 0 : this.nodeURI.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NodeKey other = (NodeKey)obj;
            if (this.domainURI == null ? other.domainURI != null : !this.domainURI.equals(other.domainURI)) {
                return false;
            }
            return !(this.nodeURI == null ? other.nodeURI != null : !this.nodeURI.equals(other.nodeURI));
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            if (this.domainURI != null) {
                buf.append("{").append(this.domainURI).append("}");
            }
            if (this.nodeURI != null) {
                buf.append(this.nodeURI);
            }
            return buf.toString();
        }
    }
}

