/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.LifeCycleListener;
import org.apache.tuscany.sca.runtime.DomainRegistry;
import org.apache.tuscany.sca.runtime.DomainRegistryFactory;
import org.apache.tuscany.sca.runtime.EndpointListener;

public abstract class BaseDomainRegistryFactory
implements DomainRegistryFactory,
LifeCycleListener {
    protected ExtensionPointRegistry registry;
    protected Map<Object, DomainRegistry> domainRegistries = new ConcurrentHashMap<Object, DomainRegistry>();
    protected List<EndpointListener> listeners = new ArrayList<EndpointListener>();

    public BaseDomainRegistryFactory(ExtensionPointRegistry registry) {
        this.registry = registry;
    }

    @Override
    public void start() {
    }

    @Override
    public synchronized DomainRegistry getEndpointRegistry(String endpointRegistryURI, String domainURI) {
        Object key;
        DomainRegistry domainRegistry;
        if (endpointRegistryURI == null) {
            endpointRegistryURI = domainURI;
        }
        if ((domainRegistry = this.domainRegistries.get(key = this.getKey(endpointRegistryURI, domainURI))) != null) {
            return domainRegistry;
        }
        domainRegistry = this.createEndpointRegistry(endpointRegistryURI, domainURI);
        if (domainRegistry instanceof LifeCycleListener) {
            ((LifeCycleListener)((Object)domainRegistry)).start();
        }
        for (EndpointListener listener : this.listeners) {
            domainRegistry.addEndpointListener(listener);
        }
        this.domainRegistries.put(key, domainRegistry);
        return domainRegistry;
    }

    protected Object getKey(String endpointRegistryURI, String domainURI) {
        return endpointRegistryURI + "," + domainURI;
    }

    protected abstract DomainRegistry createEndpointRegistry(String var1, String var2);

    @Override
    public void stop() {
        for (DomainRegistry domainRegistry : this.domainRegistries.values()) {
            if (!(domainRegistry instanceof LifeCycleListener)) continue;
            ((LifeCycleListener)((Object)domainRegistry)).stop();
        }
        this.domainRegistries.clear();
        this.listeners.clear();
    }

    @Override
    public synchronized Collection<DomainRegistry> getEndpointRegistries() {
        return new ArrayList<DomainRegistry>(this.domainRegistries.values());
    }

    @Override
    public synchronized void addListener(EndpointListener listener) {
        this.listeners.add(listener);
        for (DomainRegistry registry : this.domainRegistries.values()) {
            registry.addEndpointListener(listener);
        }
    }

    public synchronized List<EndpointListener> getListeners() {
        return this.listeners;
    }

    @Override
    public synchronized void removeListener(EndpointListener listener) {
        this.listeners.remove(listener);
        for (DomainRegistry registry : this.domainRegistries.values()) {
            registry.removeEndpointListener(listener);
        }
    }
}

