/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.runtime;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.Export;
import org.apache.tuscany.sca.contribution.Import;
import org.apache.tuscany.sca.contribution.java.JavaExport;
import org.apache.tuscany.sca.contribution.java.JavaImport;
import org.apache.tuscany.sca.contribution.namespace.NamespaceExport;
import org.apache.tuscany.sca.contribution.namespace.NamespaceImport;

public class ContributionDescription
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String uri;
    private String url;
    private List<String> dependentContributionURIs = new ArrayList<String>();
    private List<String> deployables = new ArrayList<String>();
    private List<String> javaExports = new ArrayList<String>();
    private List<String> namespaceExports = new ArrayList<String>();
    private List<String> javaImports = new ArrayList<String>();
    private List<String> namespaceImports = new ArrayList<String>();
    private Map<String, String> additionalDeployables = new HashMap<String, String>();

    public ContributionDescription(String url) {
        this(null, url);
    }

    public ContributionDescription(String uri, String url) {
        this.url = url;
        this.uri = uri;
        if (uri == null || uri.length() < 1) {
            this.uri = this.deriveContributionURI(url);
        }
    }

    public String getURI() {
        return this.uri;
    }

    public String getURL() {
        return this.url;
    }

    public List<String> getDeployables() {
        return this.deployables;
    }

    public void setDeployables(List<String> deployables) {
        this.deployables = deployables;
    }

    public List<String> getDependentContributionURIs() {
        return this.dependentContributionURIs;
    }

    public Map<String, String> getAdditionalDeployables() {
        return this.additionalDeployables;
    }

    public List<String> getJavaExports() {
        return this.javaExports;
    }

    public List<String> getNamespaceExports() {
        return this.namespaceExports;
    }

    public List<String> getJavaImports() {
        return this.javaImports;
    }

    public List<String> getNamespaceImports() {
        return this.namespaceImports;
    }

    public void configureMetaData(Contribution contribution) {
        if (contribution.getDeployables() != null) {
            for (Composite composite : contribution.getDeployables()) {
                this.getDeployables().add(composite.getURI());
            }
        }
        if (contribution.getExports() != null) {
            for (Export export : contribution.getExports()) {
                if (export instanceof JavaExport) {
                    this.getJavaExports().add(((JavaExport)export).getPackage());
                    continue;
                }
                if (!(export instanceof NamespaceExport)) continue;
                this.getNamespaceExports().add(((NamespaceExport)export).getNamespace());
            }
        }
        if (contribution.getImports() != null) {
            for (Import imprt : contribution.getImports()) {
                if (imprt instanceof JavaImport) {
                    this.getJavaImports().add(((JavaImport)imprt).getPackage());
                    continue;
                }
                if (!(imprt instanceof NamespaceImport)) continue;
                this.getNamespaceImports().add(((NamespaceImport)imprt).getNamespace());
            }
        }
    }

    protected String deriveContributionURI(String contributionURL) {
        String uri = null;
        try {
            File f = new File(contributionURL);
            uri = "classes".equals(f.getName()) && "target".equals(f.getParentFile().getName()) ? f.getParentFile().getParentFile().getName() : f.getName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (uri == null) {
            uri = contributionURL;
        }
        if (uri.endsWith(".zip") || uri.endsWith(".jar")) {
            uri = uri.substring(0, uri.length() - 4);
        }
        if (uri.endsWith("SNAPSHOT")) {
            uri = uri.substring(0, uri.lastIndexOf(45));
            uri = uri.substring(0, uri.lastIndexOf(45));
        }
        return uri;
    }
}

