/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.LifeCycleListener;
import org.apache.tuscany.sca.extensibility.ServiceDeclaration;
import org.apache.tuscany.sca.extensibility.ServiceHelper;
import org.apache.tuscany.sca.runtime.DomainRegistryFactory;
import org.apache.tuscany.sca.runtime.DomainRegistryFactoryExtensionPoint;
import org.oasisopen.sca.ServiceRuntimeException;

public class DefaultDomainRegistryFactoryExtensionPoint
implements DomainRegistryFactoryExtensionPoint,
LifeCycleListener {
    private ExtensionPointRegistry registry;
    private boolean loaded;
    private List<DomainRegistryFactory> factories = new ArrayList<DomainRegistryFactory>();
    private Map<String, String> domainRegistryMapping = new HashMap<String, String>();

    public DefaultDomainRegistryFactoryExtensionPoint(ExtensionPointRegistry registry, Map<String, String> attributes) {
        this.registry = registry;
        this.domainRegistryMapping.putAll(attributes);
        this.domainRegistryMapping.remove("class");
        this.domainRegistryMapping.remove("ranking");
    }

    @Override
    public void addDomainRegistryFactory(DomainRegistryFactory factory) {
        ServiceHelper.start(factory);
        this.factories.add(factory);
    }

    @Override
    public List<DomainRegistryFactory> getDomainRegistryFactories() {
        this.load();
        return this.factories;
    }

    private synchronized void load() {
        if (this.loaded) {
            return;
        }
        try {
            Collection<ServiceDeclaration> declarations = this.registry.getServiceDiscovery().getServiceDeclarations(DomainRegistryFactory.class, true);
            for (ServiceDeclaration declaration : declarations) {
                DomainRegistryFactory factory = (DomainRegistryFactory)ServiceHelper.newInstance(this.registry, declaration);
                this.addDomainRegistryFactory(factory);
            }
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(e);
        }
        finally {
            this.loaded = true;
        }
    }

    @Override
    public void removeDomainRegistryFactory(DomainRegistryFactory factory) {
        if (this.factories.remove(factory)) {
            ServiceHelper.stop(factory);
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        ServiceHelper.stop(this.factories);
    }

    @Override
    public Map<String, String> getDomainRegistryMapping() {
        return this.domainRegistryMapping;
    }
}

