/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.xsd.xml;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tuscany.sca.assembly.xsd.Constants;
import org.apache.tuscany.sca.common.xml.XMLDocumentHelper;
import org.apache.tuscany.sca.contribution.Artifact;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.DefaultImport;
import org.apache.tuscany.sca.contribution.Import;
import org.apache.tuscany.sca.contribution.namespace.NamespaceImport;
import org.apache.tuscany.sca.contribution.processor.ContributionRuntimeException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.xsd.DefaultXSDFactory;
import org.apache.tuscany.sca.xsd.XSDFactory;
import org.apache.tuscany.sca.xsd.XSDefinition;
import org.apache.tuscany.sca.xsd.impl.XSDefinitionImpl;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaInclude;
import org.apache.ws.commons.schema.resolver.URIResolver;
import org.xml.sax.InputSource;

public class XSDModelResolver
implements ModelResolver {
    private static final String AGGREGATED_XSD = "http://tuscany.apache.org/aggregated.xsd";
    private XSDFactory factory;
    private Contribution contribution;
    private Map<String, List<XSDefinition>> map = new HashMap<String, List<XSDefinition>>();
    private XmlSchemaCollection schemaCollection;
    private static final byte[] schemaCollectionReadLock = new byte[0];

    public XSDModelResolver(Contribution contribution, FactoryExtensionPoint modelFactories) {
        this.contribution = contribution;
        this.schemaCollection = new XmlSchemaCollection();
        this.factory = new DefaultXSDFactory();
    }

    @Override
    public void addModel(Object resolved, ProcessorContext context) {
        XSDefinition definition = (XSDefinition)resolved;
        List<XSDefinition> list = this.map.get(definition.getNamespace());
        if (list == null) {
            list = new ArrayList<XSDefinition>();
            this.map.put(definition.getNamespace(), list);
        }
        list.add(definition);
    }

    @Override
    public Object removeModel(Object resolved, ProcessorContext context) {
        XSDefinition definition = (XSDefinition)resolved;
        List<XSDefinition> list = this.map.get(definition.getNamespace());
        if (list == null) {
            return null;
        }
        return list.remove(definition);
    }

    @Override
    public <T> T resolveModel(Class<T> modelClass, T unresolved, ProcessorContext context) {
        int index;
        this.schemaCollection.setSchemaResolver(new URIResolverImpl(this.contribution, context));
        XSDefinition definition = (XSDefinition)unresolved;
        String namespace = definition.getNamespace();
        XSDefinition resolved = null;
        List<XSDefinition> list = this.map.get(namespace);
        if (list == null || list != null && list.size() == 0) {
            resolved = this.resolutionDelegation(namespace, context);
            return modelClass.cast(resolved);
        }
        XSDefinition modelXSD = null;
        if (list != null && definition.getDocument() != null && (index = list.indexOf(definition)) != -1) {
            modelXSD = list.get(index);
            modelXSD.setDocument(definition.getDocument());
        }
        if (list == null && definition.getDocument() != null) {
            list = new ArrayList<XSDefinition>();
            list.add(definition);
            this.map.put(namespace, list);
        }
        try {
            resolved = this.aggregate(list);
        }
        catch (IOException e) {
            throw new ContributionRuntimeException(e);
        }
        if (resolved != null && !resolved.isUnresolved()) {
            if (definition.isUnresolved() && definition.getSchema() == null && modelXSD != null) {
                definition.setSchema(modelXSD.getSchema());
                definition.setSchemaCollection(modelXSD.getSchemaCollection());
                definition.setUnresolved(false);
            }
            return modelClass.cast(resolved);
        }
        return modelClass.cast(unresolved);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadOnDemand(XSDefinition definition) throws IOException {
        byte[] byArray = schemaCollectionReadLock;
        synchronized (schemaCollectionReadLock) {
            if (definition.getSchema() != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (definition.getDocument() != null) {
                String uri = null;
                if (definition.getLocation() != null) {
                    uri = definition.getLocation().toString();
                }
                XmlSchema schema = null;
                try {
                    final XSDefinition finaldef = definition;
                    final String finaluri = uri;
                    try {
                        schema = AccessController.doPrivileged(new PrivilegedExceptionAction<XmlSchema>(){

                            @Override
                            public XmlSchema run() throws IOException {
                                return XSDModelResolver.this.schemaCollection.read(finaldef.getDocument(), finaluri, null);
                            }
                        });
                    }
                    catch (PrivilegedActionException e) {
                        throw (IOException)e.getException();
                    }
                }
                catch (IOException e) {
                    throw new ContributionRuntimeException(e);
                }
                catch (RuntimeException e) {
                    Throwable cause;
                    for (cause = e; cause.getCause() != null && cause != cause.getCause(); cause = cause.getCause()) {
                    }
                    throw new ContributionRuntimeException(cause);
                }
                definition.setSchemaCollection(this.schemaCollection);
                definition.setSchema(schema);
                definition.setUnresolved(false);
            } else if (definition.getLocation() != null) {
                if (definition.getLocation().getFragment() != null) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
                XmlSchema schema = null;
                for (XmlSchema d : this.schemaCollection.getXmlSchemas()) {
                    if (!this.isSameNamespace(d.getTargetNamespace(), definition.getNamespace()) || !d.getSourceURI().equals(definition.getLocation().toString())) continue;
                    schema = d;
                    break;
                }
                if (schema == null) {
                    InputSource xsd = null;
                    final XSDefinition finaldef = definition;
                    try {
                        try {
                            xsd = AccessController.doPrivileged(new PrivilegedExceptionAction<InputSource>(){

                                @Override
                                public InputSource run() throws IOException {
                                    return XMLDocumentHelper.getInputSource(finaldef.getLocation().toURL());
                                }
                            });
                        }
                        catch (PrivilegedActionException e) {
                            throw (IOException)e.getException();
                        }
                    }
                    catch (IOException e) {
                        throw new ContributionRuntimeException(e);
                    }
                    try {
                        final InputSource finalxsd = xsd;
                        try {
                            schema = AccessController.doPrivileged(new PrivilegedExceptionAction<XmlSchema>(){

                                @Override
                                public XmlSchema run() throws IOException {
                                    return XSDModelResolver.this.schemaCollection.read(finalxsd, null);
                                }
                            });
                        }
                        catch (PrivilegedActionException e) {
                            throw (IOException)e.getException();
                        }
                    }
                    catch (IOException e) {
                        throw new ContributionRuntimeException(e);
                    }
                    catch (RuntimeException e) {
                        Throwable cause;
                        for (cause = e; cause.getCause() != null && cause != cause.getCause(); cause = cause.getCause()) {
                        }
                        throw new ContributionRuntimeException(cause);
                    }
                }
                definition.setSchemaCollection(this.schemaCollection);
                definition.setSchema(schema);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private boolean isSameNamespace(String ns1, String ns2) {
        if (ns1 == null) {
            return ns2 == null;
        }
        return ns1.equals(ns2);
    }

    private XSDefinition aggregate(List<XSDefinition> definitions) throws IOException {
        if (definitions == null || definitions.size() == 0) {
            return null;
        }
        if (definitions.size() == 1) {
            XSDefinition d = definitions.get(0);
            this.loadOnDemand(d);
            return d;
        }
        XSDefinition aggregated = this.factory.createXSDefinition();
        for (XSDefinition d : definitions) {
            this.loadOnDemand(d);
        }
        String ns = definitions.get(0).getNamespace();
        XmlSchema facade = null;
        for (XmlSchema s : this.schemaCollection.getXmlSchema(AGGREGATED_XSD)) {
            if (!ns.equals(s.getTargetNamespace())) continue;
            facade = s;
            break;
        }
        if (facade == null) {
            facade = new XmlSchema(ns, AGGREGATED_XSD, this.schemaCollection);
        }
        for (XmlSchema d : this.schemaCollection.getXmlSchemas()) {
            if (!ns.equals(d.getTargetNamespace()) || d == facade) continue;
            XmlSchemaInclude include = new XmlSchemaInclude();
            include.setSchema(d);
            include.setSourceURI(d.getSourceURI());
            include.setSchemaLocation(d.getSourceURI());
            facade.getIncludes().add(include);
            facade.getItems().add(include);
        }
        aggregated.setUnresolved(true);
        aggregated.setSchema(facade);
        aggregated.setNamespace(ns);
        aggregated.setAggregatedDefinitions(definitions);
        aggregated.setUnresolved(false);
        return aggregated;
    }

    private XSDefinition resolutionDelegation(String namespace, ProcessorContext context) {
        XSDefinition resolved = null;
        XSDefinitionImpl unresolved = new XSDefinitionImpl();
        unresolved.setUnresolved(true);
        unresolved.setNamespace(namespace);
        for (Import import_ : this.contribution.getImports()) {
            NamespaceImport namespaceImport;
            if (!(import_ instanceof NamespaceImport ? (namespaceImport = (NamespaceImport)import_).getNamespace().equals(namespace) && !(resolved = (XSDefinition)namespaceImport.getModelResolver().resolveModel(XSDefinition.class, unresolved, context)).isUnresolved() : import_ instanceof DefaultImport && !(resolved = (XSDefinition)import_.getModelResolver().resolveModel(XSDefinition.class, unresolved, context)).isUnresolved())) continue;
            return resolved;
        }
        return resolved;
    }

    public static class URIResolverImpl
    implements URIResolver {
        private Contribution contribution;
        private ProcessorContext context;

        public URIResolverImpl(Contribution contribution, ProcessorContext context) {
            this.contribution = contribution;
            this.context = context;
        }

        @Override
        public InputSource resolveEntity(String targetNamespace, String schemaLocation, String baseUri) {
            try {
                if (schemaLocation == null) {
                    return null;
                }
                URL url = null;
                XSDefinition resolved = null;
                XSDefinitionImpl unresolved = new XSDefinitionImpl();
                unresolved.setUnresolved(true);
                unresolved.setLocation(new URI(schemaLocation));
                unresolved.setNamespace(targetNamespace);
                for (Import import_ : this.contribution.getImports()) {
                    if (import_ instanceof NamespaceImport) {
                        NamespaceImport namespaceImport = (NamespaceImport)import_;
                        if (!namespaceImport.getNamespace().equals(targetNamespace) || (resolved = (XSDefinition)namespaceImport.getModelResolver().resolveModel(XSDefinition.class, unresolved, this.context)).isUnresolved()) continue;
                        URL resolvedURL = resolved.getLocation().toURL();
                        return this.xmlDocumentHelperGetInputSource(resolvedURL);
                    }
                    if (!(import_ instanceof DefaultImport) || (resolved = (XSDefinition)import_.getModelResolver().resolveModel(XSDefinition.class, unresolved, this.context)).isUnresolved()) continue;
                    URL resolvedURL = resolved.getLocation().toURL();
                    return this.xmlDocumentHelperGetInputSource(resolvedURL);
                }
                if (schemaLocation.startsWith("/")) {
                    String uri = schemaLocation.substring(1);
                    for (Artifact a : this.contribution.getArtifacts()) {
                        if (!a.getURI().equals(uri)) continue;
                        url = new URL(a.getLocation());
                        break;
                    }
                    if (url == null) {
                        return new InputSource(schemaLocation);
                    }
                } else {
                    URL cached;
                    url = new URL(new URL(baseUri), schemaLocation);
                    String scheme = url.getProtocol();
                    if (!("file".equalsIgnoreCase(scheme) || "jar".equalsIgnoreCase(scheme) || "zip".equalsIgnoreCase(scheme) || "wsjar".equalsIgnoreCase(scheme) || (cached = Constants.CACHED_XSDS.get(targetNamespace)) == null)) {
                        url = cached;
                    }
                }
                return this.xmlDocumentHelperGetInputSource(url);
            }
            catch (IOException e) {
                try {
                    for (Artifact artifact : this.contribution.getArtifacts()) {
                        String artifactNamespace;
                        if (!(artifact.getModel() instanceof XSDefinitionImpl) || !targetNamespace.equals(artifactNamespace = ((XSDefinitionImpl)artifact.getModel()).getNamespace())) continue;
                        URL artifactLocation = ((XSDefinitionImpl)artifact.getModel()).getLocation().toURL();
                        return this.xmlDocumentHelperGetInputSource(artifactLocation);
                    }
                    return new InputSource(schemaLocation);
                }
                catch (IOException ioe) {
                    return new InputSource(schemaLocation);
                }
            }
            catch (URISyntaxException e) {
                return new InputSource(schemaLocation);
            }
        }

        private InputSource xmlDocumentHelperGetInputSource(final URL url) throws IOException {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<InputSource>(){

                    @Override
                    public InputSource run() throws IOException {
                        return XMLDocumentHelper.getInputSource(url);
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw (IOException)pae.getException();
            }
        }
    }
}

