/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.guice;

import com.google.inject.BindingAnnotation;
import com.google.inject.Inject;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import javax.inject.Qualifier;
import org.apache.wicket.guice.GuiceProxyTargetLocator;
import org.apache.wicket.injection.IFieldValueFactory;
import org.apache.wicket.proxy.IProxyTargetLocator;
import org.apache.wicket.proxy.LazyInitProxyFactory;

public class GuiceFieldValueFactory
implements IFieldValueFactory {
    private final boolean wrapInProxies;

    GuiceFieldValueFactory(boolean wrapInProxies) {
        this.wrapInProxies = wrapInProxies;
    }

    public Object getFieldValue(Field field, Object fieldOwner) {
        Object target = null;
        if (this.supportsField(field)) {
            Inject injectAnnotation = field.getAnnotation(Inject.class);
            javax.inject.Inject javaxInjectAnnotation = field.getAnnotation(javax.inject.Inject.class);
            if (!(Modifier.isStatic(field.getModifiers()) || injectAnnotation == null && javaxInjectAnnotation == null)) {
                try {
                    boolean optional = injectAnnotation != null && injectAnnotation.optional();
                    Annotation bindingAnnotation = this.findBindingAnnotation(field.getAnnotations());
                    GuiceProxyTargetLocator locator = new GuiceProxyTargetLocator(field, bindingAnnotation, optional);
                    target = this.wrapInProxies ? LazyInitProxyFactory.createProxy(field.getType(), (IProxyTargetLocator)locator) : locator.locateProxyTarget();
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                }
                catch (MoreThanOneBindingException e) {
                    throw new RuntimeException("Can't have more than one BindingAnnotation on field " + field.getName() + " of class " + fieldOwner.getClass().getName());
                }
            }
        }
        return target;
    }

    public boolean supportsField(Field field) {
        return field.isAnnotationPresent(Inject.class) || field.isAnnotationPresent(javax.inject.Inject.class);
    }

    private Annotation findBindingAnnotation(Annotation[] annotations) throws MoreThanOneBindingException {
        Annotation bindingAnnotation = null;
        for (Annotation annotation : annotations) {
            if (annotation.annotationType().getAnnotation(BindingAnnotation.class) == null && annotation.annotationType().getAnnotation(Qualifier.class) == null) continue;
            if (bindingAnnotation != null) {
                throw new MoreThanOneBindingException();
            }
            bindingAnnotation = annotation;
        }
        return bindingAnnotation;
    }

    public static class MoreThanOneBindingException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

