/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.client;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLServerSocketFactory;
import javax.ws.rs.core.Response;
import org.apache.wink.client.BaseTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockHttpServer
extends Thread {
    private Thread serverThread = null;
    private ServerSocket serverSocket = null;
    private boolean serverStarted = false;
    private ServerSocketFactory serverSocketFactory = null;
    private int serverPort;
    private int readTimeOut = 5000;
    private int delayResponseTime = 0;
    private static byte[] NEW_LINE = "\r\n".getBytes();
    private String requestMethod = null;
    private String requestUrl = null;
    private Map<String, List<String>> requestHeaders = new HashMap<String, List<String>>();
    private ByteArrayOutputStream requestContent = new ByteArrayOutputStream();
    private List<MockHttpServerResponse> mockHttpServerResponses = new ArrayList<MockHttpServerResponse>();
    private int responseCounter = 0;

    public MockHttpServer(int serverPort) {
        this(serverPort, false);
    }

    public MockHttpServer(int serverPort, boolean ssl) {
        this.mockHttpServerResponses.add(new MockHttpServerResponse());
        this.serverPort = serverPort;
        try {
            this.serverSocketFactory = ServerSocketFactory.getDefault();
            if (ssl) {
                this.serverSocketFactory = SSLServerSocketFactory.getDefault();
            }
            while (this.serverSocket == null) {
                try {
                    this.serverSocket = this.serverSocketFactory.createServerSocket(++this.serverPort);
                }
                catch (BindException e) {}
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void startServer() {
        if (this.serverStarted) {
            return;
        }
        this.start();
        this.serverStarted = true;
        this.waitForServerToStart();
    }

    private synchronized void waitForServerToStart() {
        try {
            this.wait(5000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private synchronized void waitForServerToStop() {
        try {
            this.wait(5000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void run() {
        this.serverThread = Thread.currentThread();
        this.executeLoop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeLoop() {
        this.serverStarted();
        try {
            try {
                while (true) {
                    Socket socket = this.serverSocket.accept();
                    HttpProcessor processor = new HttpProcessor(socket);
                    processor.run();
                }
            }
            catch (IOException e) {
                if (e instanceof SocketException) {
                    if (!"Socket closed".equalsIgnoreCase(e.getMessage()) && !"Socket is closed".equalsIgnoreCase(e.getMessage())) {
                        e.printStackTrace();
                        throw new RuntimeException(e);
                    }
                } else {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
                this.serverStopped();
            }
        }
        catch (Throwable throwable) {
            this.serverStopped();
            throw throwable;
        }
    }

    private synchronized void serverStarted() {
        this.notifyAll();
    }

    private synchronized void serverStopped() {
        this.notifyAll();
    }

    public synchronized void stopServer() {
        if (!this.serverStarted) {
            return;
        }
        try {
            this.serverStarted = false;
            this.serverThread.interrupt();
            this.serverSocket.close();
            this.waitForServerToStop();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setReadTimeout(int milliseconds) {
        this.readTimeOut = milliseconds;
    }

    public void setDelayResponse(int milliseconds) {
        this.delayResponseTime = milliseconds;
    }

    public String getRequestContentAsString() {
        return this.requestContent.toString();
    }

    public byte[] getRequestContent() {
        return this.requestContent.toByteArray();
    }

    public Map<String, List<String>> getRequestHeaders() {
        return this.requestHeaders;
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public String getRequestUrl() {
        return this.requestUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        block0: {
            MockHttpServer server = null;
            if (server == null) break block0;
            server.stopServer();
        }
    }

    public void setMockHttpServerResponses(MockHttpServerResponse ... responses) {
        this.mockHttpServerResponses.clear();
        for (int i = 0; i < responses.length; ++i) {
            this.mockHttpServerResponses.add(responses[i]);
        }
    }

    public List<MockHttpServerResponse> getMockHttpServerResponses() {
        return this.mockHttpServerResponses;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    private class HttpProcessor {
        private Socket socket;

        public HttpProcessor(Socket socket) throws SocketException {
            socket.setSoTimeout(MockHttpServer.this.readTimeOut);
            socket.setKeepAlive(false);
            this.socket = socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block13: {
                try {
                    this.processRequest(this.socket);
                    this.processResponse(this.socket);
                }
                catch (IOException e) {
                    if (e instanceof SocketException) {
                        if (!"socket closed".equalsIgnoreCase(e.getMessage())) {
                            e.printStackTrace();
                            throw new RuntimeException(e);
                        }
                        break block13;
                    }
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
                finally {
                    try {
                        this.socket.shutdownOutput();
                        this.socket.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        private void processRequest(Socket socket) throws IOException {
            MockHttpServer.this.requestContent.reset();
            BufferedInputStream is = new BufferedInputStream(socket.getInputStream());
            String requestMethodHeader = new String(this.readLine(is));
            if (requestMethodHeader == null) {
                return;
            }
            this.processRequestMethod(requestMethodHeader);
            this.processRequestHeaders(is);
            this.processRequestContent(is);
        }

        private void processRequestMethod(String requestMethodHeader) {
            String[] parts = requestMethodHeader.split(" ");
            if (parts.length < 2) {
                throw new RuntimeException("illegal http request");
            }
            MockHttpServer.this.requestMethod = parts[0];
            MockHttpServer.this.requestUrl = parts[1];
        }

        private void processRequestHeaders(InputStream is) throws IOException {
            String lineStr;
            MockHttpServer.this.requestHeaders.clear();
            byte[] line = null;
            while ((line = this.readLine(is)) != null && !"".equals((lineStr = new String(line)).trim())) {
                this.addRequestHeader(lineStr);
            }
        }

        private void processRequestContent(InputStream is) throws NumberFormatException, IOException {
            String transferEncoding;
            if (!"PUT".equals(MockHttpServer.this.requestMethod) && !"POST".equals(MockHttpServer.this.requestMethod)) {
                return;
            }
            List transferEncodingValues = (List)MockHttpServer.this.requestHeaders.get("Transfer-Encoding");
            String string = transferEncoding = transferEncodingValues == null || transferEncodingValues.isEmpty() ? null : (String)transferEncodingValues.get(0);
            if ("chunked".equals(transferEncoding)) {
                this.processChunkedContent(is);
            } else {
                this.processRegularContent(is);
            }
            if (((MockHttpServerResponse)MockHttpServer.this.mockHttpServerResponses.get(MockHttpServer.this.responseCounter)).getMockResponseContentEchoRequest()) {
                ((MockHttpServerResponse)MockHttpServer.this.mockHttpServerResponses.get(MockHttpServer.this.responseCounter)).setMockResponseContent(MockHttpServer.this.requestContent.toByteArray());
            }
        }

        private void processRegularContent(InputStream is) throws IOException {
            String contentLength;
            List contentLengthValues = (List)MockHttpServer.this.requestHeaders.get("Content-Length");
            String string = contentLength = contentLengthValues == null || contentLengthValues.isEmpty() ? null : (String)contentLengthValues.get(0);
            if (contentLength == null) {
                return;
            }
            int contentLen = Integer.parseInt(contentLength);
            byte[] bytes = new byte[contentLen];
            is.read(bytes);
            MockHttpServer.this.requestContent.write(bytes);
        }

        private void processChunkedContent(InputStream is) throws IOException {
            MockHttpServer.this.requestContent.write("".getBytes());
            byte[] chunk = null;
            byte[] line = null;
            boolean lastChunk = false;
            while (!lastChunk && (line = this.readLine(is)) != null) {
                String lineStr = new String(line);
                if ("0".equals(lineStr)) {
                    lastChunk = true;
                }
                if (lastChunk) continue;
                int chunkLen = Integer.parseInt(lineStr, 16);
                chunk = this.getChunk(is, chunkLen);
                this.readLine(is);
                MockHttpServer.this.requestContent.write(chunk);
            }
            if (lastChunk) {
                this.readLine(is);
            }
        }

        private byte[] readLine(InputStream is) throws IOException {
            int n;
            ByteArrayOutputStream tmpOs = new ByteArrayOutputStream();
            while ((n = is.read()) != -1) {
                if (n == 13) {
                    n = is.read();
                    if (n == 10) {
                        return tmpOs.toByteArray();
                    }
                    tmpOs.write(13);
                    if (n != -1) {
                        tmpOs.write(n);
                        continue;
                    }
                    return tmpOs.toByteArray();
                }
                if (n == 10) {
                    return tmpOs.toByteArray();
                }
                tmpOs.write(n);
            }
            return tmpOs.toByteArray();
        }

        private byte[] getChunk(InputStream is, int len) throws IOException {
            ByteArrayOutputStream chunk = new ByteArrayOutputStream();
            int read = 0;
            byte[] bytes = new byte[512];
            for (int totalRead = 0; totalRead < len; totalRead += read) {
                read = is.read(bytes, 0, Math.min(bytes.length, len - totalRead));
                chunk.write(bytes, 0, read);
            }
            return chunk.toByteArray();
        }

        private void addRequestHeader(String line) {
            String[] parts = line.split(": ");
            ArrayList<String> values = (ArrayList<String>)MockHttpServer.this.requestHeaders.get(parts[0]);
            if (values == null) {
                values = new ArrayList<String>();
                MockHttpServer.this.requestHeaders.put(parts[0], values);
            }
            values.add(parts[1]);
        }

        private void processResponse(Socket socket) throws IOException {
            if (!this.delayResponse()) {
                return;
            }
            OutputStream sos = socket.getOutputStream();
            BufferedOutputStream os = new BufferedOutputStream(sos);
            String reason = "";
            Response.Status statusCode = Response.Status.fromStatusCode((int)((MockHttpServerResponse)MockHttpServer.this.mockHttpServerResponses.get(MockHttpServer.this.responseCounter)).getMockResponseCode());
            if (statusCode != null) {
                reason = statusCode.toString();
            }
            os.write(("HTTP/1.1 " + ((MockHttpServerResponse)MockHttpServer.this.mockHttpServerResponses.get(MockHttpServer.this.responseCounter)).getMockResponseCode() + " " + reason).getBytes());
            os.write(NEW_LINE);
            this.processResponseHeaders(os);
            this.processResponseContent(os);
            os.flush();
            MockHttpServer.this.responseCounter++;
        }

        private boolean delayResponse() {
            if (MockHttpServer.this.delayResponseTime > 0) {
                try {
                    Thread.sleep(MockHttpServer.this.delayResponseTime);
                    return true;
                }
                catch (InterruptedException e) {
                    return false;
                }
            }
            return true;
        }

        private void processResponseContent(OutputStream os) throws IOException {
            if (((MockHttpServerResponse)MockHttpServer.this.mockHttpServerResponses.get(MockHttpServer.this.responseCounter)).getMockResponseContent() == null) {
                return;
            }
            os.write(((MockHttpServerResponse)MockHttpServer.this.mockHttpServerResponses.get(MockHttpServer.this.responseCounter)).getMockResponseContent());
        }

        private void processResponseHeaders(OutputStream os) throws IOException {
            this.addServerResponseHeaders();
            for (String header : ((MockHttpServerResponse)MockHttpServer.this.mockHttpServerResponses.get(MockHttpServer.this.responseCounter)).getMockResponseHeaders().keySet()) {
                os.write((header + ": " + ((MockHttpServerResponse)MockHttpServer.this.mockHttpServerResponses.get(MockHttpServer.this.responseCounter)).getMockResponseHeaders().get(header)).getBytes());
                os.write(NEW_LINE);
            }
            os.write(NEW_LINE);
        }

        private void addServerResponseHeaders() {
            Map<String, String> mockResponseHeaders = ((MockHttpServerResponse)MockHttpServer.this.mockHttpServerResponses.get(MockHttpServer.this.responseCounter)).getMockResponseHeaders();
            mockResponseHeaders.put("Content-Type", ((MockHttpServerResponse)MockHttpServer.this.mockHttpServerResponses.get(MockHttpServer.this.responseCounter)).getMockResponseContentType());
            mockResponseHeaders.put("Content-Length", ((MockHttpServerResponse)MockHttpServer.this.mockHttpServerResponses.get(MockHttpServer.this.responseCounter)).getMockResponseContent().length + "");
            mockResponseHeaders.put("Server", "Mock HTTP Server v1.0");
            mockResponseHeaders.put("Connection", "closed");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MockHttpServerResponse {
        private int mockResponseCode = 200;
        private Map<String, String> mockResponseHeaders = new HashMap<String, String>();
        private byte[] mockResponseContent = BaseTest.RECEIVED_MESSAGE.getBytes();
        private String mockResponseContentType = "text/plain;charset=utf-8";
        private boolean mockResponseContentEchoRequest;

        public void setMockResponseHeaders(Map<String, String> headers) {
            this.mockResponseHeaders.clear();
            this.mockResponseHeaders.putAll(headers);
        }

        public void setMockResponseHeader(String name, String value) {
            this.mockResponseHeaders.put(name, value);
        }

        public Map<String, String> getMockResponseHeaders() {
            return this.mockResponseHeaders;
        }

        public void setMockResponseCode(int responseCode) {
            this.mockResponseCode = responseCode;
        }

        public int getMockResponseCode() {
            return this.mockResponseCode;
        }

        public void setMockResponseContent(String content) {
            this.mockResponseContent = content.getBytes();
        }

        public void setMockResponseContent(byte[] content) {
            this.mockResponseContent = content;
        }

        public byte[] getMockResponseContent() {
            return this.mockResponseContent;
        }

        public void setMockResponseContentType(String type) {
            this.mockResponseContentType = type;
        }

        public String getMockResponseContentType() {
            return this.mockResponseContentType;
        }

        public void setMockResponseContentEchoRequest(boolean echo) {
            this.mockResponseContentEchoRequest = echo;
        }

        public boolean getMockResponseContentEchoRequest() {
            return this.mockResponseContentEchoRequest;
        }
    }
}

