/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.validate;

import java.security.Key;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.message.token.BinarySecurity;
import org.apache.ws.security.message.token.KerberosSecurity;
import org.apache.ws.security.message.token.KerberosServiceContext;
import org.apache.ws.security.message.token.KerberosServiceExceptionAction;
import org.apache.ws.security.validate.Credential;
import org.apache.ws.security.validate.KerberosTokenDecoder;
import org.apache.ws.security.validate.Validator;

public class KerberosTokenValidator
implements Validator {
    private static Log log = LogFactory.getLog(KerberosTokenValidator.class);
    private String serviceName;
    private CallbackHandler callbackHandler;
    private String contextName;
    private KerberosTokenDecoder kerberosTokenDecoder;
    private boolean isUsernameServiceNameForm;
    private boolean spnego;

    public String getContextName() {
        return this.contextName;
    }

    public void setContextName(String contextName) {
        this.contextName = contextName;
    }

    public String getJaasLoginModuleName() {
        return this.contextName;
    }

    public void setJaasLoginModuleName(String jaasLoginModuleName) {
        this.contextName = jaasLoginModuleName;
    }

    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    public void setCallbackHandler(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public KerberosTokenDecoder getKerberosTokenDecoder() {
        return this.kerberosTokenDecoder;
    }

    public void setKerberosTokenDecoder(KerberosTokenDecoder kerberosTokenDecoder) {
        this.kerberosTokenDecoder = kerberosTokenDecoder;
    }

    public Credential validate(Credential credential, RequestData data) throws WSSecurityException {
        if (credential == null || credential.getBinarySecurityToken() == null) {
            throw new WSSecurityException(0, "noCredential");
        }
        BinarySecurity binarySecurity = credential.getBinarySecurityToken();
        if (!(binarySecurity instanceof KerberosSecurity)) {
            return credential;
        }
        if (log.isDebugEnabled()) {
            try {
                String jaasAuth = System.getProperty("java.security.auth.login.config");
                String krbConf = System.getProperty("java.security.krb5.conf");
                log.debug((Object)("KerberosTokenValidator - Using JAAS auth login file: " + jaasAuth));
                log.debug((Object)("KerberosTokenValidator - Using KRB conf file: " + krbConf));
            }
            catch (SecurityException ex) {
                log.debug((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        LoginContext loginContext = null;
        try {
            loginContext = this.callbackHandler == null ? new LoginContext(this.getContextName()) : new LoginContext(this.getContextName(), this.callbackHandler);
            loginContext.login();
        }
        catch (LoginException ex) {
            if (log.isDebugEnabled()) {
                log.debug((Object)ex.getMessage(), (Throwable)ex);
            }
            throw new WSSecurityException(0, "kerberosLoginError", new Object[]{ex.getMessage()}, ex);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Successfully authenticated to the TGT");
        }
        byte[] token = binarySecurity.getToken();
        Subject subject = loginContext.getSubject();
        String service = this.serviceName;
        if (service == null) {
            Set<Principal> principals = subject.getPrincipals();
            if (principals.isEmpty()) {
                throw new WSSecurityException(0, "kerberosLoginError", new Object[]{"No Client principals found after login"});
            }
            service = principals.iterator().next().getName();
        }
        KerberosServiceExceptionAction action = new KerberosServiceExceptionAction(token, service, this.isUsernameServiceNameForm(), this.spnego);
        KerberosServiceContext krbServiceCtx = null;
        try {
            krbServiceCtx = Subject.doAs(subject, action);
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof WSSecurityException) {
                throw (WSSecurityException)cause;
            }
            throw new WSSecurityException(0, "kerberosTicketValidationError", new Object[0], cause);
        }
        credential.setPrincipal(krbServiceCtx.getPrincipal());
        if (credential.getPrincipal() == null) {
            throw new WSSecurityException(0, "kerberosTicketValidationError");
        }
        credential.setDelegationCredential(krbServiceCtx.getDelegationCredential());
        log.debug((Object)"Trying to obtain the Session Key from the KerberosServiceContext.");
        Key sessionKey = krbServiceCtx.getSessionKey();
        if (null != sessionKey) {
            log.debug((Object)"Found session key in the KerberosServiceContext.");
            credential.setSecretKey(sessionKey.getEncoded());
        } else {
            log.debug((Object)"Session key is not found in the KerberosServiceContext.");
        }
        if (null == credential.getSecretKey() && this.kerberosTokenDecoder != null) {
            KerberosTokenDecoder kerberosTokenDecoder = this.kerberosTokenDecoder;
            log.debug((Object)"KerberosTokenDecoder is set.Trying to obtain the session key from it.");
            kerberosTokenDecoder.clear();
            kerberosTokenDecoder.setToken(token);
            kerberosTokenDecoder.setSubject(subject);
            byte[] key = kerberosTokenDecoder.getSessionKey();
            if (null != key) {
                log.debug((Object)"Session key obtained from the KerberosTokenDecoder.");
                credential.setSecretKey(key);
            } else {
                log.debug((Object)"Session key could not be obtained from the KerberosTokenDecoder.");
            }
        } else {
            log.debug((Object)"KerberosTokenDecoder is not set.");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Successfully validated a ticket");
        }
        return credential;
    }

    public boolean isUsernameServiceNameForm() {
        return this.isUsernameServiceNameForm;
    }

    public void setUsernameServiceNameForm(boolean isUsernameServiceNameForm) {
        this.isUsernameServiceNameForm = isUsernameServiceNameForm;
    }

    public boolean isSpnego() {
        return this.spnego;
    }

    public void setSpnego(boolean spnego) {
        this.spnego = spnego;
    }
}

