/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.repository.h2;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.b3log.latke.repository.h2.mapping.BooleanMapping;
import org.b3log.latke.repository.h2.mapping.StringMapping;
import org.b3log.latke.repository.jdbc.AbstractJdbcDatabaseSolution;
import org.b3log.latke.repository.jdbc.mapping.DateMapping;
import org.b3log.latke.repository.jdbc.mapping.IntMapping;
import org.b3log.latke.repository.jdbc.mapping.LongMapping;
import org.b3log.latke.repository.jdbc.mapping.Mapping;
import org.b3log.latke.repository.jdbc.mapping.NumberMapping;
import org.b3log.latke.repository.jdbc.util.FieldDefinition;

public final class H2JdbcDatabaseSolution
extends AbstractJdbcDatabaseSolution {
    public H2JdbcDatabaseSolution() {
        this.registerType("int", (Mapping)new IntMapping());
        this.registerType("boolean", new BooleanMapping());
        this.registerType("long", (Mapping)new LongMapping());
        this.registerType("double", (Mapping)new NumberMapping());
        this.registerType("String", new StringMapping());
        this.registerType("Date", (Mapping)new DateMapping());
    }

    public String queryPage(int start, int end, String selectSql, String filterSql, String orderBySql, String tableName) {
        StringBuilder sql = new StringBuilder();
        sql.append(selectSql).append(" from ").append(tableName);
        if (StringUtils.isNotBlank((String)filterSql)) {
            sql.append(" where ").append(filterSql);
        }
        sql.append(orderBySql);
        sql.append(" limit ").append(start).append(",").append(end - start);
        return sql.toString();
    }

    public String getRandomlySql(String tableName, int fetchSize) {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT * FROM ").append(tableName).append(" ORDER BY RAND() LIMIT ").append(fetchSize);
        return sql.toString();
    }

    protected void createDropTableSql(StringBuilder dropTableSql, String tableName) {
        dropTableSql.append("DROP TABLE IF EXISTS ").append(tableName).append(";");
    }

    protected void createTableHead(StringBuilder createTableSql, String tableName) {
        createTableSql.append("CREATE TABLE IF NOT EXISTS ").append(tableName).append("(");
    }

    protected void createTableBody(StringBuilder createTableSql, List<FieldDefinition> fieldDefinitions) {
        ArrayList<FieldDefinition> keyDefinitionList = new ArrayList<FieldDefinition>();
        for (FieldDefinition fieldDefinition : fieldDefinitions) {
            String type = fieldDefinition.getType();
            if (type == null) {
                throw new RuntimeException("the type of fieldDefinitions should not be null");
            }
            Mapping mapping = (Mapping)this.getJdbcTypeMapping().get(type);
            if (mapping != null) {
                createTableSql.append(mapping.toDataBaseSting(fieldDefinition)).append(",   ");
                if (!fieldDefinition.getIsKey().booleanValue()) continue;
                keyDefinitionList.add(fieldDefinition);
                continue;
            }
            throw new RuntimeException("the type[" + fieldDefinition.getType() + "] is not register for mapping ");
        }
        if (keyDefinitionList.size() < 0) {
            throw new RuntimeException("no key talbe is not allow");
        }
        createTableSql.append(this.createKeyDefinition(keyDefinitionList));
    }

    private String createKeyDefinition(List<FieldDefinition> keyDefinitionList) {
        StringBuilder sql = new StringBuilder();
        sql.append(" PRIMARY KEY");
        boolean isFirst = true;
        for (FieldDefinition fieldDefinition : keyDefinitionList) {
            if (isFirst) {
                sql.append("(");
                isFirst = false;
            } else {
                sql.append(",");
            }
            sql.append(fieldDefinition.getName());
        }
        sql.append(")");
        return sql.toString();
    }

    protected void createTableEnd(StringBuilder createTableSql) {
        createTableSql.append(");");
    }

    public void clearTableSql(StringBuilder clearTableSq, String tableName, boolean ifdrop) {
        if (ifdrop) {
            clearTableSq.append("DROP TABLE IF EXISTS ").append(tableName);
        } else {
            clearTableSq.append("TRUNCATE TABLE ").append(tableName);
        }
    }
}

