/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_core;

import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Const;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.Namespace;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.annotation.StdString;
import org.bytedeco.opencv.opencv_core.FileNodeIterator;
import org.bytedeco.opencv.opencv_core.FileStorage;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.StringVector;
import org.bytedeco.opencv.presets.opencv_core;

@Namespace(value="cv")
@NoOffset
@Properties(inherit={opencv_core.class})
public class FileNode
extends Pointer {
    public static final int NONE = 0;
    public static final int INT = 1;
    public static final int REAL = 2;
    public static final int FLOAT = 2;
    public static final int STR = 3;
    public static final int STRING = 3;
    public static final int SEQ = 4;
    public static final int MAP = 5;
    public static final int TYPE_MASK = 7;
    public static final int FLOW = 8;
    public static final int UNIFORM = 8;
    public static final int EMPTY = 16;
    public static final int NAMED = 32;

    public FileNode(Pointer p) {
        super(p);
    }

    public FileNode(long size) {
        super((Pointer)null);
        this.allocateArray(size);
    }

    private native void allocateArray(long var1);

    public FileNode position(long position) {
        return (FileNode)super.position(position);
    }

    public FileNode getPointer(long i) {
        return new FileNode(this).position(this.position + i);
    }

    public FileNode() {
        super((Pointer)null);
        this.allocate();
    }

    private native void allocate();

    public FileNode(@Const FileStorage fs, @Cast(value={"size_t"}) long blockIdx, @Cast(value={"size_t"}) long ofs) {
        super((Pointer)null);
        this.allocate(fs, blockIdx, ofs);
    }

    private native void allocate(@Const FileStorage var1, @Cast(value={"size_t"}) long var2, @Cast(value={"size_t"}) long var4);

    public FileNode(@Const @ByRef FileNode node) {
        super((Pointer)null);
        this.allocate(node);
    }

    private native void allocate(@Const @ByRef FileNode var1);

    @ByRef
    @Name(value={"operator ="})
    public native FileNode put(@Const @ByRef FileNode var1);

    @ByVal
    @Name(value={"operator []"})
    public native FileNode get(@opencv_core.Str BytePointer var1);

    @ByVal
    @Name(value={"operator []"})
    public native FileNode get(@opencv_core.Str String var1);

    @ByVal
    @Name(value={"operator []"})
    public native FileNode getNode(@Cast(value={"const char*"}) BytePointer var1);

    @ByVal
    @Name(value={"operator []"})
    public native FileNode getNode(String var1);

    @ByVal
    @Name(value={"operator []"})
    public native FileNode at(int var1);

    @ByVal
    public native StringVector keys();

    public native int type();

    @Cast(value={"bool"})
    public native boolean empty();

    @Cast(value={"bool"})
    public native boolean isNone();

    @Cast(value={"bool"})
    public native boolean isSeq();

    @Cast(value={"bool"})
    public native boolean isMap();

    @Cast(value={"bool"})
    public native boolean isInt();

    @Cast(value={"bool"})
    public native boolean isReal();

    @Cast(value={"bool"})
    public native boolean isString();

    @Cast(value={"bool"})
    public native boolean isNamed();

    @StdString
    public native BytePointer name();

    @Cast(value={"size_t"})
    public native long size();

    @Cast(value={"size_t"})
    public native long rawSize();

    @Name(value={"operator int"})
    public native int asInt();

    @Name(value={"operator float"})
    public native float asFloat();

    @Name(value={"operator double"})
    public native double asDouble();

    @Name(value={"operator std::string"})
    @StdString
    public native BytePointer asBytePointer();

    @Cast(value={"bool"})
    public static native boolean isMap(int var0);

    @Cast(value={"bool"})
    public static native boolean isSeq(int var0);

    @Cast(value={"bool"})
    public static native boolean isCollection(int var0);

    @Cast(value={"bool"})
    public static native boolean isEmptyCollection(int var0);

    @Cast(value={"bool"})
    public static native boolean isFlow(int var0);

    @Cast(value={"uchar*"})
    public native BytePointer ptr();

    @ByVal
    public native FileNodeIterator begin();

    @ByVal
    public native FileNodeIterator end();

    public native void readRaw(@opencv_core.Str BytePointer var1, Pointer var2, @Cast(value={"size_t"}) long var3);

    public native void readRaw(@opencv_core.Str String var1, Pointer var2, @Cast(value={"size_t"}) long var3);

    public native void setValue(int var1, @Const Pointer var2, int var3);

    public native void setValue(int var1, @Const Pointer var2);

    public native double real();

    @StdString
    public native BytePointer string();

    @ByVal
    public native Mat mat();

    @Cast(value={"size_t"})
    public native long blockIdx();

    public native FileNode blockIdx(long var1);

    @Cast(value={"size_t"})
    public native long ofs();

    public native FileNode ofs(long var1);

    static {
        Loader.load();
    }
}

