/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.form.handler;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.bpm.engine.form.FormField;
import org.camunda.bpm.engine.form.FormProperty;
import org.camunda.bpm.engine.impl.bpmn.parser.BpmnParse;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.el.Expression;
import org.camunda.bpm.engine.impl.el.ExpressionManager;
import org.camunda.bpm.engine.impl.form.FormDataImpl;
import org.camunda.bpm.engine.impl.form.handler.FormFieldHandler;
import org.camunda.bpm.engine.impl.form.handler.FormFieldValidationConstraintHandler;
import org.camunda.bpm.engine.impl.form.handler.FormHandler;
import org.camunda.bpm.engine.impl.form.handler.FormPropertyHandler;
import org.camunda.bpm.engine.impl.form.type.AbstractFormFieldType;
import org.camunda.bpm.engine.impl.form.type.FormTypes;
import org.camunda.bpm.engine.impl.form.validator.FormFieldValidator;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.history.event.HistoryEvent;
import org.camunda.bpm.engine.impl.history.event.HistoryEventProcessor;
import org.camunda.bpm.engine.impl.history.event.HistoryEventTypes;
import org.camunda.bpm.engine.impl.history.producer.HistoryEventProducer;
import org.camunda.bpm.engine.impl.persistence.entity.DeploymentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.util.xml.Element;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.impl.VariableMapImpl;
import org.camunda.bpm.engine.variable.value.SerializableValue;
import org.camunda.bpm.engine.variable.value.TypedValue;

public class DefaultFormHandler
implements FormHandler {
    public static final String FORM_FIELD_ELEMENT = "formField";
    public static final String FORM_PROPERTY_ELEMENT = "formProperty";
    private static final String BUSINESS_KEY_ATTRIBUTE = "businessKey";
    protected String deploymentId;
    protected String businessKeyFieldId;
    protected List<FormPropertyHandler> formPropertyHandlers = new ArrayList<FormPropertyHandler>();
    protected List<FormFieldHandler> formFieldHandlers = new ArrayList<FormFieldHandler>();

    @Override
    public void parseConfiguration(Element activityElement, DeploymentEntity deployment, ProcessDefinitionEntity processDefinition, BpmnParse bpmnParse) {
        this.deploymentId = deployment.getId();
        ExpressionManager expressionManager = Context.getProcessEngineConfiguration().getExpressionManager();
        Element extensionElement = activityElement.element("extensionElements");
        if (extensionElement != null) {
            this.parseFormProperties(bpmnParse, expressionManager, extensionElement);
            this.parseFormData(bpmnParse, expressionManager, extensionElement);
        }
    }

    protected void parseFormData(BpmnParse bpmnParse, ExpressionManager expressionManager, Element extensionElement) {
        Element formData = extensionElement.elementNS(BpmnParse.CAMUNDA_BPMN_EXTENSIONS_NS, "formData");
        if (formData != null) {
            this.businessKeyFieldId = formData.attribute(BUSINESS_KEY_ATTRIBUTE);
            this.parseFormFields(formData, bpmnParse, expressionManager);
        }
    }

    protected void parseFormFields(Element formData, BpmnParse bpmnParse, ExpressionManager expressionManager) {
        List<Element> formFields = formData.elementsNS(BpmnParse.CAMUNDA_BPMN_EXTENSIONS_NS, FORM_FIELD_ELEMENT);
        for (Element formField : formFields) {
            this.parseFormField(formField, bpmnParse, expressionManager);
        }
    }

    protected void parseFormField(Element formField, BpmnParse bpmnParse, ExpressionManager expressionManager) {
        String name;
        FormFieldHandler formFieldHandler = new FormFieldHandler();
        String id = formField.attribute("id");
        if (id == null || id.isEmpty()) {
            bpmnParse.addError("attribute id must be set for FormFieldGroup and must have a non-empty value", formField);
        } else {
            formFieldHandler.setId(id);
        }
        if (id.equals(this.businessKeyFieldId)) {
            formFieldHandler.setBusinessKey(true);
        }
        if ((name = formField.attribute("label")) != null) {
            Expression nameExpression = expressionManager.createExpression(name);
            formFieldHandler.setLabel(nameExpression);
        }
        this.parseProperties(formField, formFieldHandler, bpmnParse, expressionManager);
        this.parseValidation(formField, formFieldHandler, bpmnParse, expressionManager);
        FormTypes formTypes = this.getFormTypes();
        AbstractFormFieldType formType = formTypes.parseFormPropertyType(formField, bpmnParse);
        formFieldHandler.setType(formType);
        String defaultValue = formField.attribute("defaultValue");
        if (defaultValue != null) {
            Expression defaultValueExpression = expressionManager.createExpression(defaultValue);
            formFieldHandler.setDefaultValueExpression(defaultValueExpression);
        }
        this.formFieldHandlers.add(formFieldHandler);
    }

    protected void parseProperties(Element formField, FormFieldHandler formFieldHandler, BpmnParse bpmnParse, ExpressionManager expressionManager) {
        Element propertiesElement = formField.elementNS(BpmnParse.CAMUNDA_BPMN_EXTENSIONS_NS, "properties");
        if (propertiesElement != null) {
            List<Element> propertyElements = propertiesElement.elementsNS(BpmnParse.CAMUNDA_BPMN_EXTENSIONS_NS, "property");
            LinkedHashMap<String, String> propertyMap = new LinkedHashMap<String, String>();
            for (Element property : propertyElements) {
                String id = property.attribute("id");
                String value = property.attribute("value");
                propertyMap.put(id, value);
            }
            formFieldHandler.setProperties(propertyMap);
        }
    }

    protected void parseValidation(Element formField, FormFieldHandler formFieldHandler, BpmnParse bpmnParse, ExpressionManager expressionManager) {
        Element validationElement = formField.elementNS(BpmnParse.CAMUNDA_BPMN_EXTENSIONS_NS, "validation");
        if (validationElement != null) {
            List<Element> constraintElements = validationElement.elementsNS(BpmnParse.CAMUNDA_BPMN_EXTENSIONS_NS, "constraint");
            for (Element property : constraintElements) {
                FormFieldValidator validator = Context.getProcessEngineConfiguration().getFormValidators().createValidator(property, bpmnParse, expressionManager);
                String validatorName = property.attribute("name");
                String validatorConfig = property.attribute("config");
                if (validator == null) continue;
                FormFieldValidationConstraintHandler handler = new FormFieldValidationConstraintHandler();
                handler.setName(validatorName);
                handler.setConfig(validatorConfig);
                handler.setValidator(validator);
                formFieldHandler.getValidationHandlers().add(handler);
            }
        }
    }

    protected FormTypes getFormTypes() {
        FormTypes formTypes = Context.getProcessEngineConfiguration().getFormTypes();
        return formTypes;
    }

    protected void parseFormProperties(BpmnParse bpmnParse, ExpressionManager expressionManager, Element extensionElement) {
        FormTypes formTypes = this.getFormTypes();
        List<Element> formPropertyElements = extensionElement.elementsNS(BpmnParse.CAMUNDA_BPMN_EXTENSIONS_NS, FORM_PROPERTY_ELEMENT);
        for (Element formPropertyElement : formPropertyElements) {
            String defaultExpressionText;
            FormPropertyHandler formPropertyHandler = new FormPropertyHandler();
            String id = formPropertyElement.attribute("id");
            if (id == null) {
                bpmnParse.addError("attribute 'id' is required", formPropertyElement);
            }
            formPropertyHandler.setId(id);
            String name = formPropertyElement.attribute("name");
            formPropertyHandler.setName(name);
            AbstractFormFieldType type = formTypes.parseFormPropertyType(formPropertyElement, bpmnParse);
            formPropertyHandler.setType(type);
            String requiredText = formPropertyElement.attribute("required", "false");
            Boolean required = bpmnParse.parseBooleanAttribute(requiredText);
            if (required != null) {
                formPropertyHandler.setRequired(required);
            } else {
                bpmnParse.addError("attribute 'required' must be one of {on|yes|true|enabled|active|off|no|false|disabled|inactive}", formPropertyElement);
            }
            String readableText = formPropertyElement.attribute("readable", "true");
            Boolean readable = bpmnParse.parseBooleanAttribute(readableText);
            if (readable != null) {
                formPropertyHandler.setReadable(readable);
            } else {
                bpmnParse.addError("attribute 'readable' must be one of {on|yes|true|enabled|active|off|no|false|disabled|inactive}", formPropertyElement);
            }
            String writableText = formPropertyElement.attribute("writable", "true");
            Boolean writable = bpmnParse.parseBooleanAttribute(writableText);
            if (writable != null) {
                formPropertyHandler.setWritable(writable);
            } else {
                bpmnParse.addError("attribute 'writable' must be one of {on|yes|true|enabled|active|off|no|false|disabled|inactive}", formPropertyElement);
            }
            String variableName = formPropertyElement.attribute("variable");
            formPropertyHandler.setVariableName(variableName);
            String expressionText = formPropertyElement.attribute("expression");
            if (expressionText != null) {
                Expression expression = expressionManager.createExpression(expressionText);
                formPropertyHandler.setVariableExpression(expression);
            }
            if ((defaultExpressionText = formPropertyElement.attribute("default")) != null) {
                Expression defaultExpression = expressionManager.createExpression(defaultExpressionText);
                formPropertyHandler.setDefaultExpression(defaultExpression);
            }
            this.formPropertyHandlers.add(formPropertyHandler);
        }
    }

    protected void initializeFormProperties(FormDataImpl formData, ExecutionEntity execution) {
        ArrayList<FormProperty> formProperties = new ArrayList<FormProperty>();
        for (FormPropertyHandler formPropertyHandler : this.formPropertyHandlers) {
            if (!formPropertyHandler.isReadable()) continue;
            FormProperty formProperty = formPropertyHandler.createFormProperty(execution);
            formProperties.add(formProperty);
        }
        formData.setFormProperties(formProperties);
    }

    protected void initializeFormFields(FormDataImpl taskFormData, ExecutionEntity execution) {
        List<FormField> formFields = taskFormData.getFormFields();
        for (FormFieldHandler formFieldHandler : this.formFieldHandlers) {
            formFields.add(formFieldHandler.createFormField(execution));
        }
    }

    @Override
    public void submitFormVariables(VariableMap properties, VariableScope variableScope) {
        boolean userOperationLogEnabled = Context.getCommandContext().isUserOperationLogEnabled();
        Context.getCommandContext().enableUserOperationLog();
        VariableMapImpl propertiesCopy = new VariableMapImpl((Map)properties);
        for (FormPropertyHandler formPropertyHandler : this.formPropertyHandlers) {
            formPropertyHandler.submitFormProperty(variableScope, (VariableMap)propertiesCopy);
        }
        for (FormFieldHandler formFieldHandler : this.formFieldHandlers) {
            if (formFieldHandler.isBusinessKey()) continue;
            formFieldHandler.handleSubmit(variableScope, (VariableMap)propertiesCopy, properties);
        }
        for (String propertyId : propertiesCopy.keySet()) {
            variableScope.setVariable(propertyId, propertiesCopy.getValueTyped(propertyId));
        }
        this.fireFormPropertyHistoryEvents(properties, variableScope);
        Context.getCommandContext().setLogUserOperationEnabled(userOperationLogEnabled);
    }

    protected void fireFormPropertyHistoryEvents(VariableMap properties, VariableScope variableScope) {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        HistoryLevel historyLevel = processEngineConfiguration.getHistoryLevel();
        if (historyLevel.isHistoryEventProduced(HistoryEventTypes.FORM_PROPERTY_UPDATE, variableScope)) {
            String taskId;
            ExecutionEntity executionEntity;
            if (variableScope instanceof ExecutionEntity) {
                executionEntity = (ExecutionEntity)variableScope;
                taskId = null;
            } else if (variableScope instanceof TaskEntity) {
                TaskEntity task = (TaskEntity)variableScope;
                executionEntity = task.getExecution();
                taskId = task.getId();
            } else {
                executionEntity = null;
                taskId = null;
            }
            if (executionEntity != null) {
                for (final String variableName : properties.keySet()) {
                    TypedValue value = properties.getValueTyped(variableName);
                    if (value instanceof SerializableValue || value.getValue() == null || !(value.getValue() instanceof String)) continue;
                    final String stringValue = (String)value.getValue();
                    HistoryEventProcessor.processHistoryEvents(new HistoryEventProcessor.HistoryEventCreator(){

                        @Override
                        public HistoryEvent createHistoryEvent(HistoryEventProducer producer) {
                            return producer.createFormPropertyUpdateEvt(executionEntity, variableName, stringValue, taskId);
                        }
                    });
                }
            }
        }
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public List<FormPropertyHandler> getFormPropertyHandlers() {
        return this.formPropertyHandlers;
    }

    public void setFormPropertyHandlers(List<FormPropertyHandler> formPropertyHandlers) {
        this.formPropertyHandlers = formPropertyHandlers;
    }

    public String getBusinessKeyFieldId() {
        return this.businessKeyFieldId;
    }

    public void setBusinessKeyFieldId(String businessKeyFieldId) {
        this.businessKeyFieldId = businessKeyFieldId;
    }
}

