/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.migration;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cfg.CommandChecker;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.context.ProcessApplicationContextUtil;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.migration.AbstractMigrationCmd;
import org.camunda.bpm.engine.impl.migration.MigrationLogger;
import org.camunda.bpm.engine.impl.migration.MigrationPlanExecutionBuilderImpl;
import org.camunda.bpm.engine.impl.migration.instance.DeleteUnmappedInstanceVisitor;
import org.camunda.bpm.engine.impl.migration.instance.MigratingActivityInstance;
import org.camunda.bpm.engine.impl.migration.instance.MigratingActivityInstanceVisitor;
import org.camunda.bpm.engine.impl.migration.instance.MigratingCompensationEventSubscriptionInstance;
import org.camunda.bpm.engine.impl.migration.instance.MigratingEventScopeInstance;
import org.camunda.bpm.engine.impl.migration.instance.MigratingProcessElementInstanceTopDownWalker;
import org.camunda.bpm.engine.impl.migration.instance.MigratingProcessInstance;
import org.camunda.bpm.engine.impl.migration.instance.MigratingScopeInstance;
import org.camunda.bpm.engine.impl.migration.instance.MigratingScopeInstanceBottomUpWalker;
import org.camunda.bpm.engine.impl.migration.instance.MigratingTransitionInstance;
import org.camunda.bpm.engine.impl.migration.instance.MigrationCompensationInstanceVisitor;
import org.camunda.bpm.engine.impl.migration.instance.parser.MigratingInstanceParser;
import org.camunda.bpm.engine.impl.migration.validation.instance.MigratingActivityInstanceValidationReportImpl;
import org.camunda.bpm.engine.impl.migration.validation.instance.MigratingActivityInstanceValidator;
import org.camunda.bpm.engine.impl.migration.validation.instance.MigratingCompensationInstanceValidator;
import org.camunda.bpm.engine.impl.migration.validation.instance.MigratingProcessInstanceValidationReportImpl;
import org.camunda.bpm.engine.impl.migration.validation.instance.MigratingTransitionInstanceValidationReportImpl;
import org.camunda.bpm.engine.impl.migration.validation.instance.MigratingTransitionInstanceValidator;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.tree.ReferenceWalker;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.migration.MigratingTransitionInstanceValidationReport;
import org.camunda.bpm.engine.migration.MigrationPlan;

public class MigrateProcessInstanceCmd
extends AbstractMigrationCmd<Void> {
    protected static final MigrationLogger LOGGER = ProcessEngineLogger.MIGRATION_LOGGER;
    protected boolean writeOperationLog;

    public MigrateProcessInstanceCmd(MigrationPlanExecutionBuilderImpl migrationPlanExecutionBuilder, boolean writeOperationLog) {
        super(migrationPlanExecutionBuilder);
        this.writeOperationLog = writeOperationLog;
    }

    @Override
    public Void execute(final CommandContext commandContext) {
        final MigrationPlan migrationPlan = this.executionBuilder.getMigrationPlan();
        final Collection<String> processInstanceIds = this.collectProcessInstanceIds(commandContext);
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "Migration plan cannot be null", "migration plan", (Object)migrationPlan);
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "Process instance ids cannot empty", "process instance ids", processInstanceIds);
        EnsureUtil.ensureNotContainsNull(BadUserRequestException.class, "Process instance ids cannot be null", "process instance ids", processInstanceIds);
        ProcessDefinitionEntity sourceDefinition = this.resolveSourceProcessDefinition(commandContext);
        final ProcessDefinitionEntity targetDefinition = this.resolveTargetProcessDefinition(commandContext);
        this.checkAuthorizations(commandContext, sourceDefinition, targetDefinition, processInstanceIds);
        if (this.writeOperationLog) {
            this.writeUserOperationLog(commandContext, sourceDefinition, targetDefinition, processInstanceIds.size(), false);
        }
        commandContext.runWithoutAuthorization(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                for (String processInstanceId : processInstanceIds) {
                    MigrateProcessInstanceCmd.this.migrateProcessInstance(commandContext, processInstanceId, migrationPlan, targetDefinition);
                }
                return null;
            }
        });
        return null;
    }

    public Void migrateProcessInstance(CommandContext commandContext, String processInstanceId, MigrationPlan migrationPlan, ProcessDefinitionEntity targetProcessDefinition) {
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "Process instance id cannot be null", "process instance id", (Object)processInstanceId);
        ExecutionEntity processInstance = commandContext.getExecutionManager().findExecutionById(processInstanceId);
        this.ensureProcessInstanceExist(processInstanceId, processInstance);
        this.ensureOperationAllowed(commandContext, processInstance, targetProcessDefinition);
        this.ensureSameProcessDefinition(processInstance, migrationPlan.getSourceProcessDefinitionId());
        MigratingProcessInstanceValidationReportImpl processInstanceReport = new MigratingProcessInstanceValidationReportImpl();
        MigratingInstanceParser migratingInstanceParser = new MigratingInstanceParser(Context.getProcessEngineConfiguration().getProcessEngine());
        final MigratingProcessInstance migratingProcessInstance = migratingInstanceParser.parse(processInstance.getId(), migrationPlan, processInstanceReport);
        this.validateInstructions(commandContext, migratingProcessInstance, processInstanceReport);
        if (processInstanceReport.hasFailures()) {
            throw LOGGER.failingMigratingProcessInstanceValidation(processInstanceReport);
        }
        this.executeInContext(new Runnable(){

            @Override
            public void run() {
                MigrateProcessInstanceCmd.this.deleteUnmappedActivityInstances(migratingProcessInstance);
            }
        }, migratingProcessInstance.getSourceDefinition());
        this.executeInContext(new Runnable(){

            @Override
            public void run() {
                MigrateProcessInstanceCmd.this.migrateProcessInstance(migratingProcessInstance);
            }
        }, migratingProcessInstance.getTargetDefinition());
        return null;
    }

    protected <T> void executeInContext(Runnable runnable, ProcessDefinitionEntity contextDefinition) {
        ProcessApplicationContextUtil.doContextSwitch(runnable, contextDefinition);
    }

    protected void deleteUnmappedActivityInstances(MigratingProcessInstance migratingProcessInstance) {
        Set<MigratingScopeInstance> leafInstances = this.collectLeafInstances(migratingProcessInstance);
        final DeleteUnmappedInstanceVisitor visitor = new DeleteUnmappedInstanceVisitor(this.executionBuilder.isSkipCustomListeners(), this.executionBuilder.isSkipIoMappings());
        for (MigratingScopeInstance leafInstance : leafInstances) {
            MigratingScopeInstanceBottomUpWalker walker = new MigratingScopeInstanceBottomUpWalker(leafInstance);
            walker.addPreVisitor(visitor);
            walker.walkUntil(new ReferenceWalker.WalkCondition<MigratingScopeInstance>(){

                @Override
                public boolean isFulfilled(MigratingScopeInstance element) {
                    return element == null || !visitor.hasVisitedAll(element.getChildScopeInstances());
                }
            });
        }
    }

    protected Set<MigratingScopeInstance> collectLeafInstances(MigratingProcessInstance migratingProcessInstance) {
        HashSet<MigratingScopeInstance> leafInstances = new HashSet<MigratingScopeInstance>();
        for (MigratingScopeInstance migratingScopeInstance : migratingProcessInstance.getMigratingScopeInstances()) {
            if (!migratingScopeInstance.getChildScopeInstances().isEmpty()) continue;
            leafInstances.add(migratingScopeInstance);
        }
        return leafInstances;
    }

    protected void validateInstructions(CommandContext commandContext, MigratingProcessInstance migratingProcessInstance, MigratingProcessInstanceValidationReportImpl processInstanceReport) {
        MigratingActivityInstance ancestorInstance;
        Object instanceReport;
        List<MigratingActivityInstanceValidator> migratingActivityInstanceValidators = commandContext.getProcessEngineConfiguration().getMigratingActivityInstanceValidators();
        List<MigratingTransitionInstanceValidator> migratingTransitionInstanceValidators = commandContext.getProcessEngineConfiguration().getMigratingTransitionInstanceValidators();
        List<MigratingCompensationInstanceValidator> migratingCompensationInstanceValidators = commandContext.getProcessEngineConfiguration().getMigratingCompensationInstanceValidators();
        HashMap<MigratingActivityInstance, MigratingActivityInstanceValidationReportImpl> instanceReports = new HashMap<MigratingActivityInstance, MigratingActivityInstanceValidationReportImpl>();
        for (MigratingActivityInstance migratingActivityInstance : migratingProcessInstance.getMigratingActivityInstances()) {
            instanceReport = this.validateActivityInstance(migratingActivityInstance, migratingProcessInstance, migratingActivityInstanceValidators);
            instanceReports.put(migratingActivityInstance, (MigratingActivityInstanceValidationReportImpl)instanceReport);
        }
        for (MigratingEventScopeInstance migratingEventScopeInstance : migratingProcessInstance.getMigratingEventScopeInstances()) {
            ancestorInstance = migratingEventScopeInstance.getClosestAncestorActivityInstance();
            this.validateEventScopeInstance(migratingEventScopeInstance, migratingProcessInstance, migratingCompensationInstanceValidators, (MigratingActivityInstanceValidationReportImpl)instanceReports.get(ancestorInstance));
        }
        for (MigratingCompensationEventSubscriptionInstance migratingEventSubscriptionInstance : migratingProcessInstance.getMigratingCompensationSubscriptionInstances()) {
            ancestorInstance = migratingEventSubscriptionInstance.getClosestAncestorActivityInstance();
            this.validateCompensateSubscriptionInstance(migratingEventSubscriptionInstance, migratingProcessInstance, migratingCompensationInstanceValidators, (MigratingActivityInstanceValidationReportImpl)instanceReports.get(ancestorInstance));
        }
        for (MigratingActivityInstanceValidationReportImpl instanceReport2 : instanceReports.values()) {
            if (!instanceReport2.hasFailures()) continue;
            processInstanceReport.addActivityInstanceReport(instanceReport2);
        }
        for (MigratingTransitionInstance migratingTransitionInstance : migratingProcessInstance.getMigratingTransitionInstances()) {
            instanceReport = this.validateTransitionInstance(migratingTransitionInstance, migratingProcessInstance, migratingTransitionInstanceValidators);
            if (!((MigratingTransitionInstanceValidationReportImpl)instanceReport).hasFailures()) continue;
            processInstanceReport.addTransitionInstanceReport((MigratingTransitionInstanceValidationReport)instanceReport);
        }
    }

    protected MigratingActivityInstanceValidationReportImpl validateActivityInstance(MigratingActivityInstance migratingActivityInstance, MigratingProcessInstance migratingProcessInstance, List<MigratingActivityInstanceValidator> migratingActivityInstanceValidators) {
        MigratingActivityInstanceValidationReportImpl instanceReport = new MigratingActivityInstanceValidationReportImpl(migratingActivityInstance);
        for (MigratingActivityInstanceValidator migratingActivityInstanceValidator : migratingActivityInstanceValidators) {
            migratingActivityInstanceValidator.validate(migratingActivityInstance, migratingProcessInstance, instanceReport);
        }
        return instanceReport;
    }

    protected MigratingTransitionInstanceValidationReportImpl validateTransitionInstance(MigratingTransitionInstance migratingTransitionInstance, MigratingProcessInstance migratingProcessInstance, List<MigratingTransitionInstanceValidator> migratingTransitionInstanceValidators) {
        MigratingTransitionInstanceValidationReportImpl instanceReport = new MigratingTransitionInstanceValidationReportImpl(migratingTransitionInstance);
        for (MigratingTransitionInstanceValidator migratingTransitionInstanceValidator : migratingTransitionInstanceValidators) {
            migratingTransitionInstanceValidator.validate(migratingTransitionInstance, migratingProcessInstance, instanceReport);
        }
        return instanceReport;
    }

    protected void validateEventScopeInstance(MigratingEventScopeInstance eventScopeInstance, MigratingProcessInstance migratingProcessInstance, List<MigratingCompensationInstanceValidator> migratingTransitionInstanceValidators, MigratingActivityInstanceValidationReportImpl instanceReport) {
        for (MigratingCompensationInstanceValidator validator : migratingTransitionInstanceValidators) {
            validator.validate(eventScopeInstance, migratingProcessInstance, instanceReport);
        }
    }

    protected void validateCompensateSubscriptionInstance(MigratingCompensationEventSubscriptionInstance eventSubscriptionInstance, MigratingProcessInstance migratingProcessInstance, List<MigratingCompensationInstanceValidator> migratingTransitionInstanceValidators, MigratingActivityInstanceValidationReportImpl instanceReport) {
        for (MigratingCompensationInstanceValidator validator : migratingTransitionInstanceValidators) {
            validator.validate(eventSubscriptionInstance, migratingProcessInstance, instanceReport);
        }
    }

    protected void migrateProcessInstance(MigratingProcessInstance migratingProcessInstance) {
        MigratingActivityInstance rootActivityInstance = migratingProcessInstance.getRootInstance();
        MigratingProcessElementInstanceTopDownWalker walker = new MigratingProcessElementInstanceTopDownWalker(rootActivityInstance);
        walker.addPreVisitor(new MigratingActivityInstanceVisitor(this.executionBuilder.isSkipCustomListeners(), this.executionBuilder.isSkipIoMappings()));
        walker.addPreVisitor(new MigrationCompensationInstanceVisitor());
        walker.walkUntil();
    }

    protected void ensureProcessInstanceExist(String processInstanceId, ExecutionEntity processInstance) {
        if (processInstance == null) {
            throw LOGGER.processInstanceDoesNotExist(processInstanceId);
        }
    }

    protected void ensureSameProcessDefinition(ExecutionEntity processInstance, String processDefinitionId) {
        if (!processDefinitionId.equals(processInstance.getProcessDefinitionId())) {
            throw LOGGER.processDefinitionOfInstanceDoesNotMatchMigrationPlan(processInstance, processDefinitionId);
        }
    }

    protected void ensureOperationAllowed(CommandContext commandContext, ExecutionEntity processInstance, ProcessDefinitionEntity targetProcessDefinition) {
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkMigrateProcessInstance(processInstance, targetProcessDefinition);
        }
    }
}

