/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.history.HistoricIncident;
import org.camunda.bpm.engine.impl.HistoricIncidentQueryImpl;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.ListQueryParameterObject;
import org.camunda.bpm.engine.impl.db.entitymanager.operation.DbOperation;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.history.event.HistoricIncidentEventEntity;
import org.camunda.bpm.engine.impl.history.event.HistoryEventTypes;
import org.camunda.bpm.engine.impl.persistence.AbstractHistoricManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricIncidentEntity;

public class HistoricIncidentManager
extends AbstractHistoricManager {
    public long findHistoricIncidentCountByQueryCriteria(HistoricIncidentQueryImpl query) {
        this.configureQuery(query);
        return (Long)this.getDbEntityManager().selectOne("selectHistoricIncidentCountByQueryCriteria", query);
    }

    public List<HistoricIncident> findHistoricIncidentByQueryCriteria(HistoricIncidentQueryImpl query, Page page) {
        this.configureQuery(query);
        return this.getDbEntityManager().selectList("selectHistoricIncidentByQueryCriteria", query, page);
    }

    public void addRemovalTimeToIncidentsByRootProcessInstanceId(String rootProcessInstanceId, Date removalTime) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("rootProcessInstanceId", rootProcessInstanceId);
        parameters.put("removalTime", removalTime);
        this.getDbEntityManager().updatePreserveOrder(HistoricIncidentEventEntity.class, "updateHistoricIncidentsByRootProcessInstanceId", parameters);
    }

    public void deleteHistoricIncidentsByProcessInstanceIds(List<String> processInstanceIds) {
        this.getDbEntityManager().deletePreserveOrder(HistoricIncidentEntity.class, "deleteHistoricIncidentsByProcessInstanceIds", processInstanceIds);
    }

    public void deleteHistoricIncidentsByProcessDefinitionId(String processDefinitionId) {
        if (this.isHistoryEventProduced()) {
            this.getDbEntityManager().delete(HistoricIncidentEntity.class, "deleteHistoricIncidentsByProcessDefinitionId", processDefinitionId);
        }
    }

    public void deleteHistoricIncidentsByJobDefinitionId(String jobDefinitionId) {
        if (this.isHistoryEventProduced()) {
            this.getDbEntityManager().delete(HistoricIncidentEntity.class, "deleteHistoricIncidentsByJobDefinitionId", jobDefinitionId);
        }
    }

    public void deleteHistoricIncidentsByBatchId(List<String> historicBatchIds) {
        if (this.isHistoryEventProduced()) {
            this.getDbEntityManager().delete(HistoricIncidentEntity.class, "deleteHistoricIncidentsByBatchIds", historicBatchIds);
        }
    }

    protected void configureQuery(HistoricIncidentQueryImpl query) {
        this.getAuthorizationManager().configureHistoricIncidentQuery(query);
        this.getTenantManager().configureQuery(query);
    }

    protected boolean isHistoryEventProduced() {
        HistoryLevel historyLevel = Context.getProcessEngineConfiguration().getHistoryLevel();
        return historyLevel.isHistoryEventProduced(HistoryEventTypes.INCIDENT_CREATE, null) || historyLevel.isHistoryEventProduced(HistoryEventTypes.INCIDENT_DELETE, null) || historyLevel.isHistoryEventProduced(HistoryEventTypes.INCIDENT_MIGRATE, null) || historyLevel.isHistoryEventProduced(HistoryEventTypes.INCIDENT_RESOLVE, null);
    }

    public DbOperation deleteHistoricIncidentsByRemovalTime(Date removalTime, int minuteFrom, int minuteTo, int batchSize) {
        HashMap<String, Comparable<Date>> parameters = new HashMap<String, Comparable<Date>>();
        parameters.put("removalTime", removalTime);
        if (minuteTo - minuteFrom + 1 < 60) {
            parameters.put("minuteFrom", Integer.valueOf(minuteFrom));
            parameters.put("minuteTo", Integer.valueOf(minuteTo));
        }
        parameters.put("batchSize", Integer.valueOf(batchSize));
        return this.getDbEntityManager().deletePreserveOrder(HistoricIncidentEntity.class, "deleteHistoricIncidentsByRemovalTime", new ListQueryParameterObject(parameters, 0, batchSize));
    }
}

