/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity.util;

import java.util.Date;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.persistence.entity.Nameable;
import org.camunda.bpm.engine.repository.ResourceType;

public class ByteArrayField {
    protected ByteArrayEntity byteArrayValue;
    protected String byteArrayId;
    protected final Nameable nameProvider;
    protected ResourceType type;
    protected String rootProcessInstanceId;
    protected Date removalTime;

    public ByteArrayField(Nameable nameProvider, ResourceType type, String rootProcessInstanceId, Date removalTime) {
        this(nameProvider, type);
        this.removalTime = removalTime;
        this.rootProcessInstanceId = rootProcessInstanceId;
    }

    public ByteArrayField(Nameable nameProvider, ResourceType type) {
        this.nameProvider = nameProvider;
        this.type = type;
    }

    public String getByteArrayId() {
        return this.byteArrayId;
    }

    public void setByteArrayId(String byteArrayId) {
        this.byteArrayId = byteArrayId;
        this.byteArrayValue = null;
    }

    public byte[] getByteArrayValue() {
        this.getByteArrayEntity();
        if (this.byteArrayValue != null) {
            return this.byteArrayValue.getBytes();
        }
        return null;
    }

    protected ByteArrayEntity getByteArrayEntity() {
        if (this.byteArrayValue == null && this.byteArrayId != null && Context.getCommandContext() != null) {
            this.byteArrayValue = Context.getCommandContext().getDbEntityManager().selectById(ByteArrayEntity.class, this.byteArrayId);
            return this.byteArrayValue;
        }
        return this.byteArrayValue;
    }

    public void setByteArrayValue(byte[] bytes) {
        this.setByteArrayValue(bytes, false);
    }

    public void setByteArrayValue(byte[] bytes, boolean isTransient) {
        if (bytes != null) {
            if (this.byteArrayId != null && this.getByteArrayEntity() != null) {
                this.byteArrayValue.setBytes(bytes);
            } else {
                this.deleteByteArrayValue();
                this.byteArrayValue = new ByteArrayEntity(this.nameProvider.getName(), bytes, this.type, this.rootProcessInstanceId, this.removalTime);
                if (!isTransient) {
                    Context.getCommandContext().getByteArrayManager().insertByteArray(this.byteArrayValue);
                    this.byteArrayId = this.byteArrayValue.getId();
                }
            }
        } else {
            this.deleteByteArrayValue();
        }
    }

    public void deleteByteArrayValue() {
        if (this.byteArrayId != null) {
            this.getByteArrayEntity();
            if (this.byteArrayValue != null) {
                Context.getCommandContext().getDbEntityManager().delete(this.byteArrayValue);
            }
            this.byteArrayId = null;
        }
    }

    public void setByteArrayValue(ByteArrayEntity byteArrayValue) {
        this.byteArrayValue = byteArrayValue;
    }

    public void setRootProcessInstanceId(String rootProcessInstanceId) {
        this.rootProcessInstanceId = rootProcessInstanceId;
    }

    public void setRemovalTime(Date removalTime) {
        this.removalTime = removalTime;
    }
}

