/*
 * Decompiled with CFR 0.152.
 */
package org.databene.contiperf;

import java.io.PrintWriter;
import org.databene.contiperf.Invoker;
import org.databene.contiperf.PercentileRequirement;
import org.databene.contiperf.PerformanceRequirement;
import org.databene.contiperf.report.ReportContext;
import org.databene.contiperf.report.ReportModule;
import org.databene.contiperf.util.InvokerProxy;
import org.databene.stat.LatencyCounter;

public class PerformanceTracker
extends InvokerProxy {
    private PerformanceRequirement requirement;
    private int warmUp;
    private boolean cancelOnViolation;
    private ReportContext context;
    private LatencyCounter counter;
    private boolean counterStarted;
    private long warmUpFinishedTime;

    public PerformanceTracker(Invoker target, PerformanceRequirement requirement, ReportContext context) {
        this(target, requirement, 0, true, context);
    }

    public PerformanceTracker(Invoker target, PerformanceRequirement requirement, int warmUp, boolean cancelOnViolation, ReportContext context) {
        super(target);
        this.requirement = requirement;
        this.warmUp = warmUp;
        this.cancelOnViolation = cancelOnViolation;
        this.setContext(context);
        this.counter = null;
        this.counterStarted = false;
        this.warmUpFinishedTime = -1L;
    }

    public void setContext(ReportContext context) {
        this.context = context;
    }

    public LatencyCounter getCounter() {
        return this.counter;
    }

    public void startCounter() {
        this.reportStart();
        int max = this.requirement != null ? this.requirement.getMax() : -1;
        this.counter = new LatencyCounter(this.target.toString(), max >= 0 ? max : 1000);
        this.counter.start();
        this.counterStarted = true;
    }

    public Object invoke(Object[] args) throws Exception {
        long callStart = System.nanoTime();
        if (this.warmUpFinishedTime == -1L) {
            this.warmUpFinishedTime = callStart + (long)(this.warmUp * 1000000);
        }
        this.checkState(callStart);
        Object result = super.invoke(args);
        int latency = (int)((System.nanoTime() - callStart) / 1000000L);
        if (this.counterStarted) {
            this.counter.addSample(latency);
        }
        this.reportInvocation(latency, callStart);
        if (this.requirement != null && this.requirement.getMax() >= 0 && latency > this.requirement.getMax() && this.cancelOnViolation) {
            this.context.fail("Method " + this.getId() + " exceeded time limit of " + this.requirement.getMax() + " ms running " + latency + " ms");
        }
        return result;
    }

    private synchronized void checkState(long callStart) {
        if (callStart >= this.warmUpFinishedTime && !this.counterStarted) {
            this.startCounter();
        }
    }

    public boolean isCounterStarted() {
        return this.counterStarted;
    }

    public void stopCounter() {
        if (!this.isCounterStarted()) {
            throw new RuntimeException("Trying to stop counter before it was started");
        }
        this.counter.stop();
        this.counter.printSummary(new PrintWriter(System.out), new int[0]);
        this.reportCompletion();
        if (this.requirement != null) {
            this.checkRequirements(this.counter.duration());
        }
        this.counterStarted = false;
    }

    public void clear() {
        this.counter = null;
    }

    private void reportStart() {
        for (ReportModule module : this.context.getReportModules()) {
            module.starting(this.getId());
        }
    }

    private void reportInvocation(int latency, long callStart) {
        for (ReportModule module : this.context.getReportModules()) {
            module.invoked(this.getId(), latency, callStart);
        }
    }

    private void reportCompletion() {
        for (ReportModule module : this.context.getReportModules()) {
            module.completed(this.getId(), this.counter, this.requirement);
        }
    }

    private void checkRequirements(long elapsedMillis) {
        int requiredAverage;
        long actualThroughput;
        int requiredThroughput;
        long requiredTotalTime;
        long requiredMax = this.requirement.getMax();
        if (requiredMax >= 0L && this.counter.maxLatency() > requiredMax) {
            this.context.fail("The maximum latency of " + requiredMax + " ms was exceeded, Measured: " + this.counter.maxLatency() + " ms");
        }
        if ((requiredTotalTime = (long)this.requirement.getTotalTime()) >= 0L && elapsedMillis > requiredTotalTime) {
            this.context.fail("Test run " + this.getId() + " exceeded timeout of " + requiredTotalTime + " ms running " + elapsedMillis + " ms");
        }
        if ((requiredThroughput = this.requirement.getThroughput()) > 0 && elapsedMillis > 0L && (actualThroughput = this.counter.sampleCount() * 1000L / elapsedMillis) < (long)requiredThroughput) {
            this.context.fail("Test " + this.getId() + " had a throughput of only " + actualThroughput + " calls per second, required: " + requiredThroughput + " calls per second");
        }
        if ((requiredAverage = this.requirement.getAverage()) >= 0 && this.counter.averageLatency() > (double)requiredAverage) {
            this.context.fail("Average execution time of " + this.getId() + " exceeded the requirement of " + requiredAverage + " ms, measured " + this.counter.averageLatency() + " ms");
        }
        for (PercentileRequirement percentile : this.requirement.getPercentileRequirements()) {
            long measuredLatency = this.counter.percentileLatency(percentile.getPercentage());
            if (measuredLatency <= (long)percentile.getMillis()) continue;
            this.context.fail(percentile.getPercentage() + "-percentile of " + this.getId() + " exceeded the requirement of " + percentile.getMillis() + " ms, measured " + measuredLatency + " ms");
        }
    }
}

