/*
 * Decompiled with CFR 0.152.
 */
package org.databene.contiperf.junit;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import junit.framework.AssertionFailedError;
import org.databene.contiperf.Config;
import org.databene.contiperf.ExecutionConfig;
import org.databene.contiperf.ExecutionLogger;
import org.databene.contiperf.PerfTest;
import org.databene.contiperf.PerformanceRequirement;
import org.databene.contiperf.Required;
import org.databene.contiperf.junit.JUnitReportContext;
import org.databene.contiperf.junit.PerfTestStatement;
import org.databene.contiperf.log.ConsoleExecutionLogger;
import org.databene.contiperf.report.HtmlReportModule;
import org.databene.contiperf.report.LoggerModuleAdapter;
import org.databene.contiperf.report.ReportContext;
import org.databene.contiperf.report.ReportModule;
import org.databene.contiperf.util.ContiPerfUtil;
import org.junit.internal.runners.statements.RunAfters;
import org.junit.internal.runners.statements.RunBefores;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContiPerfRule
implements MethodRule {
    private ExecutionConfig defaultExecutionConfig;
    ReportContext context;
    private PerformanceRequirement defaultRequirements;

    public ContiPerfRule() {
        this((ReportContext)null);
    }

    public ContiPerfRule(ExecutionLogger logger) {
        this(ContiPerfRule.createReportContext(logger), null);
    }

    public ContiPerfRule(ReportModule ... modules) {
        this(ContiPerfRule.createReportContext(modules), null);
    }

    protected ContiPerfRule(ReportContext context) {
        this(context, null);
    }

    protected ContiPerfRule(ReportContext context, Object suite) {
        this.context = context == null ? JUnitReportContext.createInstance(suite) : context;
        if (suite != null) {
            Class<?> suiteClass = suite.getClass();
            this.defaultExecutionConfig = ContiPerfRule.configurePerfTest(suiteClass.getAnnotation(PerfTest.class), suiteClass.getName());
            this.defaultRequirements = ContiPerfUtil.mapRequired(suiteClass.getAnnotation(Required.class));
        }
    }

    public static ContiPerfRule createDefaultRule() {
        JUnitReportContext context = new JUnitReportContext();
        context.addReportModule(new HtmlReportModule());
        return new ContiPerfRule(context);
    }

    public static ContiPerfRule createVerboseRule() {
        JUnitReportContext context = new JUnitReportContext();
        context.addReportModule(new HtmlReportModule());
        context.addReportModule(new LoggerModuleAdapter(new ConsoleExecutionLogger()));
        return new ContiPerfRule(context);
    }

    public Statement apply(Statement base, FrameworkMethod method, Object target) {
        Config config = Config.instance();
        if (!config.active()) {
            return base;
        }
        RunBefores runBefores = null;
        RunAfters runAfters = null;
        while (base instanceof RunAfters || base instanceof RunBefores) {
            try {
                Field fNext;
                if (base instanceof RunAfters) {
                    runAfters = (RunAfters)base;
                    fNext = base.getClass().getDeclaredField("fNext");
                    fNext.setAccessible(true);
                    base = (Statement)fNext.get(base);
                    continue;
                }
                if (!(base instanceof RunBefores)) continue;
                runBefores = (RunBefores)base;
                fNext = base.getClass().getDeclaredField("fNext");
                fNext.setAccessible(true);
                base = (Statement)fNext.get(base);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (this.context.getReportModules().size() == 0) {
            this.context = JUnitReportContext.createInstance(target);
            if (this.context.getReportModules().size() == 0) {
                this.context = Config.instance().createDefaultReportContext(AssertionFailedError.class);
            }
        }
        String testId = ContiPerfRule.methodName(method, target);
        base = new PerfTestStatement(base, testId, this.executionConfig(method, testId), this.requirements(method, testId), this.context);
        try {
            Field fNext;
            if (runBefores != null) {
                fNext = runBefores.getClass().getDeclaredField("fNext");
                fNext.setAccessible(true);
                fNext.set(runBefores, base);
                base = runBefores;
            }
            if (runAfters != null) {
                fNext = runAfters.getClass().getDeclaredField("fNext");
                fNext.setAccessible(true);
                fNext.set(runAfters, base);
                base = runAfters;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return base;
    }

    public ReportContext getContext() {
        return this.context;
    }

    void setContext(ReportContext context) {
        this.context = context;
    }

    private static ReportContext createReportContext(ExecutionLogger logger) {
        JUnitReportContext context = new JUnitReportContext();
        context.addReportModule(new LoggerModuleAdapter(logger));
        return context;
    }

    private static ReportContext createReportContext(ReportModule ... modules) {
        JUnitReportContext context = new JUnitReportContext();
        for (ReportModule module : modules) {
            context.addReportModule(module);
        }
        return context;
    }

    private ExecutionConfig executionConfig(FrameworkMethod method, String methodName) {
        PerfTest annotation = ContiPerfRule.annotationOfMethodOrClass(method, PerfTest.class);
        if (annotation != null) {
            return ContiPerfRule.configurePerfTest(annotation, methodName);
        }
        if (this.defaultExecutionConfig != null) {
            return this.defaultExecutionConfig;
        }
        return new ExecutionConfig(1);
    }

    private PerformanceRequirement requirements(FrameworkMethod method, String testId) {
        Required annotation = ContiPerfRule.annotationOfMethodOrClass(method, Required.class);
        if (annotation != null) {
            return ContiPerfUtil.mapRequired(annotation);
        }
        if (this.defaultRequirements != null) {
            return this.defaultRequirements;
        }
        return null;
    }

    private static <T extends Annotation> T annotationOfMethodOrClass(FrameworkMethod method, Class<T> annotationClass) {
        Annotation methodAnnotation = method.getAnnotation(annotationClass);
        if (methodAnnotation != null) {
            return (T)methodAnnotation;
        }
        T classAnnotation = method.getMethod().getDeclaringClass().getAnnotation(annotationClass);
        return classAnnotation;
    }

    public static ExecutionConfig configurePerfTest(PerfTest annotation, String testId) {
        int count;
        ExecutionConfig config = ContiPerfUtil.mapPerfTestAnnotation(annotation);
        if (annotation == null) {
            config = new ExecutionConfig(1);
        }
        if ((count = Config.instance().getInvocationCount(testId)) >= 0) {
            config.setInvocations(count);
        }
        return config;
    }

    private static String methodName(FrameworkMethod method, Object target) {
        return target.getClass().getName() + '.' + method.getName();
    }
}

