/*
 * Decompiled with CFR 0.152.
 */
package org.databene.contiperf.report;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Date;
import org.databene.contiperf.Config;
import org.databene.contiperf.PercentileRequirement;
import org.databene.contiperf.PerformanceRequirement;
import org.databene.contiperf.report.AbstractReportModule;
import org.databene.contiperf.report.GoogleLatencyRenderer;
import org.databene.contiperf.report.ReportContext;
import org.databene.contiperf.report.ReportModule;
import org.databene.contiperf.report.ReportUtil;
import org.databene.contiperf.report.Verdict;
import org.databene.stat.LatencyCounter;

public class HtmlReportModule
extends AbstractReportModule {
    private static final String REPORT_FILENAME = "index.html";
    private static final int WIDTH = 320;
    private static final int HEIGHT = 240;
    private static final String CPF_MARKER_1 = "<!-- !!__cpf-marker1__!! -->";
    private static final String CPF_MARKER_2 = "<!-- !!__cpf-marker2__!! -->";
    ReportContext context;
    private static boolean initialized = false;
    DecimalFormat lf = new DecimalFormat();

    public void setContext(ReportContext context) {
        this.context = context;
    }

    public void completed(String id, LatencyCounter counter, PerformanceRequirement requirement) {
        this.updateReport(id, counter, requirement);
    }

    private synchronized void updateReport(String id, LatencyCounter counter, PerformanceRequirement requirement) {
        File reportFile = new File(Config.instance().getReportFolder(), REPORT_FILENAME);
        if (!initialized || !reportFile.exists()) {
            this.initReportFile(reportFile, id, counter, requirement);
        } else {
            this.extendReportFile(reportFile, id, counter, requirement);
        }
    }

    private void initReportFile(File reportFile, String id, LatencyCounter counter, PerformanceRequirement requirement) {
        initialized = true;
        try {
            PrintWriter out = new PrintWriter(new FileOutputStream(reportFile));
            out.println("<html>");
            out.println("<head>");
            out.println("<title>ContiPerf Report</title>");
            out.println("</head>");
            out.println("<body style='font-family:Verdana;'>");
            out.println("<center>");
            out.println("<h1 style='color:#EE6600'>ContiPerf Report</h1>");
            boolean first = true;
            for (ReportModule module : this.context.getReportModules()) {
                String ref = module.getReportReference(null);
                if (ref == null) continue;
                if (!first) {
                    out.print("&nbsp;|&nbsp;");
                }
                this.appendRef(ref, module.getReportReferenceLabel(null), out);
                first = false;
            }
            if (!first) {
                out.print("&nbsp;|&nbsp;");
            }
            out.println("<a href='http://databene.org/contiperf'>Help</a>");
            out.println("<hr/>");
            out.println("<br/>");
            out.println("<table border='1' cellspacing='0' cellpadding='3px' style='border-color:#eee'>");
            out.println("\t<tr>");
            out.println("\t\t<th style='background-color:#ffffdd; color:#EE6600'>&nbsp;&nbsp;&nbsp;</th>");
            out.println("\t\t<th style='background-color:#ffffdd; color:#EE6600'>Test</th>");
            out.println("\t<tr>");
            this.appendHeader(id, counter, requirement, out);
            out.println(CPF_MARKER_1);
            out.println("</table>");
            out.println("<br/>");
            out.println("<hr/>");
            this.appendEntry(id, counter, requirement, out);
            out.println(CPF_MARKER_2);
            out.println("<hr/>");
            out.println("<div style='color:#EE6600;'>Report created by Volker Bergmann's <a href='http://databene.org'>Databene</a> <a href='http://databene.org/contiperf'>ContiPerf</a></div>");
            out.println("</center>");
            out.println("</body>");
            out.println("</html>");
            out.close();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private void extendReportFile(File reportFile, String id, LatencyCounter counter, PerformanceRequirement requirement) {
        try {
            String line;
            File tempFile = File.createTempFile("index", "html", reportFile.getParentFile());
            PrintWriter out = new PrintWriter(tempFile);
            BufferedReader in = new BufferedReader(new FileReader(reportFile));
            while (!(line = in.readLine()).contains(CPF_MARKER_1)) {
                out.println(line);
            }
            out.println(line);
            this.appendHeader(id, counter, requirement, out);
            while (!(line = in.readLine()).contains(CPF_MARKER_2)) {
                out.println(line);
            }
            this.appendEntry(id, counter, requirement, out);
            out.println(line);
            while ((line = in.readLine()) != null) {
                out.println(line);
            }
            out.close();
            in.close();
            reportFile.delete();
            tempFile.renameTo(reportFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void appendHeader(String id, LatencyCounter counter, PerformanceRequirement requirement, PrintWriter out) {
        out.println("\t<tr>");
        out.println("\t\t" + this.successCell(counter, requirement));
        out.println("\t\t<td><a href='#" + id + "'>" + id + "</td>");
        out.println("\t<tr>");
    }

    private String successCell(LatencyCounter counter, PerformanceRequirement requirement) {
        boolean success = ReportUtil.success(counter, requirement);
        return "<td style='background-color:" + (success ? "#00BB00" : "RED") + ";'>&nbsp;</td>";
    }

    private void appendEntry(String serviceId, LatencyCounter counter, PerformanceRequirement requirement, PrintWriter out) {
        out.println("<a name='" + serviceId + "'><h2 style='color:#EE6600'>" + serviceId + "</h2></a>");
        out.println("<table>");
        out.println("\t<tr>");
        out.println("\t\t<td>");
        this.renderStats(serviceId, counter, out);
        out.println("\t\t</td>");
        out.println("\t\t<td>");
        this.printStats(serviceId, counter, requirement, out);
        out.println("\t\t</td>");
        out.println("\t</tr>");
        out.println("</table>");
        out.println("<br/>");
        boolean first = true;
        for (ReportModule module : this.context.getReportModules()) {
            String ref = module.getReportReference(serviceId);
            if (ref == null) continue;
            if (!first) {
                out.print("&nbsp;|&nbsp;");
            }
            String label = module.getReportReferenceLabel(serviceId);
            this.appendRef(ref, label, out);
            first = false;
        }
        out.println("<br/><br/><br/>");
    }

    private void appendRef(String ref, String label, PrintWriter out) {
        out.print("<a href='" + ref + "'>" + label + "</a>");
    }

    private void renderStats(String id, LatencyCounter counter, PrintWriter out) {
        String chartUrl = new GoogleLatencyRenderer().render(counter, null, 320, 240);
        out.println("\t\t\t<img src='" + chartUrl + "' width='" + 320 + "', height='" + 240 + "'/>");
    }

    private void printStats(String id, LatencyCounter counter, PerformanceRequirement requirement, PrintWriter out) {
        out.println("\t\t\t<table style='font-family:sans-serif;'>");
        Date startDate = new Date(counter.getStartTime());
        out.println("\t<tr><th>Started at:</th><td colspan='2'>" + DateFormat.getDateTimeInstance().format(startDate) + "</td></tr>");
        out.println("\t<tr><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td></tr>");
        out.println("\t<tr><th>&nbsp;</th><th>Measured</th><th>Required</th></tr>");
        this.printDurationStats(counter, requirement, out);
        this.printStatLine("Total invocations:", "" + counter.sampleCount(), "", out);
        this.printThroughputStats(counter, requirement, out);
        this.printStatMsLine("Min. latency:", counter.minLatency(), null, out);
        this.printAverageStats(counter, requirement, out);
        this.printPercentileStats(counter, requirement, out);
        this.printMaxStats(counter, requirement, out);
        out.println("\t\t\t</table>");
    }

    private void printDurationStats(LatencyCounter counter, PerformanceRequirement requirement, PrintWriter out) {
        Verdict verdict = ReportUtil.totalTimeVerdict(counter, requirement);
        Long required = requirement != null && requirement.getTotalTime() > 0 ? Long.valueOf(requirement.getTotalTime()) : null;
        this.printStatMsLine("Execution time:", counter.duration(), required, verdict, out);
    }

    private void printThroughputStats(LatencyCounter counter, PerformanceRequirement requirement, PrintWriter out) {
        Verdict verdict = ReportUtil.throughputVerdict(counter, requirement);
        Long required = requirement != null && requirement.getThroughput() > 0 ? Long.valueOf(requirement.getThroughput()) : null;
        this.printStatLine("Throughput:", this.lf.format(counter.throughput()) + " / s", required != null ? this.lf.format(required) + " / s" : null, verdict, out);
    }

    private void printAverageStats(LatencyCounter counter, PerformanceRequirement requirement, PrintWriter out) {
        Verdict verdict = ReportUtil.averageVerdict(counter, requirement);
        Long required = requirement != null && requirement.getAverage() > 0 ? Long.valueOf(requirement.getAverage()) : null;
        this.printStatMsLine("Average latency:", (long)counter.averageLatency(), required, verdict, out);
    }

    private void printPercentileStats(LatencyCounter counter, PerformanceRequirement requirement, PrintWriter out) {
        if (requirement == null || requirement.getPercentileRequirements().length == 0) {
            this.printStatMsLine("Median:", counter.percentileLatency(50), null, ReportUtil.percentileVerdict(counter, 50, null), out);
            this.printStatMsLine("90%:", counter.percentileLatency(90), null, ReportUtil.percentileVerdict(counter, 90, null), out);
        } else {
            for (PercentileRequirement percentileRequirement : requirement.getPercentileRequirements()) {
                int percentage = percentileRequirement.getPercentage();
                String label = percentage == 50 ? "Median:" : percentage + "%:";
                long requiredMillis = percentileRequirement.getMillis();
                Verdict verdict = ReportUtil.percentileVerdict(counter, percentage, requiredMillis);
                this.printStatMsLine(label, counter.percentileLatency(percentage), requiredMillis, verdict, out);
            }
        }
    }

    private void printMaxStats(LatencyCounter counter, PerformanceRequirement requirement, PrintWriter out) {
        Verdict verdict = ReportUtil.maxVerdict(counter, requirement);
        Long required = requirement != null && requirement.getMax() > 0 ? Long.valueOf(requirement.getMax()) : null;
        this.printStatMsLine("Max latency:", counter.maxLatency(), required, verdict, out);
    }

    private String format(String text, Verdict verdict) {
        StringBuilder builder = new StringBuilder();
        switch (verdict) {
            case SUCCESS: {
                builder.append("<b style='color:#00BB00'>");
                break;
            }
            case FAILURE: {
                builder.append("<b style='color:RED'>");
            }
        }
        builder.append(text);
        if (verdict != Verdict.IGNORED) {
            builder.append("</b>");
        }
        return builder.toString();
    }

    private void printStatMsLine(String label, long value, Long requirement, Verdict verdict, PrintWriter out) {
        this.printStatLine(label, this.lf.format(value) + " ms", requirement != null ? this.lf.format(requirement) + " ms" : null, verdict, out);
    }

    private void printStatMsLine(String label, long value, Long requirement, PrintWriter out) {
        this.printStatLine(label, this.lf.format(value) + " ms", requirement != null ? this.lf.format(requirement) + " ms" : null, out);
    }

    private void printStatLine(String label, String value, String requirement, Verdict verdict, PrintWriter out) {
        out.println("\t\t\t\t<tr>");
        out.println("\t\t\t\t\t<th align='right' valign='top'>" + this.format(label, verdict) + "</th>");
        out.println("\t\t\t\t\t<td align='right'>" + this.format(value, verdict) + "</td>");
        out.println("\t\t\t\t\t<td align='right'>" + this.format(requirement != null ? requirement : "", verdict) + "</td>");
        out.println("\t\t\t\t</tr>");
    }

    private void printStatLine(String label, String value, String requirement, PrintWriter out) {
        out.println("\t\t\t\t<tr>");
        out.println("\t\t\t\t\t<th align='right' valign='top'>" + label + "</th>");
        out.println("\t\t\t\t\t<td align='right'>" + value + "</td>");
        out.println("\t\t\t\t\t<td align='right'>" + (requirement != null ? requirement : "") + "</td>");
        out.println("\t\t\t\t</tr>");
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

