/*
 * Decompiled with CFR 0.152.
 */
package org.databene.profile;

import java.util.List;
import org.databene.profile.Profile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Profiler {
    private static final Profiler DEFAULT_INSTANCE = new Profiler("default", 1L, "ms");
    private long granularity;
    private String unit;
    private Profile rootProfile;

    public Profiler(String name, long granularity, String unit) {
        this.granularity = granularity;
        this.unit = unit;
        this.rootProfile = new Profile(name, null);
    }

    public static Profiler defaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public Profile getRootProfile() {
        return this.rootProfile;
    }

    public void addSample(List<String> path, long duration) {
        int depth = path.size();
        Profile profile = this.rootProfile;
        for (int i = 0; i < depth; ++i) {
            profile = profile.getOrCreateSubProfile(path.get(i));
        }
        profile.addSample((int)(duration / this.granularity));
    }

    public void printSummary() {
        this.printRecursively(this.rootProfile, "");
    }

    private void printRecursively(Profile profile, String indent) {
        System.out.println(indent + profile.toString());
        for (Profile subProfile : profile.getSubProfiles()) {
            this.printRecursively(subProfile, indent + "  ");
        }
    }
}

