/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.extra.template.engine.thymeleaf;

import java.io.OutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Map;
import org.dromara.hutool.core.convert.ConvertUtil;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.reflect.TypeReference;
import org.dromara.hutool.core.util.CharsetUtil;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.extra.template.Template;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;

public class ThymeleafTemplate
implements Template,
Serializable {
    private static final long serialVersionUID = 781284916568562509L;
    private final TemplateEngine engine;
    private final String template;
    private final Charset charset;

    public static ThymeleafTemplate wrap(TemplateEngine engine, String template, Charset charset) {
        return null == engine ? null : new ThymeleafTemplate(engine, template, charset);
    }

    public ThymeleafTemplate(TemplateEngine engine, String template, Charset charset) {
        this.engine = engine;
        this.template = template;
        this.charset = (Charset)ObjUtil.defaultIfNull((Object)charset, (Object)CharsetUtil.UTF_8);
    }

    @Override
    public void render(Map<?, ?> bindingMap, Writer writer) {
        Map map = (Map)ConvertUtil.convert((TypeReference)new TypeReference<Map<String, Object>>(){}, bindingMap);
        Context context = new Context(Locale.getDefault(), map);
        this.engine.process(this.template, (IContext)context, writer);
    }

    @Override
    public void render(Map<?, ?> bindingMap, OutputStream out) {
        this.render(bindingMap, IoUtil.toWriter((OutputStream)out, (Charset)this.charset));
    }
}

