/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.streamquery.stream.plugin.mybatisplus.engine.configuration;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.dromara.streamquery.stream.core.lambda.function.SerPred;
import org.dromara.streamquery.stream.core.reflect.ReflectHelper;
import org.dromara.streamquery.stream.core.stream.Steam;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.CollectionUtils;

public class StreamClassPathScanner
extends ClassPathScanningCandidateComponentProvider {
    private static final Log LOG = LogFactory.getLog(StreamClassPathScanner.class);
    private Class<? extends Annotation> annotation;
    private Class<?> interfaceClass;

    public StreamClassPathScanner(boolean useDefaultFilters) {
        super(useDefaultFilters);
    }

    public void setAnnotation(Class<? extends Annotation> annotation) {
        this.annotation = annotation;
    }

    public void setInterfaceClass(Class<?> interfaceClass) {
        this.interfaceClass = interfaceClass;
    }

    public void registerFilters() {
        boolean acceptAllInterfaces = true;
        if (this.annotation != null) {
            this.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(this.annotation));
            acceptAllInterfaces = false;
        }
        if (this.interfaceClass != null) {
            this.addIncludeFilter((TypeFilter)new AssignableTypeFilter(this.interfaceClass){

                protected boolean matchClassName(String className) {
                    return false;
                }
            });
            acceptAllInterfaces = false;
        }
        if (acceptAllInterfaces) {
            this.addIncludeFilter((metadataReader, metadataReaderFactory) -> true);
        }
        this.addExcludeFilter((metadataReader, metadataReaderFactory) -> {
            ClassMetadata classMetadata = metadataReader.getClassMetadata();
            return classMetadata.getClassName().endsWith("package-info") || classMetadata.isInterface() || classMetadata.isAbstract();
        });
    }

    public Set<Class<?>> scan(Set<String> basePackages) {
        if (CollectionUtils.isEmpty(basePackages)) {
            LOG.warn("basePackages is empty");
            return Collections.emptySet();
        }
        return Steam.of(basePackages).flat(arg_0 -> ((StreamClassPathScanner)this).findCandidateComponents(arg_0)).map(BeanDefinition::getBeanClassName).nonNull().map(ReflectHelper::forClassName).filter((Predicate)SerPred.multiOr((SerPred[])new SerPred[]{Class::isMemberClass, Class::isAnonymousClass, Class::isLocalClass}).negate()).toSet();
    }
}

