/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.Policy;
import java.text.CollationKey;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.eclipse.jetty.start.Classpath;
import org.eclipse.jetty.start.FilenameComparator;
import org.eclipse.jetty.start.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Config {
    public static final String DEFAULT_SECTION = "";
    private final Comparator<String> keySorter = new Comparator<String>(){
        private final Collator collator = Collator.getInstance();

        @Override
        public int compare(String o1, String o2) {
            CollationKey key1 = this.collator.getCollationKey(o1);
            CollationKey key2 = this.collator.getCollationKey(o2);
            return key1.compareTo(key2);
        }
    };
    private static final String _version;
    private static boolean DEBUG;
    private static final Map<String, String> __properties;
    private final Map<String, Classpath> _classpaths = new HashMap<String, Classpath>();
    private final List<String> _xml = new ArrayList<String>();
    private final Set<String> _policies = new HashSet<String>();
    private String _classname = null;
    private int argCount = 0;
    private final Set<String> _activeOptions = new TreeSet<String>(new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            if ("*".equals(o1)) {
                return 1;
            }
            if ("*".equals(o2)) {
                return -1;
            }
            return o1.compareTo(o2);
        }
    });

    private boolean addClasspathComponent(List<String> sections, String component) {
        for (String section : sections) {
            Classpath cp = this._classpaths.get(section);
            if (cp == null) {
                cp = new Classpath();
            }
            boolean added = cp.addComponent(component);
            this._classpaths.put(section, cp);
            if (added) continue;
            return false;
        }
        return true;
    }

    private boolean addClasspathPath(List<String> sections, String path) {
        for (String section : sections) {
            Classpath cp = this._classpaths.get(section);
            if (cp == null) {
                cp = new Classpath();
            }
            if (!cp.addClasspath(path)) {
                return false;
            }
            this._classpaths.put(section, cp);
        }
        return true;
    }

    private void addJars(List<String> sections, File dir, boolean recurse) throws IOException {
        ArrayList<File> entries = new ArrayList<File>();
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        entries.addAll(Arrays.asList(files));
        Collections.sort(entries, FilenameComparator.INSTANCE);
        for (File entry : entries) {
            if (entry.isDirectory()) {
                if (!recurse) continue;
                this.addJars(sections, entry, recurse);
                continue;
            }
            String name = entry.getName().toLowerCase();
            if (!name.endsWith(".jar") && !name.endsWith(".zip")) continue;
            String jar = entry.getCanonicalPath();
            boolean added = this.addClasspathComponent(sections, jar);
            Config.debug((added ? "  CLASSPATH+=" : "  !") + jar);
        }
    }

    private void close(InputStream stream) {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void close(Reader reader) {
        if (reader == null) {
            return;
        }
        try {
            reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean isDebug() {
        return DEBUG;
    }

    public static void debug(String msg) {
        if (DEBUG) {
            System.err.println(msg);
        }
    }

    public static void debug(Throwable t) {
        if (DEBUG) {
            t.printStackTrace(System.err);
        }
    }

    private String expand(String s) {
        String property;
        String name;
        int i1 = 0;
        int i2 = 0;
        while (s != null && (i1 = s.indexOf("$(", i2)) >= 0 && (i2 = s.indexOf(")", i1 + 2)) >= 0) {
            name = s.substring(i1 + 2, i2);
            property = this.getSystemProperty(name);
            s = s.substring(0, i1) + property + s.substring(i2 + 1);
        }
        i1 = 0;
        i2 = 0;
        while (s != null && (i1 = s.indexOf("${", i2)) >= 0 && (i2 = s.indexOf("}", i1 + 2)) >= 0) {
            name = s.substring(i1 + 2, i2);
            property = Config.getProperty(name);
            s = s.substring(0, i1) + property + s.substring(i2 + 1);
        }
        return s;
    }

    public Classpath getClasspath() {
        return this._classpaths.get(DEFAULT_SECTION);
    }

    public Classpath getActiveClasspath() {
        return this.getCombinedClasspath(this._activeOptions);
    }

    public Classpath getCombinedClasspath(Collection<String> optionIds) {
        Classpath cp = new Classpath();
        cp.overlay(this._classpaths.get(DEFAULT_SECTION));
        for (String optionId : optionIds) {
            Classpath otherCp = this._classpaths.get(optionId);
            if (otherCp == null) {
                throw new IllegalArgumentException("No such OPTIONS: " + optionId);
            }
            cp.overlay(otherCp);
        }
        cp.overlay(this._classpaths.get("*"));
        return cp;
    }

    public String getMainClassname() {
        return this._classname;
    }

    public static void clearProperties() {
        __properties.clear();
    }

    public static Properties getProperties() {
        Properties properties = new Properties();
        for (String key : __properties.keySet()) {
            properties.put(key, __properties.get(key));
        }
        return properties;
    }

    public static String getProperty(String name) {
        if ("version".equalsIgnoreCase(name)) {
            return _version;
        }
        return __properties.get(name);
    }

    public static String getProperty(String name, String dftValue) {
        if (__properties.containsKey(name)) {
            return __properties.get(name);
        }
        return dftValue;
    }

    public Classpath getSectionClasspath(String sectionId) {
        return this._classpaths.get(sectionId);
    }

    public Set<String> getSectionIds() {
        TreeSet<String> ids = new TreeSet<String>(this.keySorter);
        ids.addAll(this._classpaths.keySet());
        return ids;
    }

    private String getSystemProperty(String name) {
        if ("version".equalsIgnoreCase(name)) {
            return _version;
        }
        if (__properties.containsKey(name)) {
            return __properties.get(name);
        }
        return System.getProperty(name);
    }

    public List<String> getXmlConfigs() {
        return this._xml;
    }

    private boolean isAvailable(List<String> options, String classname) {
        try {
            Class.forName(classname);
            return true;
        }
        catch (NoClassDefFoundError e) {
            Config.debug(e);
        }
        catch (ClassNotFoundException e) {
            Config.debug("ClassNotFoundException (parent class loader): " + classname);
        }
        for (String optionId : options) {
            Classpath classpath = this._classpaths.get(optionId);
            if (classpath == null) continue;
            ClassLoader loader = classpath.getClassLoader();
            try {
                loader.loadClass(classname);
                return true;
            }
            catch (NoClassDefFoundError e) {
                Config.debug(e);
            }
            catch (ClassNotFoundException e) {
                Config.debug("ClassNotFoundException (section class loader: " + optionId + "): " + classname);
            }
        }
        return false;
    }

    public void parse(CharSequence buf) throws IOException {
        this.parse(new StringReader(((Object)buf).toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputStream stream) throws IOException {
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(stream);
            this.parse(reader);
        }
        finally {
            this.close(reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     */
    public void parse(Reader reader) throws IOException {
        BufferedReader buf = null;
        try {
            buf = new BufferedReader(reader);
            List<Object> options = new ArrayList<String>();
            options.add(DEFAULT_SECTION);
            this._classpaths.put(DEFAULT_SECTION, new Classpath());
            Version java_version = new Version(System.getProperty("java.version"));
            Version ver = new Version();
            String line = null;
            while ((line = buf.readLine()) != null) {
                String trim = line.trim();
                if (trim.length() == 0 || trim.startsWith("#")) continue;
                if (trim.startsWith("[") && trim.endsWith("]")) {
                    String identifier = trim.substring(1, trim.length() - 1);
                    options = Arrays.asList(identifier.split(","));
                    List<String> option_ids = new ArrayList<String>();
                    for (String optionId : options) {
                        if (optionId.charAt(0) == '=') continue;
                        if (!this._classpaths.containsKey(optionId)) {
                            this._classpaths.put(optionId, new Classpath());
                        }
                        if (option_ids.contains(optionId)) continue;
                        option_ids.add(optionId);
                    }
                    for (String optionId : options) {
                        if (optionId.charAt(0) != '=') continue;
                        option_ids = this.processDynamicSectionIdentifier(optionId.substring(1), option_ids);
                    }
                    options = option_ids;
                    continue;
                }
                try {
                    String cn;
                    File f;
                    String d;
                    File dir;
                    String property;
                    StringTokenizer st = new StringTokenizer(line);
                    String subject = st.nextToken();
                    boolean expression = true;
                    boolean not = false;
                    String condition = null;
                    while (st.hasMoreTokens()) {
                        String operator;
                        String property2;
                        condition = st.nextToken();
                        if (condition.equalsIgnoreCase("!")) {
                            not = true;
                            continue;
                        }
                        if (condition.equalsIgnoreCase("OR")) {
                            if (expression) break;
                            expression = true;
                            continue;
                        }
                        if (condition.equalsIgnoreCase("AND")) {
                            if (expression) continue;
                            break;
                        }
                        boolean eval = true;
                        if (condition.equals("true") || condition.equals("always")) {
                            eval = true;
                        } else if (condition.equals("false") || condition.equals("never")) {
                            eval = false;
                        } else if (condition.equals("available")) {
                            String class_to_check = st.nextToken();
                            eval = this.isAvailable(options, class_to_check);
                        } else if (condition.equals("exists")) {
                            try {
                                eval = false;
                                File file = new File(this.expand(st.nextToken()));
                                eval = file.exists();
                            }
                            catch (Exception e) {
                                Config.debug(e);
                            }
                        } else if (condition.equals("property")) {
                            property2 = Config.getProperty(st.nextToken());
                            eval = property2 != null && property2.length() > 0;
                        } else if (condition.equals("system")) {
                            property2 = System.getProperty(st.nextToken());
                            eval = property2 != null && property2.length() > 0;
                        } else if (condition.equals("java")) {
                            operator = st.nextToken();
                            String version = st.nextToken();
                            ver.parse(version);
                            eval = operator.equals("<") && java_version.compare(ver) < 0 || operator.equals(">") && java_version.compare(ver) > 0 || operator.equals("<=") && java_version.compare(ver) <= 0 || operator.equals("=<") && java_version.compare(ver) <= 0 || operator.equals("=>") && java_version.compare(ver) >= 0 || operator.equals(">=") && java_version.compare(ver) >= 0 || operator.equals("==") && java_version.compare(ver) == 0 || operator.equals("!=") && java_version.compare(ver) != 0;
                        } else if (condition.equals("nargs")) {
                            operator = st.nextToken();
                            int number = Integer.parseInt(st.nextToken());
                            eval = operator.equals("<") && this.argCount < number || operator.equals(">") && this.argCount > number || operator.equals("<=") && this.argCount <= number || operator.equals("=<") && this.argCount <= number || operator.equals("=>") && this.argCount >= number || operator.equals(">=") && this.argCount >= number || operator.equals("==") && this.argCount == number || operator.equals("!=") && this.argCount != number;
                        } else {
                            System.err.println("ERROR: Unknown condition: " + condition);
                            eval = false;
                        }
                        expression &= not ? !eval : eval;
                        not = false;
                    }
                    String file = this.expand(subject);
                    Config.debug((expression ? "T " : "F ") + line);
                    if (!expression) continue;
                    if (subject.indexOf("~=") > 0) {
                        int i = file.indexOf("~=");
                        property = file.substring(0, i);
                        String value = this.fixPath(file.substring(i + 2));
                        Config.debug("  " + property + "~=" + value);
                        this.setProperty(property, value);
                        continue;
                    }
                    if (subject.indexOf("/=") > 0) {
                        int i = file.indexOf("/=");
                        property = file.substring(0, i);
                        String value = this.fixPath(file.substring(i + 2));
                        String canonical = new File(value).getCanonicalPath();
                        Config.debug("  " + property + "/=" + value + "==" + canonical);
                        this.setProperty(property, canonical);
                        continue;
                    }
                    if (subject.indexOf("=") > 0) {
                        int i = file.indexOf("=");
                        property = file.substring(0, i);
                        String value = this.fixPath(file.substring(i + 1));
                        Config.debug("  " + property + "=" + value);
                        System.setProperty(property, value);
                        continue;
                    }
                    if (subject.endsWith("/*")) {
                        dir = new File(this.fixPath(file.substring(0, file.length() - 1)));
                        this.addJars(options, dir, false);
                        continue;
                    }
                    if (subject.endsWith("/**")) {
                        dir = new File(this.fixPath(file.substring(0, file.length() - 2)));
                        this.addJars(options, dir, true);
                        continue;
                    }
                    if (subject.endsWith("/")) {
                        File cd = new File(this.fixPath(file));
                        d = cd.getCanonicalPath();
                        boolean added = this.addClasspathComponent(options, d);
                        Config.debug((added ? "  CLASSPATH+=" : "  !") + d);
                        continue;
                    }
                    if (subject.toLowerCase().endsWith(".xml")) {
                        f = new File(this.fixPath(file));
                        if (f.exists()) {
                            this._xml.add(f.getCanonicalPath());
                        }
                        Config.debug("  ARGS+=" + f);
                        continue;
                    }
                    if (subject.toLowerCase().endsWith(".class")) {
                        cn = this.expand(subject.substring(0, subject.length() - 6));
                        if (cn == null || cn.length() <= 0) continue;
                        Config.debug("  CLASS=" + cn);
                        this._classname = cn;
                        continue;
                    }
                    if (subject.toLowerCase().endsWith(".path")) {
                        cn = this.expand(subject.substring(0, subject.length() - 5));
                        if (cn == null || cn.length() <= 0) continue;
                        Config.debug("  PATH=" + cn);
                        this.addClasspathPath(options, cn);
                        continue;
                    }
                    if (subject.toLowerCase().endsWith(".policy")) {
                        cn = this.expand(subject.substring(0, subject.length()));
                        if (cn == null || cn.length() <= 0) continue;
                        Config.debug("  POLICY=" + cn);
                        this._policies.add(this.fixPath(cn));
                        continue;
                    }
                    f = new File(this.fixPath(file));
                    if (!f.exists()) continue;
                    d = f.getCanonicalPath();
                    boolean added = this.addClasspathComponent(options, d);
                    if (!added) {
                        added = this.addClasspathPath(options, this.expand(subject));
                    }
                    Config.debug((added ? "  CLASSPATH+=" : "  !") + d);
                }
                catch (Exception e) {
                    System.err.println("on line: '" + line + "'");
                    e.printStackTrace();
                }
            }
        }
        finally {
            this.close(buf);
        }
    }

    private List<String> processDynamicSectionIdentifier(String dynamicPathId, List<String> sections) throws IOException {
        String rawPath;
        boolean deep;
        if (dynamicPathId.endsWith("/*")) {
            deep = false;
            rawPath = this.fixPath(dynamicPathId.substring(0, dynamicPathId.length() - 1));
        } else if (dynamicPathId.endsWith("/**")) {
            deep = true;
            rawPath = this.fixPath(dynamicPathId.substring(0, dynamicPathId.length() - 2));
        } else {
            String msg = "Illegal dynamic path [" + dynamicPathId + "]";
            throw new IOException(msg);
        }
        File parentDir = new File(this.expand(rawPath));
        if (!parentDir.exists()) {
            return sections;
        }
        Config.debug("dynamic: " + parentDir);
        File[] dirs = parentDir.listFiles(new FileFilter(){

            public boolean accept(File path) {
                return path.isDirectory();
            }
        });
        ArrayList<String> dyn_sections = new ArrayList<String>();
        ArrayList<String> super_sections = new ArrayList<String>();
        if (sections != null) {
            super_sections.addAll(sections);
        }
        for (File dir : dirs) {
            String id = dir.getName();
            if (!this._classpaths.keySet().contains(id)) {
                this._classpaths.put(id, new Classpath());
            }
            dyn_sections.clear();
            if (sections != null) {
                dyn_sections.addAll(sections);
            }
            dyn_sections.add(id);
            super_sections.add(id);
            Config.debug("dynamic: " + dyn_sections);
            this.addJars(dyn_sections, dir, deep);
        }
        return super_sections;
    }

    private String fixPath(String path) {
        return path.replace('/', File.separatorChar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(URL url) throws IOException {
        InputStream stream = null;
        InputStreamReader reader = null;
        try {
            stream = url.openStream();
            reader = new InputStreamReader(stream);
            this.parse(reader);
            this.close(reader);
            this.close(stream);
        }
        catch (Throwable throwable) {
            this.close(reader);
            this.close(stream);
            throw throwable;
        }
    }

    public void setArgCount(int argCount) {
        this.argCount = argCount;
    }

    public void setProperty(String name, String value) {
        if (name.equals("DEBUG") && (DEBUG = Boolean.parseBoolean(value))) {
            System.setProperty("org.eclipse.jetty.util.log.stderr.DEBUG", "true");
            System.setProperty("org.eclipse.jetty.start.DEBUG", "true");
        }
        if (name.equals("OPTIONS")) {
            String[] ids;
            this._activeOptions.clear();
            for (String id : ids = value.split(",")) {
                this.addActiveOption(id);
            }
        }
        __properties.put(name, value);
    }

    public Policy getPolicyInstance(ClassLoader cl) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> jettyPolicy = cl.loadClass("org.eclipse.jetty.policy.JettyPolicy");
        Constructor<?> c = jettyPolicy.getConstructor(Set.class, Map.class);
        Object policyClass = c.newInstance(this._policies, __properties);
        if (policyClass instanceof Policy) {
            Policy p = (Policy)policyClass;
            p.refresh();
            return (Policy)policyClass;
        }
        throw new ClassCastException("Unable to cast to " + Policy.class.getName() + " : " + policyClass.getClass().getName());
    }

    public void addActiveOption(String option) {
        this._activeOptions.add(option);
        __properties.put("OPTIONS", this.join(this._activeOptions, ","));
    }

    public Set<String> getActiveOptions() {
        return this._activeOptions;
    }

    public void removeActiveOption(String option) {
        this._activeOptions.remove(option);
        __properties.put("OPTIONS", this.join(this._activeOptions, ","));
    }

    private String join(Collection<?> coll, String delim) {
        StringBuffer buf = new StringBuffer();
        Iterator<?> i = coll.iterator();
        boolean hasNext = i.hasNext();
        while (hasNext) {
            buf.append(String.valueOf(i.next()));
            hasNext = i.hasNext();
            if (!hasNext) continue;
            buf.append(delim);
        }
        return buf.toString();
    }

    static {
        Package pkg = Config.class.getPackage();
        _version = pkg != null && pkg.getImplementationVersion() != null ? pkg.getImplementationVersion() : System.getProperty("jetty.version", "Unknown");
        DEBUG = false;
        __properties = new HashMap<String, String>();
    }
}

