/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.dynamic.DynamicEntityImpl;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.CMP3Policy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jpa.JpaHelper;
import org.eclipse.persistence.jpa.rs.PersistenceContext;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.sessions.DatabaseSession;

public class IdHelper {
    private static final String SEPARATOR_STRING = "+";

    public static Object buildId(PersistenceContext app, String entityName, String idString) {
        DatabaseSession session = app.getJpaSession();
        ClassDescriptor descriptor = app.getDescriptor(entityName);
        List<DatabaseMapping> pkMappings = descriptor.getObjectBuilder().getPrimaryKeyMappings();
        ArrayList<SortableKey> pkIndices = new ArrayList<SortableKey>();
        int index = 0;
        int multitenantPKMappings = 0;
        for (DatabaseMapping mapping : pkMappings) {
            if (mapping.isMultitenantPrimaryKeyMapping()) {
                ++multitenantPKMappings;
                continue;
            }
            pkIndices.add(new SortableKey(mapping, index));
            ++index;
        }
        Collections.sort(pkIndices);
        Object[] keyElements = new Object[pkMappings.size() - multitenantPKMappings];
        StringTokenizer tokenizer = new StringTokenizer(idString, SEPARATOR_STRING);
        int tokens = tokenizer.countTokens();
        if (tokens + multitenantPKMappings != pkMappings.size()) {
            throw new RuntimeException("Failed, incorrect number of keys values");
        }
        index = 0;
        Iterator iterator = pkIndices.iterator();
        while (tokenizer.hasMoreTokens()) {
            Object idValue;
            SortableKey key = (SortableKey)iterator.next();
            String token = tokenizer.nextToken();
            DatabaseMapping mapping = key.getMapping();
            Class attributeClasification = mapping.getAttributeClassification();
            if (attributeClasification == null && mapping.getFields() != null && !mapping.getFields().isEmpty()) {
                attributeClasification = mapping.getFields().get(0).getType();
            }
            keyElements[key.getIndex()] = idValue = session.getDatasourcePlatform().getConversionManager().convertObject(token, attributeClasification);
            ++index;
        }
        if (descriptor.hasCMPPolicy()) {
            CMP3Policy policy = (CMP3Policy)descriptor.getCMPPolicy();
            return policy.createPrimaryKeyInstanceFromPrimaryKeyValues((AbstractSession)((Object)session), new int[1], keyElements);
        }
        if (keyElements.length == 1) {
            return keyElements[0];
        }
        return keyElements;
    }

    public static String stringifyId(Object entity, String typeName, PersistenceContext app) {
        ClassDescriptor descriptor = app.getDescriptor(typeName);
        List<DatabaseMapping> pkMappings = descriptor.getObjectBuilder().getPrimaryKeyMappings();
        if (pkMappings.isEmpty()) {
            return "";
        }
        ArrayList<SortableKey> pkIndices = new ArrayList<SortableKey>();
        int index = 0;
        for (DatabaseMapping mapping : pkMappings) {
            pkIndices.add(new SortableKey(mapping, index));
            ++index;
        }
        Collections.sort(pkIndices);
        StringBuffer key = new StringBuffer();
        Iterator sortableKeys = pkIndices.iterator();
        Vector<DatabaseField> refObjectdbFields = null;
        while (sortableKeys.hasNext()) {
            DatabaseMapping mapping = ((SortableKey)sortableKeys.next()).getMapping();
            ClassDescriptor refDesc = mapping.getReferenceDescriptor();
            List<DatabaseField> dbFields = mapping.getDescriptor().getPrimaryKeyFields();
            if (refDesc != null) {
                refObjectdbFields = refDesc.getFields();
            }
            if (refObjectdbFields != null && !refObjectdbFields.isEmpty()) {
                for (DatabaseField dbField : dbFields) {
                    String dbFieldName = dbField.getName();
                    String refObjectDbFieldName = null;
                    if (refDesc == null) continue;
                    for (DatabaseField refObjectDbField : refObjectdbFields) {
                        refObjectDbFieldName = refObjectDbField.getName();
                        if (refObjectDbFieldName == null || dbFieldName == null || !dbFieldName.equals(refObjectDbFieldName)) continue;
                        Vector<DatabaseMapping> refMappings = refDesc.getMappings();
                        for (DatabaseMapping refMapping : refMappings) {
                            DatabaseField field = refMapping.getField();
                            if (field == null) continue;
                            String fieldName = field.getName();
                            if (!(mapping instanceof OneToOneMapping)) continue;
                            Map<DatabaseField, DatabaseField> targetToSourceKeyFields = ((OneToOneMapping)mapping).getTargetToSourceKeyFields();
                            Map<DatabaseField, DatabaseField> sourceToTargetFields = ((OneToOneMapping)mapping).getTargetToSourceKeyFields();
                            if (targetToSourceKeyFields == null || targetToSourceKeyFields.isEmpty() || !targetToSourceKeyFields.containsKey(refObjectDbField) || sourceToTargetFields == null || sourceToTargetFields.isEmpty() || !sourceToTargetFields.containsKey(field) || fieldName == null || !dbFieldName.equals(fieldName)) continue;
                            Object value = descriptor.getObjectBuilder().getBaseValueForField(dbField, entity);
                            Object realAttributeValue = refMapping.getRealAttributeValueFromAttribute(refMapping.getAttributeValueFromObject(value), value, (AbstractSession)((Object)app.getJpaSession()));
                            key.append(realAttributeValue);
                        }
                    }
                }
            } else {
                Object part = mapping.getAttributeValueFromObject(entity);
                key.append(part);
            }
            if (!sortableKeys.hasNext()) continue;
            key.append(SEPARATOR_STRING);
            refObjectdbFields = null;
        }
        return key.toString();
    }

    public static Object buildObjectShell(PersistenceContext context, String entityType, Object id) {
        ClassDescriptor descriptor = context.getDescriptor(entityType);
        List<DatabaseMapping> pkMappings = descriptor.getObjectBuilder().getPrimaryKeyMappings();
        Object entity = null;
        if (descriptor.hasCMPPolicy()) {
            CMP3Policy policy = (CMP3Policy)descriptor.getCMPPolicy();
            entity = policy.createBeanUsingKey(id, (AbstractSession)((Object)context.getJpaSession()));
        } else if (entity instanceof DynamicEntity) {
            DynamicEntityImpl dynamicEntity = (DynamicEntityImpl)context.newEntity(entityType);
            if (pkMappings.size() == 1) {
                dynamicEntity.set(pkMappings.get(0).getAttributeName(), id);
            } else {
                ArrayList<SortableKey> pkIndices = new ArrayList<SortableKey>();
                int index = 0;
                for (DatabaseMapping mapping : pkMappings) {
                    pkIndices.add(new SortableKey(mapping, index));
                    ++index;
                }
                Collections.sort(pkIndices);
                Object[] keyElements = (Object[])id;
                for (SortableKey key : pkIndices) {
                    dynamicEntity.set(key.getMapping().getAttributeName(), keyElements[key.getIndex()]);
                }
            }
            entity = dynamicEntity;
        } else {
            throw new RuntimeException("Could not create shell for entity.");
        }
        if (entity instanceof PersistenceEntity) {
            ((PersistenceEntity)entity)._persistence_setId(id);
        }
        if (entity instanceof FetchGroupTracker) {
            ((FetchGroupTracker)entity)._persistence_setSession(JpaHelper.getDatabaseSession(context.getEmf()));
        }
        return entity;
    }

    private static class SortableKey
    implements Comparable<SortableKey> {
        private DatabaseMapping mapping;
        private int index;

        public SortableKey(DatabaseMapping mapping, int index) {
            this.mapping = mapping;
            this.index = index;
        }

        @Override
        public int compareTo(SortableKey o) {
            return this.mapping.getAttributeName().compareTo(o.getMapping().getAttributeName());
        }

        public DatabaseMapping getMapping() {
            return this.mapping;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

