/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.versions.manipulation;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.tycho.model.FeatureRef;
import org.eclipse.tycho.model.UpdateSite;
import org.eclipse.tycho.versions.engine.MetadataManipulator;
import org.eclipse.tycho.versions.engine.ProjectMetadata;
import org.eclipse.tycho.versions.engine.VersionChange;
import org.eclipse.tycho.versions.manipulation.AbstractMetadataManipulator;
import org.eclipse.tycho.versions.pom.MutablePomFile;

@Component(role=MetadataManipulator.class, hint="eclipse-update-site")
public class SiteXmlManipulator
extends AbstractMetadataManipulator {
    @Override
    public void applyChange(ProjectMetadata project, VersionChange change, Set<VersionChange> allChanges) {
        if (this.isSite(project) && this.isFeature(change.getProject().getPackaging())) {
            UpdateSite site = this.getSiteXml(project);
            for (FeatureRef feature : site.getFeatures()) {
                if (!change.getArtifactId().equals(feature.getId()) || !change.getVersion().equals(feature.getVersion())) continue;
                this.logger.info("  site.xml//site/feature/@id=" + feature.getId() + "/@version: " + change.getVersion() + " => " + change.getNewVersion());
                feature.setVersion(change.getNewVersion());
                UpdateSite.SiteFeatureRef siteFeature = (UpdateSite.SiteFeatureRef)feature;
                String oldUrl = siteFeature.getUrl();
                String newUrl = SiteXmlManipulator.rewriteFeatureUrl(oldUrl, change);
                this.logger.info("  site.xml//site/feature/@id=" + feature.getId() + "/@url: " + oldUrl + " => " + newUrl);
                siteFeature.setUrl(newUrl);
            }
        }
    }

    static String rewriteFeatureUrl(String url, VersionChange change) {
        if (url != null) {
            return url.replaceAll("\\Q" + change.getVersion() + "\\E", change.getNewVersion());
        }
        return null;
    }

    private UpdateSite getSiteXml(ProjectMetadata project) {
        UpdateSite site = project.getMetadata(UpdateSite.class);
        if (site == null) {
            File file = new File(project.getBasedir(), "site.xml");
            try {
                site = UpdateSite.read((File)file);
                project.putMetadata(site);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not read update site " + file, e);
            }
        }
        return site;
    }

    private boolean isSite(ProjectMetadata project) {
        MutablePomFile pom = project.getMetadata(MutablePomFile.class);
        return this.isSite(pom.getPackaging());
    }

    private boolean isSite(String packaging) {
        return "eclipse-update-site".equals(packaging);
    }

    @Override
    public void writeMetadata(ProjectMetadata project) throws IOException {
        File basedir = project.getBasedir();
        UpdateSite site = project.getMetadata(UpdateSite.class);
        if (site != null) {
            UpdateSite.write((UpdateSite)site, (File)new File(basedir, "site.xml"));
        }
    }

    @Override
    public Collection<String> validateChange(ProjectMetadata project, VersionChange change) {
        return null;
    }
}

