/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client;

import java.io.IOException;
import java.util.Collections;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.WatcherRequestConverters;
import org.elasticsearch.client.watcher.AckWatchRequest;
import org.elasticsearch.client.watcher.AckWatchResponse;
import org.elasticsearch.client.watcher.ActivateWatchRequest;
import org.elasticsearch.client.watcher.ActivateWatchResponse;
import org.elasticsearch.client.watcher.StartWatchServiceRequest;
import org.elasticsearch.client.watcher.StopWatchServiceRequest;
import org.elasticsearch.protocol.xpack.watcher.DeleteWatchRequest;
import org.elasticsearch.protocol.xpack.watcher.DeleteWatchResponse;
import org.elasticsearch.protocol.xpack.watcher.PutWatchRequest;
import org.elasticsearch.protocol.xpack.watcher.PutWatchResponse;

public final class WatcherClient {
    private final RestHighLevelClient restHighLevelClient;

    WatcherClient(RestHighLevelClient restHighLevelClient) {
        this.restHighLevelClient = restHighLevelClient;
    }

    public AcknowledgedResponse startWatchService(StartWatchServiceRequest request, RequestOptions options) throws IOException {
        return (AcknowledgedResponse)this.restHighLevelClient.performRequestAndParseEntity(request, WatcherRequestConverters::startWatchService, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public void startWatchServiceAsync(StartWatchServiceRequest request, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, WatcherRequestConverters::startWatchService, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }

    public AcknowledgedResponse stopWatchService(StopWatchServiceRequest request, RequestOptions options) throws IOException {
        return (AcknowledgedResponse)this.restHighLevelClient.performRequestAndParseEntity(request, WatcherRequestConverters::stopWatchService, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public void stopWatchServiceAsync(StopWatchServiceRequest request, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, WatcherRequestConverters::stopWatchService, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }

    public PutWatchResponse putWatch(PutWatchRequest request, RequestOptions options) throws IOException {
        return (PutWatchResponse)((Object)this.restHighLevelClient.performRequestAndParseEntity(request, WatcherRequestConverters::putWatch, options, PutWatchResponse::fromXContent, Collections.emptySet()));
    }

    public void putWatchAsync(PutWatchRequest request, RequestOptions options, ActionListener<PutWatchResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, WatcherRequestConverters::putWatch, options, PutWatchResponse::fromXContent, listener, Collections.emptySet());
    }

    public DeleteWatchResponse deleteWatch(DeleteWatchRequest request, RequestOptions options) throws IOException {
        return (DeleteWatchResponse)((Object)this.restHighLevelClient.performRequestAndParseEntity(request, WatcherRequestConverters::deleteWatch, options, DeleteWatchResponse::fromXContent, Collections.singleton(404)));
    }

    public void deleteWatchAsync(DeleteWatchRequest request, RequestOptions options, ActionListener<DeleteWatchResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, WatcherRequestConverters::deleteWatch, options, DeleteWatchResponse::fromXContent, listener, Collections.singleton(404));
    }

    public AckWatchResponse ackWatch(AckWatchRequest request, RequestOptions options) throws IOException {
        return (AckWatchResponse)this.restHighLevelClient.performRequestAndParseEntity(request, WatcherRequestConverters::ackWatch, options, AckWatchResponse::fromXContent, Collections.emptySet());
    }

    public void ackWatchAsync(AckWatchRequest request, RequestOptions options, ActionListener<AckWatchResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, WatcherRequestConverters::ackWatch, options, AckWatchResponse::fromXContent, listener, Collections.emptySet());
    }

    public ActivateWatchResponse activateWatch(ActivateWatchRequest request, RequestOptions options) throws IOException {
        return (ActivateWatchResponse)this.restHighLevelClient.performRequestAndParseEntity(request, WatcherRequestConverters::activateWatch, options, ActivateWatchResponse::fromXContent, Collections.singleton(404));
    }

    public void activateWatchAsync(ActivateWatchRequest request, RequestOptions options, ActionListener<ActivateWatchResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, WatcherRequestConverters::activateWatch, options, ActivateWatchResponse::fromXContent, listener, Collections.singleton(404));
    }
}

