/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.dataframe.transforms;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.client.dataframe.transforms.DestConfig;
import org.elasticsearch.client.dataframe.transforms.SourceConfig;
import org.elasticsearch.client.dataframe.transforms.pivot.PivotConfig;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class DataFrameTransformConfig
implements ToXContentObject {
    public static final ParseField ID = new ParseField("id", new String[0]);
    public static final ParseField SOURCE = new ParseField("source", new String[0]);
    public static final ParseField DEST = new ParseField("dest", new String[0]);
    public static final ParseField DESCRIPTION = new ParseField("description", new String[0]);
    public static final ParseField PIVOT_TRANSFORM = new ParseField("pivot", new String[0]);
    private final String id;
    private final SourceConfig source;
    private final DestConfig dest;
    private final PivotConfig pivotConfig;
    private final String description;
    public static final ConstructingObjectParser<DataFrameTransformConfig, Void> PARSER = new ConstructingObjectParser("data_frame_transform", true, args -> {
        String id = (String)args[0];
        SourceConfig source = (SourceConfig)args[1];
        DestConfig dest = (DestConfig)args[2];
        PivotConfig pivotConfig = (PivotConfig)args[3];
        String description = (String)args[4];
        return new DataFrameTransformConfig(id, source, dest, pivotConfig, description);
    });

    public static DataFrameTransformConfig fromXContent(XContentParser parser) {
        return (DataFrameTransformConfig)PARSER.apply(parser, null);
    }

    public static DataFrameTransformConfig forPreview(SourceConfig source, PivotConfig pivotConfig) {
        return new DataFrameTransformConfig(null, source, null, pivotConfig, null);
    }

    DataFrameTransformConfig(String id, SourceConfig source, DestConfig dest, PivotConfig pivotConfig, String description) {
        this.id = id;
        this.source = source;
        this.dest = dest;
        this.pivotConfig = pivotConfig;
        this.description = description;
    }

    public String getId() {
        return this.id;
    }

    public SourceConfig getSource() {
        return this.source;
    }

    public DestConfig getDestination() {
        return this.dest;
    }

    public PivotConfig getPivotConfig() {
        return this.pivotConfig;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.id != null) {
            builder.field(ID.getPreferredName(), this.id);
        }
        if (this.source != null) {
            builder.field(SOURCE.getPreferredName(), (ToXContent)this.source);
        }
        if (this.dest != null) {
            builder.field(DEST.getPreferredName(), (ToXContent)this.dest);
        }
        if (this.pivotConfig != null) {
            builder.field(PIVOT_TRANSFORM.getPreferredName(), (ToXContent)this.pivotConfig);
        }
        if (this.description != null) {
            builder.field(DESCRIPTION.getPreferredName(), this.description);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DataFrameTransformConfig that = (DataFrameTransformConfig)other;
        return Objects.equals(this.id, that.id) && Objects.equals(this.source, that.source) && Objects.equals(this.dest, that.dest) && Objects.equals(this.description, that.description) && Objects.equals(this.pivotConfig, that.pivotConfig);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.source, this.dest, this.pivotConfig, this.description);
    }

    public String toString() {
        return Strings.toString((ToXContent)this, (boolean)true, (boolean)true);
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), ID);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> (SourceConfig)SourceConfig.PARSER.apply(p, null), SOURCE);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> (DestConfig)DestConfig.PARSER.apply(p, null), DEST);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> PivotConfig.fromXContent(p), PIVOT_TRANSFORM);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), DESCRIPTION);
    }

    public static class Builder {
        private String id;
        private SourceConfig source;
        private DestConfig dest;
        private PivotConfig pivotConfig;
        private String description;

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setSource(SourceConfig source) {
            this.source = source;
            return this;
        }

        public Builder setDest(DestConfig dest) {
            this.dest = dest;
            return this;
        }

        public Builder setPivotConfig(PivotConfig pivotConfig) {
            this.pivotConfig = pivotConfig;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public DataFrameTransformConfig build() {
            return new DataFrameTransformConfig(this.id, this.source, this.dest, this.pivotConfig, this.description);
        }
    }
}

