/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.client.Validatable;
import org.elasticsearch.client.ml.datafeed.DatafeedConfig;
import org.elasticsearch.client.ml.job.config.Job;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.core.Nullable;

public class PreviewDatafeedRequest
implements Validatable,
ToXContentObject {
    private static final ParseField DATAFEED_CONFIG = new ParseField("datafeed_config", new String[0]);
    private static final ParseField JOB_CONFIG = new ParseField("job_config", new String[0]);
    public static final ConstructingObjectParser<PreviewDatafeedRequest, Void> PARSER = new ConstructingObjectParser("preview_datafeed_request", a -> new PreviewDatafeedRequest((String)a[0], (DatafeedConfig.Builder)a[1], (Job.Builder)a[2]));
    private final String datafeedId;
    private final DatafeedConfig datafeedConfig;
    private final Job jobConfig;

    public static PreviewDatafeedRequest fromXContent(XContentParser parser) throws IOException {
        return (PreviewDatafeedRequest)PARSER.parse(parser, null);
    }

    private PreviewDatafeedRequest(@Nullable String datafeedId, @Nullable DatafeedConfig.Builder datafeedConfig, @Nullable Job.Builder jobConfig) {
        this.datafeedId = datafeedId;
        this.datafeedConfig = datafeedConfig == null ? null : datafeedConfig.build();
        this.jobConfig = jobConfig == null ? null : jobConfig.build();
    }

    public PreviewDatafeedRequest(String datafeedId) {
        this.datafeedId = Objects.requireNonNull(datafeedId, "[datafeed_id] must not be null");
        this.datafeedConfig = null;
        this.jobConfig = null;
    }

    public PreviewDatafeedRequest(DatafeedConfig datafeedConfig, Job jobConfig) {
        this.datafeedId = null;
        this.datafeedConfig = datafeedConfig;
        this.jobConfig = jobConfig;
    }

    public String getDatafeedId() {
        return this.datafeedId;
    }

    public DatafeedConfig getDatafeedConfig() {
        return this.datafeedConfig;
    }

    public Job getJobConfig() {
        return this.jobConfig;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.datafeedId != null) {
            builder.field(DatafeedConfig.ID.getPreferredName(), this.datafeedId);
        }
        if (this.datafeedConfig != null) {
            builder.field(DATAFEED_CONFIG.getPreferredName(), (ToXContent)this.datafeedConfig);
        }
        if (this.jobConfig != null) {
            builder.field(JOB_CONFIG.getPreferredName(), (ToXContent)this.jobConfig);
        }
        builder.endObject();
        return builder;
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public int hashCode() {
        return Objects.hash(this.datafeedId, this.datafeedConfig, this.jobConfig);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        PreviewDatafeedRequest that = (PreviewDatafeedRequest)other;
        return Objects.equals(this.datafeedId, that.datafeedId) && Objects.equals(this.datafeedConfig, that.datafeedConfig) && Objects.equals(this.jobConfig, that.jobConfig);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), DatafeedConfig.ID);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), DatafeedConfig.PARSER, DATAFEED_CONFIG);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), Job.PARSER, JOB_CONFIG);
    }
}

