/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.mustache;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.script.mustache.SearchTemplateAction;
import org.elasticsearch.script.mustache.SearchTemplateRequest;

public class RestRenderSearchTemplateAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_render/template"), new RestHandler.Route(RestRequest.Method.POST, "/_render/template"), new RestHandler.Route(RestRequest.Method.GET, "/_render/template/{id}"), new RestHandler.Route(RestRequest.Method.POST, "/_render/template/{id}"));
    }

    public String getName() {
        return "render_search_template_action";
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        SearchTemplateRequest renderRequest;
        try (XContentParser parser = request.contentOrSourceParamParser();){
            renderRequest = SearchTemplateRequest.fromXContent(parser);
        }
        renderRequest.setSimulate(true);
        String id = request.param("id");
        if (id != null) {
            renderRequest.setScriptType(ScriptType.STORED);
            renderRequest.setScript(id);
        }
        return channel -> client.execute((ActionType)SearchTemplateAction.INSTANCE, (ActionRequest)renderRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

