/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.rankeval;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.rankeval.EvalQueryQuality;

public class RankEvalResponse
extends ActionResponse
implements ToXContentObject {
    private double evaluationResult;
    private Map<String, EvalQueryQuality> details;
    private Map<String, Exception> failures;

    public RankEvalResponse(double qualityLevel, Map<String, EvalQueryQuality> partialResults, Map<String, Exception> failures) {
        this.evaluationResult = qualityLevel;
        this.details = new HashMap<String, EvalQueryQuality>(partialResults);
        this.failures = new HashMap<String, Exception>(failures);
    }

    RankEvalResponse() {
    }

    public double getEvaluationResult() {
        return this.evaluationResult;
    }

    public Map<String, EvalQueryQuality> getPartialResults() {
        return Collections.unmodifiableMap(this.details);
    }

    public Map<String, Exception> getFailures() {
        return Collections.unmodifiableMap(this.failures);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeDouble(this.evaluationResult);
        out.writeVInt(this.details.size());
        for (String queryId : this.details.keySet()) {
            out.writeString(queryId);
            this.details.get(queryId).writeTo(out);
        }
        out.writeVInt(this.failures.size());
        for (String queryId : this.failures.keySet()) {
            out.writeString(queryId);
            out.writeException((Throwable)this.failures.get(queryId));
        }
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.evaluationResult = in.readDouble();
        int partialResultSize = in.readVInt();
        this.details = new HashMap<String, EvalQueryQuality>(partialResultSize);
        for (int i = 0; i < partialResultSize; ++i) {
            String queryId = in.readString();
            EvalQueryQuality partial = new EvalQueryQuality(in);
            this.details.put(queryId, partial);
        }
        int failuresSize = in.readVInt();
        this.failures = new HashMap<String, Exception>(failuresSize);
        for (int i = 0; i < failuresSize; ++i) {
            String queryId = in.readString();
            this.failures.put(queryId, in.readException());
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("quality_level", this.evaluationResult);
        builder.startObject("details");
        for (String key : this.details.keySet()) {
            this.details.get(key).toXContent(builder, params);
        }
        builder.endObject();
        builder.startObject("failures");
        for (String key : this.failures.keySet()) {
            builder.startObject(key);
            ElasticsearchException.generateFailureXContent((XContentBuilder)builder, (ToXContent.Params)params, (Exception)this.failures.get(key), (boolean)false);
            builder.endObject();
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }
}

