/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.jdbc;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.xpack.sql.jdbc.ConnectionProxy;
import org.elasticsearch.xpack.sql.jdbc.DatabaseMetadataProxy;
import org.elasticsearch.xpack.sql.jdbc.DebugLog;
import org.elasticsearch.xpack.sql.jdbc.DebugProxy;
import org.elasticsearch.xpack.sql.jdbc.JdbcConfiguration;
import org.elasticsearch.xpack.sql.jdbc.JdbcException;
import org.elasticsearch.xpack.sql.jdbc.ParameterMetaDataProxy;
import org.elasticsearch.xpack.sql.jdbc.ResultSetMetaDataProxy;
import org.elasticsearch.xpack.sql.jdbc.ResultSetProxy;
import org.elasticsearch.xpack.sql.jdbc.StatementProxy;
import shadow.org.elasticsearch.xpack.sql.client.SuppressForbidden;

final class Debug {
    private static final Map<String, DebugLog> OUTPUT_CACHE = new HashMap<String, DebugLog>();
    private static final Map<String, Integer> OUTPUT_REFS = new HashMap<String, Integer>();
    private static final Map<PrintWriter, DebugLog> OUTPUT_MANAGED = new HashMap<PrintWriter, DebugLog>();
    private static volatile DebugLog ERR = null;
    private static volatile DebugLog OUT = null;
    private static volatile PrintStream SYS_ERR = null;
    private static volatile PrintStream SYS_OUT = null;

    Debug() {
    }

    static Connection proxy(JdbcConfiguration info, Connection connection, PrintWriter managedPrinter) {
        return Debug.createProxy(Connection.class, new ConnectionProxy(Debug.logger(info, managedPrinter), connection));
    }

    static DatabaseMetaData proxy(DatabaseMetadataProxy handler) {
        return Debug.createProxy(DatabaseMetaData.class, handler);
    }

    static ParameterMetaData proxy(ParameterMetaDataProxy handler) {
        return Debug.createProxy(ParameterMetaData.class, handler);
    }

    static ResultSet proxy(ResultSetProxy handler) {
        return Debug.createProxy(ResultSet.class, handler);
    }

    static ResultSetMetaData proxy(ResultSetMetaDataProxy handler) {
        return Debug.createProxy(ResultSetMetaData.class, handler);
    }

    static Statement proxy(Object statement, StatementProxy handler) {
        Class<Statement> i = Statement.class;
        if (statement instanceof CallableStatement) {
            i = CallableStatement.class;
        } else if (statement instanceof PreparedStatement) {
            i = PreparedStatement.class;
        }
        return Debug.createProxy(i, handler);
    }

    private static <P> P createProxy(Class<P> proxy, InvocationHandler handler) {
        return (P)Proxy.newProxyInstance(Debug.class.getClassLoader(), new Class[]{DebugProxy.class, proxy}, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static DebugLog logger(JdbcConfiguration info, PrintWriter managedPrinter) {
        String out;
        DebugLog log = null;
        if (managedPrinter != null) {
            Class<Debug> clazz = Debug.class;
            // MONITORENTER : org.elasticsearch.xpack.sql.jdbc.Debug.class
            log = OUTPUT_MANAGED.get(managedPrinter);
            if (log == null) {
                log = Debug.createLog(managedPrinter, info.flushAlways());
                OUTPUT_MANAGED.put(managedPrinter, log);
            }
            // MONITOREXIT : clazz
        }
        if ("err".equals(out = info.debugOut())) {
            PrintStream sys = Debug.stderr();
            if (SYS_ERR == null) {
                SYS_ERR = sys;
            }
            if (SYS_ERR != sys) {
                SYS_ERR.flush();
                SYS_ERR = sys;
                ERR = null;
            }
            if (ERR != null) return ERR;
            ERR = Debug.createLog(new PrintWriter(new OutputStreamWriter((OutputStream)sys, StandardCharsets.UTF_8)), info.flushAlways());
            return ERR;
        }
        if ("out".equals(out)) {
            PrintStream sys = Debug.stdout();
            if (SYS_OUT == null) {
                SYS_OUT = sys;
            }
            if (SYS_OUT != sys) {
                SYS_OUT.flush();
                SYS_OUT = sys;
                OUT = null;
            }
            if (OUT != null) return OUT;
            OUT = Debug.createLog(new PrintWriter(new OutputStreamWriter((OutputStream)sys, StandardCharsets.UTF_8)), info.flushAlways());
            return OUT;
        }
        Class<Debug> clazz = Debug.class;
        // MONITORENTER : org.elasticsearch.xpack.sql.jdbc.Debug.class
        log = OUTPUT_CACHE.get(out);
        if (log == null) {
            try {
                PrintWriter print = new PrintWriter(Files.newBufferedWriter(Paths.get("", new String[0]).resolve(out), StandardCharsets.UTF_8, new OpenOption[0]));
                log = Debug.createLog(print, info.flushAlways());
                OUTPUT_CACHE.put(out, log);
                OUTPUT_REFS.put(out, 0);
            }
            catch (Exception ex) {
                throw new JdbcException(ex, "Cannot open debug output [" + out + "]");
            }
        }
        OUTPUT_REFS.put(out, OUTPUT_REFS.get(out) + 1);
        // MONITOREXIT : clazz
        return log;
    }

    private static DebugLog createLog(PrintWriter print, boolean flushAlways) {
        DebugLog log = new DebugLog(print, flushAlways);
        log.logSystemInfo();
        return log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void release(JdbcConfiguration info) {
        if (!info.debug()) {
            return;
        }
        String out = info.debugOut();
        Class<Debug> clazz = Debug.class;
        synchronized (Debug.class) {
            Integer ref = OUTPUT_REFS.get(out);
            if (ref != null) {
                int r = ref;
                if (r < 2) {
                    OUTPUT_REFS.remove(out);
                    DebugLog d = OUTPUT_CACHE.remove(out);
                    if (d != null && d.print != null) {
                        d.print.close();
                    }
                } else {
                    OUTPUT_REFS.put(out, r - 1);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    static synchronized void close() {
        OUTPUT_REFS.clear();
        for (DebugLog d : OUTPUT_CACHE.values()) {
            if (d.print == null) continue;
            d.print.close();
        }
        OUTPUT_CACHE.clear();
        for (DebugLog d : OUTPUT_MANAGED.values()) {
            d.print.flush();
        }
        OUTPUT_MANAGED.clear();
    }

    @SuppressForbidden(reason="JDBC drivers allows logging to Sys.out")
    private static PrintStream stdout() {
        return System.out;
    }

    @SuppressForbidden(reason="JDBC drivers allows logging to Sys.err")
    private static PrintStream stderr() {
        return System.err;
    }
}

