/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.jdbc;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.xpack.sql.jdbc.Cursor;
import org.elasticsearch.xpack.sql.jdbc.DefaultCursor;
import org.elasticsearch.xpack.sql.jdbc.InfoResponse;
import org.elasticsearch.xpack.sql.jdbc.JdbcColumnInfo;
import org.elasticsearch.xpack.sql.jdbc.JdbcConfiguration;
import org.elasticsearch.xpack.sql.jdbc.RequestMeta;
import org.elasticsearch.xpack.sql.jdbc.TypeUtils;
import shadow.org.elasticsearch.common.collect.Tuple;
import shadow.org.elasticsearch.common.unit.TimeValue;
import shadow.org.elasticsearch.xpack.sql.client.ClientVersion;
import shadow.org.elasticsearch.xpack.sql.client.HttpClient;
import shadow.org.elasticsearch.xpack.sql.proto.ColumnInfo;
import shadow.org.elasticsearch.xpack.sql.proto.MainResponse;
import shadow.org.elasticsearch.xpack.sql.proto.Mode;
import shadow.org.elasticsearch.xpack.sql.proto.RequestInfo;
import shadow.org.elasticsearch.xpack.sql.proto.SqlQueryRequest;
import shadow.org.elasticsearch.xpack.sql.proto.SqlQueryResponse;
import shadow.org.elasticsearch.xpack.sql.proto.SqlTypedParamValue;
import shadow.org.elasticsearch.xpack.sql.proto.SqlVersion;

class JdbcHttpClient {
    private final HttpClient httpClient;
    private final JdbcConfiguration conCfg;
    private InfoResponse serverInfo;

    JdbcHttpClient(JdbcConfiguration conCfg) throws SQLException {
        this(conCfg, true);
    }

    JdbcHttpClient(JdbcConfiguration conCfg, boolean checkServer) throws SQLException {
        this.httpClient = new HttpClient(conCfg);
        this.conCfg = conCfg;
        if (checkServer) {
            this.serverInfo = this.fetchServerInfo();
            this.checkServerVersion();
        }
    }

    boolean ping(long timeoutInMs) throws SQLException {
        return this.httpClient.ping(timeoutInMs);
    }

    Cursor query(String sql, List<SqlTypedParamValue> params, RequestMeta meta) throws SQLException {
        int fetch = meta.fetchSize() > 0 ? meta.fetchSize() : this.conCfg.pageSize();
        SqlQueryRequest sqlRequest = new SqlQueryRequest(sql, params, this.conCfg.zoneId(), fetch, TimeValue.timeValueMillis(meta.timeoutInMs()), TimeValue.timeValueMillis(meta.queryTimeoutInMs()), null, Boolean.FALSE, null, new RequestInfo(Mode.JDBC, ClientVersion.CURRENT), this.conCfg.fieldMultiValueLeniency(), this.conCfg.indexIncludeFrozen(), this.conCfg.binaryCommunication(), Collections.emptyMap());
        SqlQueryResponse response = this.httpClient.query(sqlRequest);
        return new DefaultCursor(this, response.cursor(), this.toJdbcColumnInfo(response.columns()), response.rows(), meta);
    }

    Tuple<String, List<List<Object>>> nextPage(String cursor, RequestMeta meta) throws SQLException {
        SqlQueryRequest sqlRequest = new SqlQueryRequest(cursor, TimeValue.timeValueMillis(meta.timeoutInMs()), TimeValue.timeValueMillis(meta.queryTimeoutInMs()), new RequestInfo(Mode.JDBC), this.conCfg.binaryCommunication());
        SqlQueryResponse response = this.httpClient.query(sqlRequest);
        return new Tuple<String, List<List<Object>>>(response.cursor(), response.rows());
    }

    boolean queryClose(String cursor) throws SQLException {
        return this.httpClient.queryClose(cursor, Mode.JDBC);
    }

    InfoResponse serverInfo() throws SQLException {
        if (this.serverInfo == null) {
            this.serverInfo = this.fetchServerInfo();
        }
        return this.serverInfo;
    }

    private InfoResponse fetchServerInfo() throws SQLException {
        MainResponse mainResponse = this.httpClient.serverInfo();
        SqlVersion version = SqlVersion.fromString(mainResponse.getVersion());
        return new InfoResponse(mainResponse.getClusterName(), version);
    }

    private void checkServerVersion() throws SQLException {
        if (!ClientVersion.isServerCompatible(this.serverInfo.version)) {
            throw new SQLException("This version of the JDBC driver is only compatible with Elasticsearch version " + ClientVersion.CURRENT.majorMinorToString() + " or newer; attempting to connect to a server version " + this.serverInfo.version.toString());
        }
    }

    private List<JdbcColumnInfo> toJdbcColumnInfo(List<ColumnInfo> columns) throws SQLException {
        ArrayList<JdbcColumnInfo> cols = new ArrayList<JdbcColumnInfo>(columns.size());
        for (ColumnInfo info : columns) {
            cols.add(new JdbcColumnInfo(info.name(), TypeUtils.of(info.esType()), "", "", "", "", info.displaySize()));
        }
        return cols;
    }
}

