/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.elasticsearch.common;

public final class Booleans {
    private Booleans() {
        throw new AssertionError((Object)"No instances intended");
    }

    public static boolean parseBoolean(char[] text, int offset, int length, boolean defaultValue) {
        if (text == null || length == 0) {
            return defaultValue;
        }
        return Booleans.parseBoolean(new String(text, offset, length));
    }

    public static boolean isBoolean(char[] text, int offset, int length) {
        if (text == null || length == 0) {
            return false;
        }
        return Booleans.isBoolean(new String(text, offset, length));
    }

    public static boolean isBoolean(String value) {
        return Booleans.isFalse(value) || Booleans.isTrue(value);
    }

    public static boolean parseBoolean(String value) {
        if (Booleans.isFalse(value)) {
            return false;
        }
        if (Booleans.isTrue(value)) {
            return true;
        }
        throw new IllegalArgumentException("Failed to parse value [" + value + "] as only [true] or [false] are allowed.");
    }

    private static boolean hasText(CharSequence str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean parseBoolean(String value, boolean defaultValue) {
        if (Booleans.hasText(value)) {
            return Booleans.parseBoolean(value);
        }
        return defaultValue;
    }

    public static Boolean parseBoolean(String value, Boolean defaultValue) {
        if (Booleans.hasText(value)) {
            return Booleans.parseBoolean(value);
        }
        return defaultValue;
    }

    @Deprecated
    public static Boolean parseBooleanLenient(String value, Boolean defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return Booleans.parseBooleanLenient(value, false);
    }

    @Deprecated
    public static boolean parseBooleanLenient(String value, boolean defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        switch (value) {
            case "false": 
            case "0": 
            case "off": 
            case "no": {
                return false;
            }
        }
        return true;
    }

    public static boolean isFalse(String value) {
        return "false".equals(value);
    }

    public static boolean isTrue(String value) {
        return "true".equals(value);
    }

    @Deprecated
    public static boolean parseBooleanLenient(char[] text, int offset, int length, boolean defaultValue) {
        if (text == null || length == 0) {
            return defaultValue;
        }
        if (length == 1) {
            return text[offset] != '0';
        }
        if (length == 2) {
            return !(text[offset] == 'n' && text[offset + 1] == 'o');
        }
        if (length == 3) {
            return !(text[offset] == 'o' && text[offset + 1] == 'f' && text[offset + 2] == 'f');
        }
        if (length == 5) {
            return !(text[offset] == 'f' && text[offset + 1] == 'a' && text[offset + 2] == 'l' && text[offset + 3] == 's' && text[offset + 4] == 'e');
        }
        return true;
    }

    @Deprecated
    public static boolean isBooleanLenient(char[] text, int offset, int length) {
        if (text == null || length == 0) {
            return false;
        }
        if (length == 1) {
            return text[offset] == '0' || text[offset] == '1';
        }
        if (length == 2) {
            return text[offset] == 'n' && text[offset + 1] == 'o' || text[offset] == 'o' && text[offset + 1] == 'n';
        }
        if (length == 3) {
            return text[offset] == 'o' && text[offset + 1] == 'f' && text[offset + 2] == 'f' || text[offset] == 'y' && text[offset + 1] == 'e' && text[offset + 2] == 's';
        }
        if (length == 4) {
            return text[offset] == 't' && text[offset + 1] == 'r' && text[offset + 2] == 'u' && text[offset + 3] == 'e';
        }
        if (length == 5) {
            return text[offset] == 'f' && text[offset + 1] == 'a' && text[offset + 2] == 'l' && text[offset + 3] == 's' && text[offset + 4] == 'e';
        }
        return false;
    }
}

