/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.elasticsearch.common.lease;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import shadow.org.elasticsearch.common.Nullable;
import shadow.org.elasticsearch.common.lease.Releasable;
import shadow.org.elasticsearch.core.internal.io.IOUtils;

public final class Releasables
extends Enum<Releasables> {
    private static final /* synthetic */ Releasables[] $VALUES;

    public static Releasables[] values() {
        return (Releasables[])$VALUES.clone();
    }

    public static Releasables valueOf(String name) {
        return Enum.valueOf(Releasables.class, name);
    }

    private static void close(Iterable<? extends Releasable> releasables, boolean ignoreException) {
        block2: {
            try {
                IOUtils.close(releasables);
            }
            catch (IOException e) {
                if (ignoreException) break block2;
                throw new UncheckedIOException(e);
            }
        }
    }

    public static void close(Iterable<? extends Releasable> releasables) {
        Releasables.close(releasables, false);
    }

    public static void close(@Nullable Releasable releasable) {
        try {
            IOUtils.close((Closeable)releasable);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void close(Releasable ... releasables) {
        Releasables.close(Arrays.asList(releasables));
    }

    public static void closeExpectNoException(Releasable ... releasables) {
        try {
            Releasables.close(releasables);
        }
        catch (RuntimeException e) {
            assert (false) : e;
            throw e;
        }
    }

    public static void closeExpectNoException(Releasable releasable) {
        try {
            Releasables.close(releasable);
        }
        catch (RuntimeException e) {
            assert (false) : e;
            throw e;
        }
    }

    public static void closeWhileHandlingException(Releasable ... releasables) {
        Releasables.close(Arrays.asList(releasables), true);
    }

    public static void close(boolean success, Iterable<Releasable> releasables) {
        Releasables.close(releasables, !success);
    }

    public static void close(boolean success, Releasable ... releasables) {
        Releasables.close(success, Arrays.asList(releasables));
    }

    public static Releasable wrap(Iterable<Releasable> releasables) {
        return () -> Releasables.close(releasables);
    }

    public static Releasable wrap(Releasable ... releasables) {
        return () -> Releasables.close(releasables);
    }

    public static Releasable releaseOnce(Releasable releasable) {
        AtomicBoolean released = new AtomicBoolean(false);
        return () -> {
            if (released.compareAndSet(false, true)) {
                releasable.close();
            }
        };
    }

    private static /* synthetic */ Releasables[] $values() {
        return new Releasables[0];
    }

    static {
        $VALUES = Releasables.$values();
    }
}

