/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.logging;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.firebirdsql.logging.ConsoleLogger;
import org.firebirdsql.logging.Log4jLogger;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.NullLogger;

public class LoggerFactory {
    private static final boolean forceConsoleLogger;
    private static final Logger NULL_LOGGER;
    private static final boolean log4j;

    private LoggerFactory() {
    }

    public static Logger getLogger(String name) {
        if (log4j) {
            return new Log4jLogger(name);
        }
        if (forceConsoleLogger) {
            return new ConsoleLogger(name);
        }
        return NULL_LOGGER;
    }

    public static Logger getLogger(String name, boolean def) {
        return LoggerFactory.getLogger(name);
    }

    public static Logger getLogger(Class clazz) {
        return LoggerFactory.getLogger(clazz.getName());
    }

    public static Logger getLogger(Class clazz, boolean def) {
        return LoggerFactory.getLogger(clazz);
    }

    private static String getSystemPropertyPrivileged(final String propertyName) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(propertyName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        NULL_LOGGER = new NullLogger();
        boolean useLog4j = false;
        boolean fallbackConsoleLogger = false;
        try {
            String sFallbackConsoleLogger = LoggerFactory.getSystemPropertyPrivileged("org.firebirdsql.jdbc.fallbackConsoleLogger");
            fallbackConsoleLogger = "true".equals(sFallbackConsoleLogger);
            String sLog4j = LoggerFactory.getSystemPropertyPrivileged("FBLog4j");
            String sUseLog4j = LoggerFactory.getSystemPropertyPrivileged("org.firebirdsql.jdbc.useLog4j");
            boolean bl = useLog4j = "true".equals(sLog4j) || "true".equals(sUseLog4j);
            if (useLog4j) {
                try {
                    Class.forName("org.apache.log4j.Category");
                    useLog4j = true;
                }
                catch (ClassNotFoundException cnfe) {
                    useLog4j = false;
                }
            }
        }
        catch (Exception ex) {
            useLog4j = false;
        }
        finally {
            forceConsoleLogger = fallbackConsoleLogger;
            log4j = useLog4j;
        }
    }
}

