/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.channel.client;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.util.Collections;
import org.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import org.bouncycastle.jcajce.provider.keystore.pkcs12.PKCS12KeyStoreSpi;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.fisco.bcos.web3j.crypto.ECKeyPair;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class P12Manager {
    private String p12File;
    private final String NAME = "key";
    private String password;
    private KeyStore keyStore;
    private PKCS12KeyStoreSpi p12KeyStore;

    public P12Manager() {
        Security.setProperty("crypto.policy", "unlimited");
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public void load() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, NoSuchProviderException {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        this.keyStore = KeyStore.getInstance("PKCS12", "BC");
        Resource keyStoreResource = resolver.getResource(this.p12File);
        this.keyStore.load(keyStoreResource.getInputStream(), this.password.toCharArray());
    }

    public void load(InputStream in, String password) throws NoSuchAlgorithmException, CertificateException, IOException, KeyStoreException, NoSuchProviderException {
        this.keyStore = KeyStore.getInstance("PKCS12", "BC");
        this.keyStore.load(in, password.toCharArray());
    }

    public PrivateKey getPrivateKey() throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException {
        return (PrivateKey)this.keyStore.getKey("key", this.password.toCharArray());
    }

    public PublicKey getPublicKey() throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        ECPrivateKey privateKey = (ECPrivateKey)this.getPrivateKey();
        ECParameterSpec params = privateKey.getParams();
        org.bouncycastle.jce.spec.ECParameterSpec bcSpec = EC5Util.convertSpec((ECParameterSpec)params, (boolean)false);
        org.bouncycastle.math.ec.ECPoint q = bcSpec.getG().multiply(privateKey.getS());
        org.bouncycastle.math.ec.ECPoint bcW = bcSpec.getCurve().decodePoint(q.getEncoded(false));
        ECPoint w = new ECPoint(bcW.getAffineXCoord().toBigInteger(), bcW.getAffineYCoord().toBigInteger());
        ECPublicKeySpec keySpec = new ECPublicKeySpec(w, P12Manager.tryFindNamedCurveSpec(params));
        return KeyFactory.getInstance("EC", "BC").generatePublic(keySpec);
    }

    public static ECParameterSpec tryFindNamedCurveSpec(ECParameterSpec params) {
        org.bouncycastle.jce.spec.ECParameterSpec bcSpec = EC5Util.convertSpec((ECParameterSpec)params, (boolean)false);
        for (Object name : Collections.list(ECNamedCurveTable.getNames())) {
            ECNamedCurveParameterSpec bcNamedSpec = ECNamedCurveTable.getParameterSpec((String)((String)name));
            if (!bcNamedSpec.getN().equals(bcSpec.getN()) || !bcNamedSpec.getH().equals(bcSpec.getH()) || !bcNamedSpec.getCurve().equals(bcSpec.getCurve()) || !bcNamedSpec.getG().equals(bcSpec.getG())) continue;
            return new ECNamedCurveSpec(bcNamedSpec.getName(), bcNamedSpec.getCurve(), bcNamedSpec.getG(), bcNamedSpec.getN(), bcNamedSpec.getH(), bcNamedSpec.getSeed());
        }
        return params;
    }

    public Certificate getCertificate() throws KeyStoreException {
        return this.keyStore.getCertificate("key");
    }

    public PublicKey getPublicKeyFromCertificate() throws KeyStoreException {
        Certificate certificate = this.getCertificate();
        return certificate.getPublicKey();
    }

    public ECKeyPair getECKeyPair() throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        PrivateKey privateKey = this.getPrivateKey();
        PublicKey publicKey = this.getPublicKey();
        KeyPair keyPair = new KeyPair(publicKey, privateKey);
        return ECKeyPair.create(keyPair);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getP12File() {
        return this.p12File;
    }

    public void setP12File(String p12File) {
        this.p12File = p12File;
    }
}

