/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.channel.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.SocketChannel;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.fisco.bcos.channel.client.AMOPVerifyUtil;
import org.fisco.bcos.channel.client.AmopException;
import org.fisco.bcos.channel.client.BcosResponseCallback;
import org.fisco.bcos.channel.client.BlockNotifyCallBack;
import org.fisco.bcos.channel.client.ChannelPushCallback;
import org.fisco.bcos.channel.client.ChannelResponseCallback2;
import org.fisco.bcos.channel.client.DefaultBlockNotifyCallBack;
import org.fisco.bcos.channel.client.PEMManager;
import org.fisco.bcos.channel.client.TransactionSucCallback;
import org.fisco.bcos.channel.dto.BcosBlockNotification;
import org.fisco.bcos.channel.dto.BcosHeartbeat;
import org.fisco.bcos.channel.dto.BcosMessage;
import org.fisco.bcos.channel.dto.BcosRequest;
import org.fisco.bcos.channel.dto.BcosResponse;
import org.fisco.bcos.channel.dto.ChannelMessage2;
import org.fisco.bcos.channel.dto.ChannelPush2;
import org.fisco.bcos.channel.dto.ChannelRequest;
import org.fisco.bcos.channel.dto.ChannelResponse;
import org.fisco.bcos.channel.dto.TopicVerifyMessage;
import org.fisco.bcos.channel.event.filter.EventLogFilter;
import org.fisco.bcos.channel.event.filter.EventLogFilterManager;
import org.fisco.bcos.channel.event.filter.EventLogFilterPushResponse;
import org.fisco.bcos.channel.event.filter.EventLogFilterPushStatus;
import org.fisco.bcos.channel.event.filter.EventLogFilterStatus;
import org.fisco.bcos.channel.event.filter.EventLogPushCallback;
import org.fisco.bcos.channel.event.filter.EventLogRequestParams;
import org.fisco.bcos.channel.event.filter.EventLogUserParams;
import org.fisco.bcos.channel.handler.AMOPVerifyKeyInfo;
import org.fisco.bcos.channel.handler.AMOPVerifyTopicToKeyInfo;
import org.fisco.bcos.channel.handler.ChannelConnections;
import org.fisco.bcos.channel.handler.ChannelHandlerContextHelper;
import org.fisco.bcos.channel.handler.ConnectionCallback;
import org.fisco.bcos.channel.handler.ConnectionInfo;
import org.fisco.bcos.channel.handler.GroupChannelConnectionsConfig;
import org.fisco.bcos.channel.handler.Message;
import org.fisco.bcos.channel.protocol.ChannelMessageError;
import org.fisco.bcos.channel.protocol.ChannelMessageType;
import org.fisco.bcos.channel.protocol.NodeRequestSdkVerifyTopic;
import org.fisco.bcos.channel.protocol.SdkRequestNodeUpdateTopicStatus;
import org.fisco.bcos.channel.protocol.TopicVerifyReqProtocol;
import org.fisco.bcos.channel.protocol.TopicVerifyRespProtocol;
import org.fisco.bcos.channel.protocol.parser.BlockNotificationParser;
import org.fisco.bcos.channel.protocol.parser.HeartBeatParser;
import org.fisco.bcos.web3j.protocol.ObjectMapperFactory;
import org.fisco.bcos.web3j.protocol.core.methods.response.Log;
import org.fisco.bcos.web3j.protocol.core.methods.response.TransactionReceipt;
import org.fisco.bcos.web3j.protocol.exceptions.TransactionException;
import org.fisco.bcos.web3j.tx.txdecode.LogResult;
import org.fisco.bcos.web3j.utils.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class Service {
    private static final Logger logger = LoggerFactory.getLogger(Service.class);
    public static final String verifyChannelPrefix = "#!$VerifyChannel_";
    public static final String pushChannelPrefix = "#!$PushChannel_";
    public static final String topicNeedVerifyPrefix = "#!$TopicNeedVerify_";
    private Integer connectSeconds = 30;
    private Integer connectSleepPerMillis = 1;
    private String orgID;
    private String agencyName;
    private GroupChannelConnectionsConfig allChannelConnections;
    private ChannelPushCallback pushCallback;
    private Map<String, Object> seq2Callback = new ConcurrentHashMap<String, Object>();
    private int groupId;
    private BigInteger number = BigInteger.valueOf(0L);
    private ConcurrentHashMap<String, BigInteger> nodeToBlockNumberMap = new ConcurrentHashMap();
    private Map<String, Object> seq2TransactionCallback = new ConcurrentHashMap<String, Object>();
    private Timer timeoutHandler = new HashedWheelTimer();
    private ThreadPoolTaskExecutor threadPool;
    private BlockNotifyCallBack blockNotifyCallBack = new DefaultBlockNotifyCallBack();
    private Set<String> topics = new HashSet<String>();
    private transient AMOPVerifyUtil topicVerify = new AMOPVerifyUtil();
    private EventLogFilterManager eventLogFilterManager = new EventLogFilterManager(this);
    private AMOPVerifyTopicToKeyInfo topic2KeyInfo = new AMOPVerifyTopicToKeyInfo();

    public AMOPVerifyTopicToKeyInfo getTopic2KeyInfo() {
        return this.topic2KeyInfo;
    }

    public void setTopic2KeyInfo(AMOPVerifyTopicToKeyInfo topic2KeyInfo) {
        this.topic2KeyInfo = topic2KeyInfo;
    }

    public Integer getConnectSeconds() {
        return this.connectSeconds;
    }

    public void setConnectSeconds(Integer connectSeconds) {
        this.connectSeconds = connectSeconds;
    }

    public Map<String, Object> getSeq2TransactionCallback() {
        return this.seq2TransactionCallback;
    }

    public void setSeq2TransactionCallback(Map<String, Object> seq2TransactionCallback) {
        this.seq2TransactionCallback = seq2TransactionCallback;
    }

    public BlockNotifyCallBack getBlockNotifyCallBack() {
        return this.blockNotifyCallBack;
    }

    public void setBlockNotifyCallBack(BlockNotifyCallBack blockNotifyCallBack) {
        this.blockNotifyCallBack = blockNotifyCallBack;
    }

    public void setTopics(Set<String> topics) {
        try {
            this.topics = topics;
        }
        catch (Exception e) {
            logger.error("system error:{}", (Throwable)e);
        }
    }

    public void addTopics(Set<String> topics) {
        try {
            this.topics.addAll(topics);
        }
        catch (Exception e) {
            logger.error("system error:{}", (Throwable)e);
        }
    }

    public void setNeedVerifyTopics(String topic) {
        try {
            this.topics.add(this.getNeedVerifyTopics(topic));
        }
        catch (Exception e) {
            logger.error("system error:{}", (Throwable)e);
        }
    }

    public String getNeedVerifyTopics(String topic) {
        StringBuilder sb = new StringBuilder();
        sb.append(topicNeedVerifyPrefix);
        sb.append(topic);
        return sb.toString();
    }

    public ConcurrentHashMap<String, BigInteger> getNodeToBlockNumberMap() {
        return this.nodeToBlockNumberMap;
    }

    public void setNodeToBlockNumberMap(ConcurrentHashMap<String, BigInteger> nodeToBlockNumberMap) {
        this.nodeToBlockNumberMap = nodeToBlockNumberMap;
    }

    public Set<String> getTopics() {
        return this.topics;
    }

    public Integer getConnectSleepPerMillis() {
        return this.connectSleepPerMillis;
    }

    public void setConnectSleepPerMillis(Integer connectSleepPerMillis) {
        this.connectSleepPerMillis = connectSleepPerMillis;
    }

    public String getOrgID() {
        return this.orgID;
    }

    public void setOrgID(String orgID) {
        this.orgID = orgID;
    }

    public String getAgencyName() {
        return this.agencyName;
    }

    public void setAgencyName(String agencyName) {
        this.agencyName = agencyName;
    }

    public ChannelPushCallback getPushCallback() {
        return this.pushCallback;
    }

    public void setPushCallback(ChannelPushCallback pushCallback) {
        this.pushCallback = pushCallback;
    }

    public GroupChannelConnectionsConfig getAllChannelConnections() {
        return this.allChannelConnections;
    }

    public void setAllChannelConnections(GroupChannelConnectionsConfig allChannelConnections) {
        this.allChannelConnections = allChannelConnections;
    }

    private void parseFromTopic2KeyInfo() throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, InvalidKeySpecException, NoSuchProviderException {
        ConcurrentHashMap<String, AMOPVerifyKeyInfo> topic2VerifyKeyInfo = this.topic2KeyInfo.getTopicToKeyInfo();
        Iterator<Map.Entry<String, AMOPVerifyKeyInfo>> entries = topic2VerifyKeyInfo.entrySet().iterator();
        ConcurrentHashMap<String, PrivateKey> topic2PrivateKey = new ConcurrentHashMap<String, PrivateKey>();
        ConcurrentHashMap<String, List<PublicKey>> topic2PublicKey = new ConcurrentHashMap<String, List<PublicKey>>();
        HashSet<String> set = new HashSet<String>();
        PEMManager pemManager = new PEMManager();
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<PublicKey> publicKeyList = new ArrayList<PublicKey>();
        while (entries.hasNext()) {
            List<Resource> publicKeyPathList;
            Map.Entry<String, AMOPVerifyKeyInfo> entry = entries.next();
            String topicName = entry.getKey();
            AMOPVerifyKeyInfo item = entry.getValue();
            if (item == null) continue;
            Resource privateKeyPath = item.getPrivateKey();
            if (privateKeyPath != null) {
                InputStream input = privateKeyPath.getInputStream();
                pemManager.load(input);
                PrivateKey privateKey = pemManager.getPrivateKey();
                topic2PrivateKey.put(this.getNeedVerifyTopics(topicName), privateKey);
                input.close();
                stringBuilder.delete(0, stringBuilder.length());
                stringBuilder.append(verifyChannelPrefix).append(this.getNeedVerifyTopics(topicName)).append('_');
                stringBuilder.append(UUID.randomUUID().toString().replaceAll("-", ""));
                set.add(stringBuilder.toString());
            }
            if ((publicKeyPathList = item.getPublicKey()) != null) {
                publicKeyList.clear();
                for (Resource publicKeyPath : publicKeyPathList) {
                    InputStream input = publicKeyPath.getInputStream();
                    pemManager.load(input);
                    PublicKey publicKey = pemManager.getPublicKeyFromPublicPem();
                    publicKeyList.add(publicKey);
                    input.close();
                }
                topic2PublicKey.put(this.getNeedVerifyTopics(topicName), publicKeyList);
                stringBuilder.delete(0, stringBuilder.length());
                stringBuilder.append(pushChannelPrefix).append(this.getNeedVerifyTopics(topicName));
                set.add(stringBuilder.toString());
                logger.info("add topic:{}", (Object)stringBuilder.toString());
            }
            this.topicVerify.setTopic2PrivateKey(topic2PrivateKey);
            this.topicVerify.setTopic2PublicKey(topic2PublicKey);
        }
        this.addTopics(set);
    }

    public void run() throws Exception {
        logger.debug("init ChannelService");
        this.parseFromTopic2KeyInfo();
        boolean flag = false;
        for (ChannelConnections channelConnections : this.allChannelConnections.getAllChannelConnections()) {
            if (channelConnections.getGroupId() != this.groupId) continue;
            flag = true;
            try {
                ConnectionCallback connectionCallback = new ConnectionCallback(this.topics);
                connectionCallback.setChannelService(this);
                channelConnections.setCallback(connectionCallback);
                channelConnections.setCaCert(this.allChannelConnections.getCaCert());
                channelConnections.setSslCert(this.allChannelConnections.getSslCert());
                channelConnections.setSslKey(this.allChannelConnections.getSslKey());
                channelConnections.init();
                channelConnections.setThreadPool(this.threadPool);
                channelConnections.startConnect();
                int sleepTime = 0;
                boolean running = false;
                while (true) {
                    Map<String, ChannelHandlerContext> networkConnection = channelConnections.getNetworkConnections();
                    for (String key : networkConnection.keySet()) {
                        if (networkConnection.get(key) == null || !ChannelHandlerContextHelper.isChannelAvailable(networkConnection.get(key))) continue;
                        running = true;
                        break;
                    }
                    if (running || sleepTime > this.connectSeconds * 1000) break;
                    Thread.sleep(this.connectSleepPerMillis.intValue());
                    sleepTime += this.connectSleepPerMillis.intValue();
                }
                if (!running) {
                    logger.error("connectSeconds = {}", (Object)this.connectSeconds);
                    logger.error("can not connect to nodes success, please checkout the node status and the sdk config!");
                    throw new Exception("Can not connect to nodes success, please checkout the node status and the sdk config!");
                }
                this.eventLogFilterManager.start();
            }
            catch (InterruptedException e) {
                logger.error("system error ", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                logger.error("system error ", (Throwable)e);
                throw e;
            }
        }
        if (!flag) {
            throw new Exception("Please set the right groupId");
        }
    }

    public BcosResponse sendEthereumMessage(BcosRequest request) {
        class Callback
        extends BcosResponseCallback {
            public transient BcosResponse bcosResponse;
            public transient Semaphore semaphore = new Semaphore(1, true);

            Callback() {
                try {
                    this.semaphore.acquire(1);
                }
                catch (InterruptedException e) {
                    logger.error("error :", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }

            @Override
            public void onResponse(BcosResponse response) {
                this.bcosResponse = response;
                if (this.bcosResponse != null && this.bcosResponse.getContent() != null) {
                    logger.debug("response: {}", (Object)response.getContent());
                } else {
                    logger.error("response is null");
                }
                this.semaphore.release();
            }
        }
        Callback callback = new Callback();
        this.asyncSendEthereumMessage(request, callback);
        try {
            callback.semaphore.acquire(1);
        }
        catch (InterruptedException e) {
            logger.error("system error:", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        return callback.bcosResponse;
    }

    public BcosResponse sendEthereumMessage(BcosRequest request, TransactionSucCallback transactionSucCallback) {
        class Callback
        extends BcosResponseCallback {
            private transient BcosResponse ethereumResponse;
            private transient Semaphore semaphore = new Semaphore(1, true);

            Callback() {
                try {
                    this.semaphore.acquire(1);
                }
                catch (InterruptedException e) {
                    logger.error("error:", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }

            @Override
            public void onResponse(BcosResponse response) {
                this.ethereumResponse = response;
                this.semaphore.release();
            }
        }
        Callback callback = new Callback();
        this.asyncSendEthereumMessage(request, callback, transactionSucCallback);
        try {
            callback.semaphore.acquire(1);
        }
        catch (InterruptedException e) {
            logger.error("system error:", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        return callback.ethereumResponse;
    }

    public void asyncSendEthereumMessage(final BcosRequest request, BcosResponseCallback fiscoResponseCallback, TransactionSucCallback transactionSucCallback) {
        this.asyncSendEthereumMessage(request, fiscoResponseCallback);
        if (request.getTimeout() > 0) {
            final TransactionSucCallback callbackInner = transactionSucCallback;
            callbackInner.setTimeout(this.timeoutHandler.newTimeout(new TimerTask(){

                public void run(Timeout timeout) throws Exception {
                    callbackInner.onTimeout();
                    Service.this.seq2TransactionCallback.remove(request.getMessageID());
                }
            }, (long)request.getTimeout().intValue(), TimeUnit.MILLISECONDS));
            this.seq2TransactionCallback.put(request.getMessageID(), callbackInner);
        } else {
            this.seq2TransactionCallback.put(request.getMessageID(), transactionSucCallback);
        }
    }

    public ChannelResponse sendChannelMessageForVerifyTopic(ChannelRequest request) {
        String toTopic = request.getToTopic();
        request.setToTopic(this.getNeedVerifyTopics(toTopic));
        return this.sendChannelMessage2(request);
    }

    public ChannelResponse sendChannelMessage2(ChannelRequest request) {
        request.setType((short)ChannelMessageType.AMOP_REQUEST.getType());
        class Callback
        extends ChannelResponseCallback2 {
            public transient ChannelResponse channelResponse;
            public transient Semaphore semaphore = new Semaphore(1, true);

            Callback() {
                try {
                    this.semaphore.acquire(1);
                }
                catch (InterruptedException e) {
                    logger.error("error:", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }

            @Override
            public void onResponseMessage(ChannelResponse response) {
                this.channelResponse = response;
                logger.debug("response: {}", (Object)response.getContent());
                this.semaphore.release();
            }
        }
        Callback callback = new Callback();
        this.asyncSendChannelMessage2(request, callback);
        try {
            callback.semaphore.acquire(1);
        }
        catch (InterruptedException e) {
            logger.error("system error:", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        return callback.channelResponse;
    }

    public void asyncSendEthereumMessage(BcosRequest request, BcosResponseCallback callback) {
        BcosMessage bcosMessage = new BcosMessage();
        bcosMessage.setSeq(request.getMessageID());
        bcosMessage.setResult(0);
        bcosMessage.setType((short)18);
        bcosMessage.setData(request.getContent().getBytes());
        try {
            ChannelConnections channelConnections = this.allChannelConnections.getAllChannelConnections().stream().filter(x -> x.getGroupId() == this.groupId).findFirst().get();
            if (channelConnections == null) {
                if (this.orgID != null) {
                    logger.error("not found:{}", (Object)this.orgID);
                    throw new TransactionException("not found orgID");
                }
                logger.error("not found:{}", (Object)this.agencyName);
                throw new TransactionException("not found agencyName");
            }
            ChannelHandlerContext ctx = channelConnections.randomNetworkConnection(this.nodeToBlockNumberMap);
            ByteBuf out = ctx.alloc().buffer();
            bcosMessage.writeHeader(out);
            bcosMessage.writeExtra(out);
            this.seq2Callback.put(request.getMessageID(), callback);
            if (request.getTimeout() > 0) {
                final BcosResponseCallback callbackInner = callback;
                callback.setTimeout(this.timeoutHandler.newTimeout(new TimerTask(){
                    BcosResponseCallback _callback;
                    {
                        this._callback = callbackInner;
                    }

                    public void run(Timeout timeout) throws Exception {
                        this._callback.onTimeout();
                    }
                }, (long)request.getTimeout().intValue(), TimeUnit.MILLISECONDS));
            }
            ctx.writeAndFlush((Object)out);
            SocketChannel socketChannel = (SocketChannel)ctx.channel();
            InetSocketAddress socketAddress = socketChannel.remoteAddress();
            logger.debug("selected node {}:{} bcos request, seq:{}", new Object[]{socketAddress.getAddress().getHostAddress(), socketAddress.getPort(), bcosMessage.getSeq()});
        }
        catch (Exception e) {
            logger.error("system error:{} ", (Throwable)e);
            BcosResponse response = new BcosResponse();
            response.setErrorCode(-1);
            response.setErrorMessage(e.getMessage() + " Requset send failed! Can not connect to nodes success, please checkout the node status and the sdk config!");
            response.setContent("");
            response.setMessageID(request.getMessageID());
            if (callback.getTimeout() != null) {
                callback.getTimeout().cancel();
            }
            callback.onResponse(response);
        }
    }

    public void asyncSendChannelMessage2(ChannelRequest request, ChannelResponseCallback2 callback) {
        try {
            if (request.getContentByteArray().length >= 0x2000000) {
                logger.error("send byte length should not greater than 32M now length:{}", (Object)request.getContentByteArray().length);
                throw new AmopException("send byte length should not greater than 32M");
            }
            logger.debug("ChannelRequest:{} ", (Object)request.getMessageID());
            callback.setService(this);
            ChannelMessage2 channelMessage = new ChannelMessage2();
            channelMessage.setSeq(request.getMessageID());
            channelMessage.setResult(0);
            if (request.getType() == 0) {
                channelMessage.setType((short)ChannelMessageType.AMOP_REQUEST.getType());
            } else {
                channelMessage.setType(request.getType());
            }
            channelMessage.setData(request.getContentByteArray());
            channelMessage.setTopic(request.getToTopic());
            logger.info("msgid:{} type:{} topic:{}", new Object[]{request.getMessageID(), channelMessage.getType(), request.getToTopic()});
            try {
                ArrayList<ConnectionInfo> fromConnectionInfos = new ArrayList<ConnectionInfo>();
                ChannelConnections fromChannelConnections = this.allChannelConnections.getAllChannelConnections().stream().filter(x -> x.getGroupId() == this.groupId).findFirst().get();
                if (fromChannelConnections == null) {
                    if (this.orgID != null) {
                        logger.error("not found:{}", (Object)this.orgID);
                        throw new Exception("not found orgID");
                    }
                    logger.error("not found:{}", (Object)this.agencyName);
                    throw new Exception("not found agencyName");
                }
                fromConnectionInfos.addAll(fromChannelConnections.getConnections());
                logger.debug("FromOrg:{} nodes:{}", (Object)request.getFromOrg(), (Object)fromChannelConnections.getConnections().size());
                callback.setFromChannelConnections(fromChannelConnections);
                callback.setFromConnectionInfos(fromConnectionInfos);
                callback.setRequest(channelMessage);
                logger.info("put msgid:{} into callback map", (Object)request.getMessageID());
                this.seq2Callback.put(request.getMessageID(), callback);
                if (request.getTimeout() > 0) {
                    logger.info("timeoutms:{}", (Object)request.getTimeout());
                    final ChannelResponseCallback2 callbackInner = callback;
                    callback.setTimeout(this.timeoutHandler.newTimeout(new TimerTask(){
                        ChannelResponseCallback2 _callback;
                        {
                            this._callback = callbackInner;
                        }

                        public void run(Timeout timeout) throws Exception {
                            this._callback.onTimeout();
                        }
                    }, (long)request.getTimeout().intValue(), TimeUnit.MILLISECONDS));
                }
                callback.retrySendMessage();
            }
            catch (Exception e) {
                logger.error("send message fail:", (Throwable)e);
                ChannelResponse response = new ChannelResponse();
                response.setErrorCode(ChannelMessageError.MESSAGE_SEND_EXCEPTION.getError());
                response.setMessageID(request.getMessageID());
                response.setErrorMessage(e.getMessage());
                response.setContent("");
                callback.onResponse(response);
                return;
            }
        }
        catch (Exception e) {
            logger.error("system error", (Throwable)e);
        }
    }

    public void asyncMulticastChannelMessageForVerifyTopic(ChannelRequest request) {
        String toTopic = request.getToTopic();
        request.setToTopic(this.getNeedVerifyTopics(toTopic));
        this.asyncMulticastChannelMessage2(request);
    }

    public void asyncMulticastChannelMessage2(ChannelRequest request) {
        try {
            logger.debug("ChannelRequest:{} ", (Object)request.getMessageID());
            ChannelMessage2 channelMessage = new ChannelMessage2();
            channelMessage.setSeq(request.getMessageID());
            channelMessage.setResult(0);
            channelMessage.setType((short)ChannelMessageType.AMOP_MULBROADCAST.getType());
            channelMessage.setData(request.getContentByteArray());
            channelMessage.setTopic(request.getToTopic());
            try {
                ChannelConnections fromChannelConnections = this.allChannelConnections.getAllChannelConnections().stream().filter(x -> x.getGroupId() == this.groupId).findFirst().get();
                if (fromChannelConnections == null) {
                    if (this.orgID != null) {
                        logger.error("not found:{}", (Object)this.orgID);
                        throw new Exception("not found orgID");
                    }
                    logger.error("not found:{}", (Object)this.agencyName);
                    throw new Exception("not found agencyName");
                }
                logger.debug("FromOrg:{} nodes:{}", (Object)request.getFromOrg(), (Object)fromChannelConnections.getConnections().size());
                for (ConnectionInfo connectionInfo : fromChannelConnections.getConnections()) {
                    ChannelHandlerContext ctx = fromChannelConnections.getNetworkConnectionByHost(connectionInfo.getHost(), connectionInfo.getPort());
                    if (ctx != null && ChannelHandlerContextHelper.isChannelAvailable(ctx)) {
                        ByteBuf out = ctx.alloc().buffer();
                        channelMessage.writeHeader(out);
                        channelMessage.writeExtra(out);
                        ctx.writeAndFlush((Object)out);
                        logger.debug("send message to{}:{} success ", (Object)connectionInfo.getHost(), (Object)connectionInfo.getPort());
                        continue;
                    }
                    logger.error("sending node unavailable, {}:{}", (Object)connectionInfo.getHost(), (Object)connectionInfo.getPort());
                }
            }
            catch (Exception e) {
                logger.error("send message fail:{}", (Throwable)e);
                ChannelResponse response = new ChannelResponse();
                response.setErrorCode(ChannelMessageError.MESSAGE_SEND_EXCEPTION.getError());
                response.setMessageID(request.getMessageID());
                response.setErrorMessage(e.getMessage());
                response.setContent("");
                return;
            }
        }
        catch (Exception e) {
            logger.error("system error:{}", (Throwable)e);
        }
    }

    public void sendResponseMessage2(ChannelResponse response, ChannelHandlerContext ctx, String seq, String topic) {
        try {
            ChannelMessage2 responseMessage = new ChannelMessage2();
            responseMessage.setData(response.getContentByteArray());
            responseMessage.setResult(response.getErrorCode());
            responseMessage.setSeq(seq);
            responseMessage.setType((short)ChannelMessageType.AMOP_RESPONSE.getType());
            responseMessage.setTopic(topic);
            ByteBuf out = ctx.alloc().buffer();
            responseMessage.writeHeader(out);
            responseMessage.writeExtra(out);
            ctx.writeAndFlush((Object)out);
            logger.info("response seq:{} length:{}", (Object)response.getMessageID(), (Object)out.readableBytes());
        }
        catch (Exception e) {
            logger.error("system error:{}", (Throwable)e);
        }
    }

    public void sendCheckResultToNode(ChannelRequest request, ChannelHandlerContext ctx, short msgtype) {
        try {
            Message msg = new Message();
            msg.setData(request.getContentByteArray());
            msg.setResult(0);
            msg.setSeq(request.getMessageID());
            msg.setType(msgtype);
            msg.setResult(0);
            ByteBuf out = ctx.alloc().buffer();
            msg.writeHeader(out);
            msg.writeExtra(out);
            ctx.writeAndFlush((Object)out);
            logger.debug("response seq:{} length:{}", (Object)request.getMessageID(), (Object)out.readableBytes());
        }
        catch (Exception e) {
            logger.error("system error:", (Throwable)e);
        }
    }

    public void registerEventLogFilter(EventLogUserParams params, EventLogPushCallback callback) {
        if (!params.checkParams(this.getNumber())) {
            callback.onPushEventLog(EventLogFilterPushStatus.INVALID_PARAMS.getStatus(), null);
            return;
        }
        EventLogFilter filter = new EventLogFilter();
        filter.setCallback(callback);
        filter.setRegisterID(this.newSeq());
        filter.setParams(params);
        callback.setFilter(filter);
        this.eventLogFilterManager.addEventLogFilter(filter);
        this.asyncSendRegisterEventLogFilterMessage(filter);
        logger.info(" add register event log filter, registerID: {}, params: {}", (Object)filter.getRegisterID(), (Object)params);
    }

    public void asyncSendRegisterEventLogFilterMessage(final EventLogFilter filter) {
        ChannelRequest request = new ChannelRequest();
        request.setMessageID(this.newSeq());
        request.setToTopic("");
        request.setType((short)ChannelMessageType.CLIENT_REGISTER_EVENT_LOG.getType());
        EventLogRequestParams params = new EventLogRequestParams(filter.generateNewParams(), String.valueOf(this.getGroupId()), this.newSeq());
        logger.info(" registerID: {}, filterID: {}, params: {}", new Object[]{filter.getRegisterID(), filter.getFilterID(), params});
        try {
            request.setContent(params.toJsonString());
        }
        catch (JsonProcessingException e1) {
            filter.getCallback().onPushEventLog(EventLogFilterPushStatus.INVALID_PARAMS.getStatus(), null);
            this.eventLogFilterManager.removeFilter(filter.getRegisterID());
            return;
        }
        final String filterID = params.getFilterID();
        final String registerID = filter.getRegisterID();
        filter.setFilterID(filterID);
        final EventLogPushCallback callback0 = filter.getCallback();
        this.eventLogFilterManager.addCallback(params.getFilterID(), filter.getCallback());
        this.asyncSendChannelMessage2(request, new ChannelResponseCallback2(){

            @Override
            public void onResponseMessage(ChannelResponse response) {
                logger.info(" event filter callback response, registerID: {}, filterID: {}, seq: {}, error code: {},  content: {}", new Object[]{registerID, filterID, response.getMessageID(), response.getErrorCode(), response.getContent()});
                try {
                    if (0 == response.getErrorCode()) {
                        EventLogFilterPushResponse resp = (EventLogFilterPushResponse)ObjectMapperFactory.getObjectMapper().readValue(response.getContent(), EventLogFilterPushResponse.class);
                        if (resp.getResult() == 0) {
                            Service.this.eventLogFilterManager.updateEventLogFilter(callback0.getFilter(), EventLogFilterStatus.EVENT_LOG_PUSHING, response.getCtx());
                        } else {
                            callback0.onPushEventLog(resp.getResult(), null);
                            Service.this.eventLogFilterManager.removeFilterAndCallback(registerID, filterID);
                        }
                    } else {
                        Service.this.eventLogFilterManager.updateEventLogFilter(callback0.getFilter(), EventLogFilterStatus.WAITING_REQUEST, null);
                        Service.this.eventLogFilterManager.removeCallback(filterID);
                    }
                }
                catch (Exception e) {
                    callback0.onPushEventLog(EventLogFilterPushStatus.OTHER_ERROR.getStatus(), null);
                    Service.this.eventLogFilterManager.removeFilterAndCallback(filter.getRegisterID(), filterID);
                    logger.error(" event filter response message exception, filterID: {}, registerID: {}, exception message: {}", new Object[]{filterID, registerID, e.getMessage()});
                }
            }
        });
    }

    public void onReceiveRegisterEventResponse(ChannelHandlerContext ctx, ChannelMessage2 message) {
        ChannelResponseCallback2 callback = (ChannelResponseCallback2)this.seq2Callback.get(message.getSeq());
        String seq = message.getSeq();
        String content = new String(message.getData());
        if (callback == null) {
            logger.warn(" register event filter response cannot find callback, seq: {}, content: {}", (Object)seq, (Object)content);
            return;
        }
        this.seq2Callback.remove(seq);
        ChannelResponse response = new ChannelResponse();
        response.setCtx(ctx);
        response.setErrorCode(message.getResult());
        response.setMessageID(message.getSeq());
        if (message.getData() != null) {
            response.setContent(message.getData());
        }
        callback.onResponse(response);
        logger.info(" register event filter response, seq: {}, content: {} ", (Object)seq, (Object)content);
    }

    public void onReceiveEventLogPush(ChannelHandlerContext ctx, BcosMessage message) {
        String content = new String(message.getData());
        try {
            EventLogFilterPushResponse resp = (EventLogFilterPushResponse)ObjectMapperFactory.getObjectMapper().readValue(content, EventLogFilterPushResponse.class);
            if (resp == null || Strings.isEmpty(resp.getFilterID())) {
                logger.error(" event log response invalid format, content: {}", (Object)content);
                return;
            }
            EventLogPushCallback callback = this.eventLogFilterManager.getFilterCallback(resp.getFilterID());
            if (callback == null) {
                logger.debug(" event log push message cannot find callback, filterID: {}, content: {}", (Object)resp.getFilterID(), (Object)content);
                return;
            }
            if (resp.getResult() == EventLogFilterPushStatus.SUCCESS.getStatus()) {
                if (!resp.getLogs().isEmpty()) {
                    ArrayList<LogResult> logResults = new ArrayList<LogResult>();
                    for (Log log : resp.getLogs()) {
                        LogResult logResult = callback.transferLogToLogResult(log);
                        if (logResult == null) {
                            logger.warn(" event log push message decode failed, filterID: {}, log: {}", (Object)resp.getFilterID(), (Object)log);
                            continue;
                        }
                        logResults.add(logResult);
                    }
                    callback.onPushEventLog(EventLogFilterPushStatus.SUCCESS.getStatus(), logResults);
                    callback.getFilter().updateByLogResult(logResults);
                    logger.info(" log size: {}, blocknumber: {}", (Object)logResults.size(), (Object)((LogResult)logResults.get(0)).getLog().getBlockNumber());
                }
            } else if (resp.getResult() == EventLogFilterPushStatus.PUSH_COMPLETED.getStatus()) {
                callback.onPushEventLog(EventLogFilterPushStatus.PUSH_COMPLETED.getStatus(), null);
                this.eventLogFilterManager.removeFilterAndCallback(callback.getFilter().getRegisterID(), resp.getFilterID());
                logger.info("event log push message push end, filterID: {}, registerID: {}, content: {}", new Object[]{resp.getFilterID(), callback.getFilter().getRegisterID(), content});
            } else {
                callback.onPushEventLog(resp.getResult(), null);
                this.eventLogFilterManager.removeFilterAndCallback(callback.getFilter().getRegisterID(), resp.getFilterID());
                logger.warn("event log push message, filterID: {}, registerID: {}, code: {}, content: {}", new Object[]{resp.getFilterID(), callback.getFilter().getRegisterID(), resp.getResult(), content});
            }
        }
        catch (Exception e) {
            logger.error("event log push message exception, error message: {}, content: {}", (Object)e.getMessage(), (Object)content);
        }
    }

    public void onReceiveEthereumMessage(ChannelHandlerContext ctx, BcosMessage message) {
        BcosResponseCallback callback = (BcosResponseCallback)this.seq2Callback.get(message.getSeq());
        if (callback != null) {
            if (callback.getTimeout() != null) {
                callback.getTimeout().cancel();
            }
            logger.trace(" receive ethereum response, seq: {}, result: {}, content: {}", new Object[]{message.getSeq(), message.getResult(), new String(message.getData())});
            BcosResponse response = new BcosResponse();
            if (message.getResult() != 0) {
                response.setErrorMessage("BcosResponse error");
            }
            response.setErrorCode(message.getResult());
            response.setMessageID(message.getSeq());
            response.setContent(new String(message.getData()));
            callback.onResponse(response);
            this.seq2Callback.remove(message.getSeq());
        } else {
            logger.debug("no callback push message");
        }
    }

    public void onReceiveChannelMessage2(ChannelHandlerContext ctx, ChannelMessage2 message) {
        block15: {
            ChannelResponseCallback2 callback = (ChannelResponseCallback2)this.seq2Callback.get(message.getSeq());
            if (message.getType().shortValue() == ChannelMessageType.AMOP_REQUEST.getType() || message.getType().shortValue() == ChannelMessageType.AMOP_MULBROADCAST.getType()) {
                logger.debug("channel PUSH");
                if (callback != null) {
                    logger.debug("seq already existed\uff0cclear:{}", (Object)message.getSeq());
                    this.seq2Callback.remove(message.getSeq());
                }
                if (message.getTopic().length() > verifyChannelPrefix.length() && verifyChannelPrefix.equals(message.getTopic().substring(0, verifyChannelPrefix.length()))) {
                    try {
                        this.signForAmop(ctx, message);
                    }
                    catch (IOException e) {
                        logger.error("sign for amop failed:{}", (Throwable)e);
                    }
                } else {
                    try {
                        ChannelPush2 push = new ChannelPush2();
                        if (this.pushCallback != null) {
                            push.setSeq(message.getSeq());
                            push.setService(this);
                            push.setCtx(ctx);
                            push.setTopic(message.getTopic());
                            push.setSeq(message.getSeq());
                            push.setMessageID(message.getSeq());
                            logger.info("msg:{}", (Object)Arrays.toString(message.getData()));
                            push.setContent(message.getData());
                            this.pushCallback.onPush(push);
                            break block15;
                        }
                        logger.error("can not push\uff0cunset push callback");
                    }
                    catch (Exception e) {
                        logger.error("push error:{}", (Throwable)e);
                    }
                }
            } else if (message.getType().shortValue() == ChannelMessageType.AMOP_RESPONSE.getType()) {
                logger.info("channel message:{}", (Object)message.getSeq());
                if (callback != null) {
                    logger.debug("found callback response");
                    ChannelResponse response = new ChannelResponse();
                    if (message.getResult() != 0) {
                        response.setErrorCode(message.getResult());
                        response.setErrorMessage("response errors");
                    }
                    response.setErrorCode(message.getResult());
                    response.setMessageID(message.getSeq());
                    if (message.getData() != null) {
                        response.setContent(message.getData());
                    }
                    callback.onResponse(response);
                } else {
                    logger.error("can not found response callback\uff0ctimeout:{}", (Object)message.getData());
                    return;
                }
            }
        }
    }

    private void sendResponse2Node(ChannelHandlerContext ctx, TopicVerifyMessage message) {
        try {
            Message response = new Message();
            response.setSeq(message.getSeq());
            response.setResult(0);
            response.setType((short)ChannelMessageType.REQUEST_TOPICCERT.getType());
            response.setData("".getBytes());
            ByteBuf out = ctx.alloc().buffer();
            response.writeHeader(out);
            response.writeExtra(out);
            ctx.writeAndFlush((Object)out);
            logger.info("response seq:{} length:{}", (Object)response.getSeq(), (Object)out.readableBytes());
        }
        catch (Exception e) {
            logger.error("response seq:{} send error", (Object)message.getSeq());
        }
    }

    public void checkTopicVerify(final ChannelHandlerContext ctx, TopicVerifyMessage message) throws IOException {
        SocketChannel socketChannel = (SocketChannel)ctx.channel();
        logger.info("get rand value request ChannelResponse seq:{} msgtype:{} address:{} port:{}", new Object[]{message.getSeq(), message.getType(), socketChannel.remoteAddress().getAddress().getHostAddress(), socketChannel.remoteAddress().getPort()});
        logger.info("get rand value request :{} length:{}", (Object)Arrays.toString(message.getData()), (Object)message.getLength());
        this.sendResponse2Node(ctx, message);
        String content = new String(message.getData());
        logger.info("content:{} content:{}", (Object)content, (Object)Arrays.toString(content.getBytes()));
        NodeRequestSdkVerifyTopic nodeRequestSdkVerifyTopic = (NodeRequestSdkVerifyTopic)ObjectMapperFactory.getObjectMapper().readValue(content, NodeRequestSdkVerifyTopic.class);
        final String topic = nodeRequestSdkVerifyTopic.getTopic();
        String topicForCert = nodeRequestSdkVerifyTopic.getTopicForCert();
        final String nodeid = nodeRequestSdkVerifyTopic.getNodeId();
        logger.info("topic:{} topicForCert:{} nodeid:{}", new Object[]{topic, topicForCert, nodeid});
        ChannelRequest request = new ChannelRequest();
        request.setToTopic(topicForCert);
        request.setMessageID(this.newSeq());
        request.setTimeout(5000);
        request.setType((short)ChannelMessageType.AMOP_REQUEST.getType());
        final String randValue = UUID.randomUUID().toString().replaceAll("-", "");
        TopicVerifyReqProtocol topicVerifyProtocol = new TopicVerifyReqProtocol();
        topicVerifyProtocol.setRandValue(randValue);
        topicVerifyProtocol.setTopic(topic);
        String jsonStr = ObjectMapperFactory.getObjectMapper().writeValueAsString((Object)topicVerifyProtocol);
        logger.info("generate rand value jsonStr:{} topic:{} messageid:{}", new Object[]{jsonStr, request.getToTopic(), message.getSeq()});
        byte[] bytes = this.topicVerify.getByteBuffByString(request.getToTopic(), jsonStr);
        request.setContent(bytes);
        this.asyncSendChannelMessage2(request, new ChannelResponseCallback2(){

            @Override
            public void onResponseMessage(ChannelResponse response) {
                logger.info("get response messageid:{}", (Object)response.getMessageID());
                try {
                    Service.this.checkSignForAmop(topic, String.valueOf(randValue), nodeid, ctx, response);
                }
                catch (IOException e) {
                    logger.error("check sign for amop failed:{}", (Throwable)e);
                }
            }
        });
    }

    public void signForAmop(ChannelHandlerContext ctx, ChannelMessage2 message) throws IOException {
        SocketChannel socketChannel = (SocketChannel)ctx.channel();
        logger.info("sign ChannelResponse seq:{} msgtype:{} address:{} port:{}", new Object[]{message.getSeq(), message.getType(), socketChannel.remoteAddress().getAddress().getHostAddress(), socketChannel.remoteAddress().getPort()});
        logger.info("sign request :{} length:{}", (Object)Arrays.toString(message.getData()), (Object)message.getLength());
        String content = this.topicVerify.parseDataFromPush(message.getLength(), message.getData());
        logger.info("content:{} content:{}", (Object)content, (Object)Arrays.toString(content.getBytes()));
        TopicVerifyReqProtocol topicVerifyProtocol = (TopicVerifyReqProtocol)ObjectMapperFactory.getObjectMapper().readValue(content, TopicVerifyReqProtocol.class);
        String randValue = topicVerifyProtocol.getRandValue();
        String topic = topicVerifyProtocol.getTopic();
        logger.info("sign rand_value:{} sign topic:{}", (Object)randValue, (Object)topic);
        String signature = this.topicVerify.signatureForRandValue(topic, randValue);
        TopicVerifyRespProtocol topicVerifyRespProtocol = new TopicVerifyRespProtocol();
        topicVerifyRespProtocol.setSignature(signature);
        String jsonStr = ObjectMapperFactory.getObjectMapper().writeValueAsString((Object)topicVerifyRespProtocol);
        logger.info("signature jsonStr result:{}", (Object)jsonStr);
        byte[] bytes = this.topicVerify.getByteBuffByString(message.getTopic(), jsonStr);
        ChannelResponse response = new ChannelResponse();
        response.setMessageID(message.getSeq());
        response.setErrorCode(0);
        response.setContent(bytes);
        this.sendResponseMessage2(response, ctx, message.getSeq(), message.getTopic());
    }

    public void checkSignForAmop(String topic, String randValue, String nodeid, ChannelHandlerContext ctx, ChannelResponse response) throws IOException {
        if (response.getErrorCode() != 0) {
            logger.error("get signature failed :{}:{}", (Object)response.getErrorCode(), (Object)response.getErrorMessage());
            return;
        }
        logger.info("check signature:{} length:{}", (Object)Arrays.toString(response.getContentByteArray()), (Object)response.getContentByteArray().length);
        String content = this.topicVerify.parseDataFromPush(response.getContentByteArray().length, response.getContentByteArray());
        logger.info("content:{} content:{}", (Object)content, (Object)Arrays.toString(content.getBytes()));
        TopicVerifyRespProtocol topicVerifyRespProtocol = (TopicVerifyRespProtocol)ObjectMapperFactory.getObjectMapper().readValue(content, TopicVerifyRespProtocol.class);
        String signature = topicVerifyRespProtocol.getSignature();
        logger.info("signature:{} ", (Object)signature);
        int checkResult = this.topicVerify.checkSignatureValidate(topic, signature, randValue);
        SdkRequestNodeUpdateTopicStatus sdkRequestNodeUpdateTopicStatus = new SdkRequestNodeUpdateTopicStatus();
        sdkRequestNodeUpdateTopicStatus.setCheckResult(checkResult);
        sdkRequestNodeUpdateTopicStatus.setNodeId(nodeid);
        sdkRequestNodeUpdateTopicStatus.setTopic(topic);
        String jsonStr = ObjectMapperFactory.getObjectMapper().writeValueAsString((Object)sdkRequestNodeUpdateTopicStatus);
        logger.info("check signature result:{}", (Object)jsonStr);
        ChannelRequest request = new ChannelRequest();
        request.setMessageID(this.newSeq());
        request.setToTopic(topic);
        request.setTimeout(5000);
        request.setContent(jsonStr.getBytes());
        this.sendCheckResultToNode(request, ctx, (short)ChannelMessageType.UPDATE_TOPIICSTATUS.getType());
    }

    public void onReceiveBlockNotify(ChannelHandlerContext ctx, ChannelMessage2 message) {
        try {
            BlockNotificationParser blkNotifyParser = new BlockNotificationParser(ChannelHandlerContextHelper.getProtocolVersion(ctx));
            String data = new String(message.getData());
            logger.info("Receive block notify: {}", (Object)data);
            BcosBlockNotification bcosBlkNotify = null;
            try {
                bcosBlkNotify = blkNotifyParser.decode(data);
            }
            catch (Exception e) {
                logger.error(" block notify parse message exception, message: {}", (Object)e.getMessage());
                return;
            }
            logger.trace(" BcosBlkNotify: {}  ", (Object)bcosBlkNotify);
            Integer groupID = Integer.parseInt(bcosBlkNotify.getGroupID());
            BigInteger blkNumber = bcosBlkNotify.getBlockNumber();
            if (!groupID.equals(this.getGroupId())) {
                logger.error("Received groupID[{}] not match groupID[{}]", (Object)groupID, (Object)this.getGroupId());
                return;
            }
            SocketChannel socketChannel = (SocketChannel)ctx.channel();
            String hostAddress = socketChannel.remoteAddress().getAddress().getHostAddress();
            int port = socketChannel.remoteAddress().getPort();
            this.nodeToBlockNumberMap.put(hostAddress + port, blkNumber);
            BigInteger maxBlockNumber = blkNumber;
            for (String key : this.nodeToBlockNumberMap.keySet()) {
                BigInteger blockNumber = this.nodeToBlockNumberMap.get(key);
                if (blockNumber.compareTo(maxBlockNumber) < 0) continue;
                maxBlockNumber = blockNumber;
            }
            if (maxBlockNumber.compareTo(this.getNumber()) > 0) {
                this.setNumber(maxBlockNumber);
                if (null != this.getBlockNotifyCallBack()) {
                    if (null == this.getThreadPool()) {
                        this.getBlockNotifyCallBack().onBlockNotify(this.getGroupId(), maxBlockNumber);
                    } else {
                        final BigInteger maxBlkNumber = maxBlockNumber;
                        this.getThreadPool().execute(new Runnable(){

                            @Override
                            public void run() {
                                Service.this.getBlockNotifyCallBack().onBlockNotify(Service.this.getGroupId(), maxBlkNumber);
                            }
                        });
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("Block notify error", (Throwable)e);
        }
    }

    public void sendHeartbeatMessage(ChannelHandlerContext ctx) {
        BcosMessage message = new BcosMessage();
        message.setSeq(UUID.randomUUID().toString().replaceAll("-", ""));
        message.setResult(0);
        message.setType((short)ChannelMessageType.CLIENT_HEARTBEAT.getType());
        HeartBeatParser heartBeatParser = new HeartBeatParser(ChannelHandlerContextHelper.getProtocolVersion(ctx));
        try {
            message.setData(heartBeatParser.encode("0"));
        }
        catch (JsonProcessingException e) {
            logger.error(" write json failed, message: {}", (Object)e.getMessage());
            return;
        }
        ByteBuf out = ctx.alloc().buffer();
        message.writeHeader(out);
        ((Message)message).writeExtra(out);
        ctx.writeAndFlush((Object)out);
    }

    public void onReceiveHeartbeat(ChannelHandlerContext ctx, Message msg) {
        String content = "";
        HeartBeatParser heartBeatParser = new HeartBeatParser(ChannelHandlerContextHelper.getProtocolVersion(ctx));
        String data = new String(msg.getData());
        try {
            BcosHeartbeat bcosHeartbeat = heartBeatParser.decode(data);
            int heartBeat = bcosHeartbeat.getHeartBeat();
            content = String.valueOf(heartBeat);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("heartbeat packet cannot be parsed, data: {}", (Object)data);
        }
        catch (Exception e) {
            logger.error("heartbeat packet exception, data: {}", (Object)data);
        }
        if ("0".equals(content)) {
            logger.trace("heartbeat packet\uff0csend heartbeat packet back");
            Message response = new Message();
            response.setSeq(msg.getSeq());
            response.setResult(0);
            response.setType((short)ChannelMessageType.CLIENT_HEARTBEAT.getType());
            try {
                response.setData(heartBeatParser.encode("1"));
            }
            catch (JsonProcessingException e) {
                logger.error(" write json failed, message is {} ", (Object)e.getMessage());
                return;
            }
            ByteBuf out = ctx.alloc().buffer();
            response.writeHeader(out);
            response.writeExtra(out);
            ctx.writeAndFlush((Object)out);
        } else if ("1".equals(content)) {
            logger.trace("heartbeat response");
        } else {
            logger.trace(" unknown heartbeat message , do nothing, data: {}", (Object)data);
        }
    }

    public void onReceiveTransactionMessage(ChannelHandlerContext ctx, BcosMessage message) {
        TransactionReceipt receipt = null;
        try {
            receipt = (TransactionReceipt)ObjectMapperFactory.getObjectMapper().readValue(message.getData(), TransactionReceipt.class);
        }
        catch (Exception e) {
            receipt = new TransactionReceipt();
            receipt.setStatus(String.valueOf(ChannelMessageError.MESSAGE_DECODE_ERROR.getError()));
            receipt.setMessage("Decode receipt error: " + e.getLocalizedMessage());
        }
        this.onReceiveTransactionMessage(message.getSeq(), receipt);
    }

    public void onReceiveTransactionMessage(String seq, TransactionReceipt receipt) {
        TransactionSucCallback callback = (TransactionSucCallback)this.seq2TransactionCallback.get(seq);
        if (callback != null) {
            if (callback.getTimeout() != null) {
                callback.getTimeout().cancel();
            }
            try {
                callback.onResponse(receipt);
            }
            catch (Exception e) {
                logger.error("Error process transactionMessage: ", (Throwable)e);
            }
            this.seq2TransactionCallback.remove(seq);
        } else {
            logger.trace(" transaction call back null, seq: {}", (Object)seq);
        }
    }

    public String newSeq() {
        String seq = UUID.randomUUID().toString().replaceAll("-", "");
        logger.debug("New Seq\uff1a{}", (Object)seq);
        return seq;
    }

    public Map<String, Object> getSeq2Callback() {
        return this.seq2Callback;
    }

    public void setSeq2Callback(Map<String, Object> seq2Callback) {
        this.seq2Callback = seq2Callback;
    }

    public ThreadPoolTaskExecutor getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(ThreadPoolTaskExecutor threadPool) {
        this.threadPool = threadPool;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public void setGroupId(int groupId) {
        this.groupId = groupId;
    }

    public BigInteger getNumber() {
        return this.number;
    }

    public void setNumber(BigInteger number) {
        this.number = number;
    }

    public EventLogFilterManager getEventLogFilterManager() {
        return this.eventLogFilterManager;
    }

    public void setEventLogFilterManager(EventLogFilterManager eventLogFilterManager) {
        this.eventLogFilterManager = eventLogFilterManager;
    }

    public Timer getTimeoutHandler() {
        return this.timeoutHandler;
    }

    public void setTimeoutHandler(Timer timeoutHandler) {
        this.timeoutHandler = timeoutHandler;
    }
}

