/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.channel.dto;

import io.netty.buffer.ByteBuf;
import org.fisco.bcos.channel.handler.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelMessage
extends Message {
    private static Logger logger = LoggerFactory.getLogger(ChannelMessage.class);
    private static final long serialVersionUID = -7276897518418560354L;
    private String toNode;
    private String fromNode;

    public ChannelMessage() {
    }

    public ChannelMessage(Message msg) {
        this.length = msg.getLength();
        this.type = msg.getType();
        this.seq = msg.getSeq();
        this.result = msg.getResult();
    }

    @Override
    public void readExtra(ByteBuf in) {
        logger.debug("readExtra channel package: {}", (Object)this.result);
        if (this.result == 0) {
            byte[] toNodeBytes = new byte[128];
            in.readBytes(toNodeBytes, 0, 128);
            this.toNode = new String(toNodeBytes);
            logger.debug("toNode: {}", (Object)this.toNode);
            byte[] fromNodeBytes = new byte[128];
            in.readBytes(fromNodeBytes, 0, 128);
            this.fromNode = new String(fromNodeBytes);
            logger.debug("fromNode: {}", (Object)this.fromNode);
            this.data = new byte[this.length - 42 - 128 - 128];
            in.readBytes(this.data, 0, this.length - 42 - 128 - 128);
            logger.debug("data: {} {}", (Object)this.data.length, (Object)this.data);
        }
    }

    @Override
    public void writeHeader(ByteBuf out) {
        this.length = 42 + this.toNode.length() + this.fromNode.length() + this.data.length;
        super.writeHeader(out);
    }

    @Override
    public void writeExtra(ByteBuf out) {
        out.writeBytes(this.toNode.getBytes());
        out.writeBytes(this.fromNode.getBytes());
        out.writeBytes(this.data);
    }

    public String getToNode() {
        return this.toNode;
    }

    public void setToNode(String toNode) {
        this.toNode = toNode;
    }

    public String getFromNode() {
        return this.fromNode;
    }

    public void setFromNode(String fromNode) {
        this.fromNode = fromNode;
    }
}

