/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.channel.event.filter;

import java.math.BigInteger;
import java.util.List;
import org.fisco.bcos.web3j.crypto.WalletUtils;
import org.fisco.bcos.web3j.protocol.core.DefaultBlockParameterName;
import org.fisco.bcos.web3j.utils.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventLogUserParams {
    private static Logger logger = LoggerFactory.getLogger(EventLogUserParams.class);
    private String fromBlock;
    private String toBlock;
    private List<String> addresses;
    private List<Object> topics;

    public String getFromBlock() {
        return this.fromBlock;
    }

    public void setFromBlock(String fromBlock) {
        this.fromBlock = fromBlock;
    }

    public String getToBlock() {
        return this.toBlock;
    }

    public void setToBlock(String toBlock) {
        this.toBlock = toBlock;
    }

    public List<String> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<String> addresses) {
        this.addresses = addresses;
    }

    public List<Object> getTopics() {
        return this.topics;
    }

    public String toString() {
        return "EventLogFilterParams [fromBlock=" + this.fromBlock + ", toBlock=" + this.toBlock + ", addresses=" + this.addresses + ", topics=" + this.topics + "]";
    }

    public void setTopics(List<Object> topics) {
        this.topics = topics;
    }

    private boolean validAddresses() {
        if (this.getAddresses() == null) {
            return false;
        }
        for (String address : this.getAddresses()) {
            if (WalletUtils.isValidAddress(address)) continue;
            return false;
        }
        return true;
    }

    private boolean validTopics() {
        if (this.getTopics() == null || this.getTopics().size() > 4) {
            return false;
        }
        for (Object topic : this.getTopics()) {
            if (topic instanceof String) {
                if (!((String)topic).isEmpty()) continue;
                return false;
            }
            if (topic instanceof List) {
                for (Object o : (List)topic) {
                    if (!((String)o).isEmpty()) continue;
                    return false;
                }
                continue;
            }
            return false;
        }
        return true;
    }

    private boolean validToBlock(BigInteger blockNumber) {
        BigInteger toBlock = new BigInteger(this.getToBlock());
        return blockNumber.compareTo(BigInteger.ONE) <= 0 || blockNumber.compareTo(BigInteger.ONE) > 0 && toBlock.compareTo(blockNumber) > 0;
    }

    private boolean validFromBlock(BigInteger blockNumber) {
        BigInteger fromBlock = new BigInteger(this.getFromBlock());
        if (fromBlock.compareTo(BigInteger.ZERO) <= 0) {
            return false;
        }
        if (blockNumber.compareTo(BigInteger.ONE) > 0 && fromBlock.compareTo(blockNumber) > 0) {
            logger.info(" future block range request, from: {}, to: {}", (Object)this.getFromBlock(), (Object)this.getToBlock());
        }
        return true;
    }

    private boolean validFromToBlock(BigInteger blockNumber) throws NumberFormatException {
        BigInteger fromBlock = new BigInteger(this.getFromBlock());
        BigInteger toBlock = new BigInteger(this.getToBlock());
        if (fromBlock.compareTo(BigInteger.ZERO) <= 0 || fromBlock.compareTo(toBlock) > 0) {
            return false;
        }
        if (blockNumber.compareTo(BigInteger.ONE) > 0 && fromBlock.compareTo(blockNumber) > 0) {
            logger.info(" future block range request, from: {}, to: {}", (Object)this.getFromBlock(), (Object)this.getToBlock());
        }
        return true;
    }

    private boolean validBlockRange(BigInteger blockNumber) {
        if (Strings.isEmpty(this.getFromBlock()) || Strings.isEmpty(this.getToBlock())) {
            return false;
        }
        boolean isValidBlockRange = true;
        try {
            if (this.getFromBlock().equals(DefaultBlockParameterName.LATEST.getValue()) && !this.getToBlock().equals(DefaultBlockParameterName.LATEST.getValue())) {
                isValidBlockRange = this.validToBlock(blockNumber);
            } else if (!this.getFromBlock().equals(DefaultBlockParameterName.LATEST.getValue()) && this.getToBlock().equals(DefaultBlockParameterName.LATEST.getValue())) {
                isValidBlockRange = this.validFromBlock(blockNumber);
            } else if (!this.getFromBlock().equals(DefaultBlockParameterName.LATEST.getValue()) && !this.getToBlock().equals(DefaultBlockParameterName.LATEST.getValue())) {
                isValidBlockRange = this.validFromToBlock(blockNumber);
            }
        }
        catch (Exception e) {
            isValidBlockRange = false;
        }
        return isValidBlockRange;
    }

    public boolean checkParams(BigInteger blockNumber) {
        return this.validBlockRange(blockNumber) && this.validAddresses() && this.validTopics();
    }
}

