/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.channel.handler;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.timeout.IdleStateEvent;
import java.util.concurrent.RejectedExecutionException;
import org.fisco.bcos.channel.handler.ChannelConnections;
import org.fisco.bcos.channel.handler.ConnectionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class ChannelHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private static Logger logger = LoggerFactory.getLogger(ChannelHandler.class);
    private ChannelConnections connections;
    private Boolean isServer = false;
    private ThreadPoolTaskExecutor threadPool;

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        String host = ((SocketChannel)ctx.channel()).remoteAddress().getAddress().getHostAddress();
        Integer port = ((SocketChannel)ctx.channel()).remoteAddress().getPort();
        if (evt instanceof IdleStateEvent) {
            IdleStateEvent e = (IdleStateEvent)evt;
            switch (e.state()) {
                case READER_IDLE: 
                case WRITER_IDLE: 
                case ALL_IDLE: {
                    logger.error("event:{} connect{}:{} long time Inactive\uff0cdisconnect", new Object[]{e.state(), host, port});
                    this.channelInactive(ctx);
                    ctx.disconnect();
                    ctx.close();
                    break;
                }
            }
        }
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        try {
            String host = ((SocketChannel)ctx.channel()).remoteAddress().getAddress().getHostAddress();
            Integer port = ((SocketChannel)ctx.channel()).remoteAddress().getPort();
            logger.debug("success,connected[" + host + "]:[" + String.valueOf(port) + "]," + String.valueOf(ctx.channel().isActive()));
            if (this.isServer.booleanValue()) {
                logger.debug("server accept new connect: {}:{}", (Object)host, (Object)port);
                ConnectionInfo info = new ConnectionInfo();
                info.setHost(host);
                info.setPort(port);
                this.connections.getConnections().add(info);
                this.connections.setNetworkConnectionByHost(info.getHost(), info.getPort(), ctx);
                this.connections.getCallback().onConnect(ctx);
            } else {
                ChannelHandlerContext connection = this.connections.getNetworkConnectionByHost(host, port);
                if (connection != null && connection.channel().isActive()) {
                    logger.debug("connect available, close reconnect: {}:{}", (Object)host, (Object)port);
                    ctx.channel().disconnect();
                    ctx.channel().close();
                } else {
                    logger.debug("client connect success {}:{}", (Object)host, (Object)port);
                    this.connections.setNetworkConnectionByHost(host, port, ctx);
                    this.connections.getCallback().onConnect(ctx);
                }
            }
        }
        catch (Exception e) {
            logger.error("error", (Throwable)e);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        try {
            logger.debug("disconnect");
            String host = ((SocketChannel)ctx.channel()).remoteAddress().getAddress().getHostAddress();
            Integer port = ((SocketChannel)ctx.channel()).remoteAddress().getPort();
            logger.debug("disconnect " + host + ":" + String.valueOf(port) + " ," + String.valueOf(ctx.channel().isActive()));
            if (this.isServer.booleanValue()) {
                Integer i = 0;
                while (i < this.connections.getConnections().size()) {
                    ConnectionInfo info = this.connections.getConnections().get(i);
                    if (info.getHost().equals(host) && info.getPort().equals(port)) {
                        this.connections.getConnections().remove(i);
                    }
                    i = i + 1;
                }
                this.connections.removeNetworkConnectionByHost(host, port);
            }
            this.connections.getCallback().onDisconnect(ctx);
        }
        catch (Exception e) {
            logger.error("error ", (Throwable)e);
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        final ChannelHandlerContext ctxF = ctx;
        final ByteBuf in = (ByteBuf)msg;
        try {
            if (this.threadPool == null) {
                this.connections.onReceiveMessage(ctx, in);
            } else {
                this.threadPool.execute(new Runnable(){

                    @Override
                    public void run() {
                        ChannelHandler.this.connections.onReceiveMessage(ctxF, in);
                    }
                });
            }
        }
        catch (RejectedExecutionException e) {
            logger.error("threadPool is full, reject to request", (Throwable)e);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        logger.error("network error ", cause);
        String host = ((SocketChannel)ctx.channel()).remoteAddress().getAddress().getHostAddress();
        Integer port = ((SocketChannel)ctx.channel()).remoteAddress().getPort();
        logger.debug("disconnect " + host + ":" + String.valueOf(port) + " ," + String.valueOf(ctx.channel().isActive()));
        if (this.isServer.booleanValue()) {
            this.connections.removeNetworkConnectionByHost(host, port);
        }
        ctx.disconnect();
        ctx.close();
    }

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
        this.channelRead(ctx, in);
    }

    public void checkAvailable(ChannelHandlerContext ctx) {
    }

    public ChannelConnections getConnections() {
        return this.connections;
    }

    public void setConnections(ChannelConnections connections) {
        this.connections = connections;
    }

    public Boolean getIsServer() {
        return this.isServer;
    }

    public void setIsServer(Boolean isServer) {
        this.isServer = isServer;
    }

    public ThreadPoolTaskExecutor getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(ThreadPoolTaskExecutor threadPool) {
        this.threadPool = threadPool;
        logger.debug("set threadPool:{}", (Object)(threadPool == null ? 1 : 0));
    }
}

