/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.channel.proxy;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.security.SecureRandom;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.fisco.bcos.channel.dto.ChannelResponse;
import org.fisco.bcos.channel.handler.ChannelConnections;
import org.fisco.bcos.channel.handler.ConnectionInfo;
import org.fisco.bcos.channel.handler.Message;
import org.fisco.bcos.channel.protocol.ChannelMessageError;
import org.fisco.bcos.channel.protocol.ChannelMessageType;
import org.fisco.bcos.channel.proxy.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConnectionPair {
    private static Logger logger = LoggerFactory.getLogger(ConnectionPair.class);
    public ChannelHandlerContext localConnection;
    public ChannelHandlerContext remoteConnection;
    public Timeout timeout;
    private Message message;
    private ConnectionInfo remoteConnectionInfo;
    private List<ConnectionInfo> remoteConnectionInfos;
    private ChannelConnections remoteChannelConnections;
    private Server server;

    ConnectionPair() {
    }

    public Message getMessage() {
        return this.message;
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    public ConnectionInfo getRemoteConnectionInfo() {
        return this.remoteConnectionInfo;
    }

    public void setRemoteConnectionInfo(ConnectionInfo remoteConnectionInfo) {
        this.remoteConnectionInfo = remoteConnectionInfo;
    }

    public List<ConnectionInfo> getRemoteConnectionInfos() {
        return this.remoteConnectionInfos;
    }

    public void setRemoteConnectionInfos(List<ConnectionInfo> remoteConnectionInfos) {
        this.remoteConnectionInfos = remoteConnectionInfos;
    }

    public ChannelConnections getRemoteChannelConnections() {
        return this.remoteChannelConnections;
    }

    public void setRemoteChannelConnections(ChannelConnections remoteChannelConnections) {
        this.remoteChannelConnections = remoteChannelConnections;
    }

    public Server getServer() {
        return this.server;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public void init() {
        final ConnectionPair self = this;
        final String seq = this.message.getSeq();
        this.timeout = this.server.getTimeoutHandler().newTimeout(new TimerTask(){
            private ConnectionPair selfServer;
            private String selfSeq;
            {
                this.selfServer = self;
                this.selfSeq = seq;
            }

            public void run(Timeout timeout) throws Exception {
                logger.trace("clean timeout session:{}", (Object)this.selfSeq);
                this.selfServer.server.getSeq2Connections().remove(this.selfSeq);
            }
        }, 30000L, TimeUnit.MILLISECONDS);
    }

    public void retrySendRemoteMessage() {
        Integer errorCode = 0;
        try {
            ChannelHandlerContext ctx;
            logger.debug("remoteConnection size :{}", (Object)this.remoteConnectionInfos.size());
            this.remoteConnectionInfo = null;
            if (this.remoteConnectionInfos.size() > 0) {
                SecureRandom random = new SecureRandom();
                Integer index = random.nextInt(this.remoteConnectionInfos.size());
                logger.debug("selected:{}", (Object)index);
                this.remoteConnectionInfo = this.remoteConnectionInfos.get(index);
                this.remoteConnectionInfos.remove(this.remoteConnectionInfos.get(index));
            }
            if (this.remoteConnectionInfo == null) {
                logger.error("remoteConnectionInfo null");
                errorCode = ChannelMessageError.NODES_UNREACHABLE.getError();
                throw new Exception("remoteConnectionInfo null");
            }
            this.remoteConnection = ctx = this.remoteChannelConnections.getNetworkConnectionByHost(this.remoteConnectionInfo.getHost(), this.remoteConnectionInfo.getPort());
            if (ctx != null && ctx.channel().isActive()) {
                ByteBuf out = ctx.alloc().buffer();
                this.message.writeHeader(out);
                this.message.writeExtra(out);
                ctx.writeAndFlush((Object)out);
                logger.debug("send message to  " + this.remoteConnectionInfo.getHost() + ":" + String.valueOf(this.remoteConnectionInfo.getPort()) + " success");
            } else {
                logger.error("local node inactive");
                this.retrySendRemoteMessage();
            }
        }
        catch (Exception e) {
            logger.error("send message error", (Throwable)e);
            ChannelResponse response = new ChannelResponse();
            response.setErrorCode(errorCode);
            response.setErrorMessage(e.getMessage());
            logger.error("connection error 99");
            if (this.message.getType() == (short)ChannelMessageType.AMOP_REQUEST.getType() || this.message.getType().shortValue() == ChannelMessageType.AMOP_RESPONSE.getType()) {
                this.message.setType((short)ChannelMessageType.AMOP_RESPONSE.getType());
            }
            this.message.setResult(ChannelMessageError.NODES_UNREACHABLE.getError());
            ByteBuf out = this.localConnection.alloc().buffer();
            this.message.writeHeader(out);
            this.message.writeExtra(out);
            this.localConnection.writeAndFlush((Object)out);
            if (this.message.getSeq() != null) {
                this.server.getSeq2Connections().remove(this.message.getSeq());
            }
            if (this.timeout != null) {
                this.timeout.cancel();
            }
            return;
        }
    }
}

