/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.abi.datatypes;

import org.fisco.bcos.web3j.abi.datatypes.BytesType;

public class Bytes
extends BytesType {
    public static final String TYPE_NAME = "bytes";

    protected Bytes(int byteSize, byte[] value) {
        super(value, TYPE_NAME + value.length);
        if (!this.isValid(byteSize, value)) {
            throw new UnsupportedOperationException("Input byte array must be in range 0 < M <= 32 and length must match type");
        }
    }

    private boolean isValid(int byteSize, byte[] value) {
        int length = value.length;
        return length > 0 && length <= 32 && length == byteSize;
    }

    @Override
    public boolean dynamicType() {
        return false;
    }

    @Override
    public int offset() {
        return 1;
    }
}

