/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.codegen;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import io.reactivex.Flowable;
import io.reactivex.functions.Function;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Modifier;
import org.fisco.bcos.web3j.abi.EventEncoder;
import org.fisco.bcos.web3j.abi.FunctionEncoder;
import org.fisco.bcos.web3j.abi.TypeReference;
import org.fisco.bcos.web3j.abi.datatypes.Address;
import org.fisco.bcos.web3j.abi.datatypes.Bool;
import org.fisco.bcos.web3j.abi.datatypes.DynamicArray;
import org.fisco.bcos.web3j.abi.datatypes.DynamicBytes;
import org.fisco.bcos.web3j.abi.datatypes.Event;
import org.fisco.bcos.web3j.abi.datatypes.StaticArray;
import org.fisco.bcos.web3j.abi.datatypes.Utf8String;
import org.fisco.bcos.web3j.abi.datatypes.generated.AbiTypes;
import org.fisco.bcos.web3j.codegen.GenerationReporter;
import org.fisco.bcos.web3j.codegen.Generator;
import org.fisco.bcos.web3j.codegen.LogGenerationReporter;
import org.fisco.bcos.web3j.codegen.SolidityFunctionWrapperGenerator;
import org.fisco.bcos.web3j.crypto.Credentials;
import org.fisco.bcos.web3j.protocol.ObjectMapperFactory;
import org.fisco.bcos.web3j.protocol.Web3j;
import org.fisco.bcos.web3j.protocol.core.RemoteCall;
import org.fisco.bcos.web3j.protocol.core.methods.request.BcosFilter;
import org.fisco.bcos.web3j.protocol.core.methods.response.AbiDefinition;
import org.fisco.bcos.web3j.protocol.core.methods.response.Log;
import org.fisco.bcos.web3j.protocol.core.methods.response.TransactionReceipt;
import org.fisco.bcos.web3j.tx.Contract;
import org.fisco.bcos.web3j.tx.TransactionManager;
import org.fisco.bcos.web3j.tx.gas.ContractGasProvider;
import org.fisco.bcos.web3j.utils.Collection;
import org.fisco.bcos.web3j.utils.Strings;
import org.fisco.bcos.web3j.utils.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolidityFunctionWrapper
extends Generator {
    private static final int maxSolidityBinSize = 262144;
    private static final String BINARY = "BINARY";
    private static final String WEB3J = "web3j";
    private static final String CREDENTIALS = "credentials";
    private static final String CONTRACT_GAS_PROVIDER = "contractGasProvider";
    private static final String TRANSACTION_MANAGER = "transactionManager";
    private static final String INITIAL_VALUE = "initialWeiValue";
    private static final String CONTRACT_ADDRESS = "contractAddress";
    private static final String GAS_PRICE = "gasPrice";
    private static final String GAS_LIMIT = "gasLimit";
    private static final String FILTER = "filter";
    private static final String FROM_BLOCK = "fromBlock";
    private static final String TO_BLOCK = "toBlock";
    private static final String WEI_VALUE = "weiValue";
    private static final String CALLBACK_VALUE = "callback";
    private static final String OTHER_TOPICS = "otherTopcs";
    private static final String FUNC_NAME_PREFIX = "FUNC_";
    private String abiContent;
    private static final ClassName LOG = ClassName.get(Log.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(SolidityFunctionWrapper.class);
    private static final String CODEGEN_WARNING = "<p>Auto generated code.\n<p><strong>Do not modify!</strong>\n<p>Please use the <a href=\"https://docs.web3j.io/command_line.html\">web3j command line tools</a>,\nor the " + SolidityFunctionWrapperGenerator.class.getName() + " in the \n<a href=\"https://github.com/web3j/web3j/tree/master/codegen\">codegen module</a> to update.\n";
    private final boolean useNativeJavaTypes;
    private static final String regex = "(\\w+)(?:\\[(.*?)\\])(?:\\[(.*?)\\])?";
    private static final Pattern pattern = Pattern.compile("(\\w+)(?:\\[(.*?)\\])(?:\\[(.*?)\\])?");
    private final GenerationReporter reporter;

    public SolidityFunctionWrapper(boolean useNativeJavaTypes) {
        this(useNativeJavaTypes, new LogGenerationReporter(LOGGER));
    }

    SolidityFunctionWrapper(boolean useNativeJavaTypes, GenerationReporter reporter) {
        this.useNativeJavaTypes = useNativeJavaTypes;
        this.reporter = reporter;
    }

    public void generateJavaFiles(String contractName, String bin, String abi, String destinationDir, String basePackageName) throws IOException, ClassNotFoundException {
        this.abiContent = abi;
        this.generateJavaFiles(contractName, bin, this.loadContractDefinition(abi), destinationDir, basePackageName, null);
    }

    void generateJavaFiles(String contractName, String bin, List<AbiDefinition> abi, String destinationDir, String basePackageName, Map<String, String> addresses) throws IOException, ClassNotFoundException, UnsupportedOperationException {
        String className = Strings.capitaliseFirstLetter(contractName);
        if (bin.length() > 262144) {
            throw new UnsupportedOperationException(" contract binary too long, max support is 256k, now is " + Integer.valueOf(bin.length()));
        }
        TypeSpec.Builder classBuilder = this.createClassBuilder(className, bin, abi);
        classBuilder.addMethod(SolidityFunctionWrapper.buildConstructor(Credentials.class, CREDENTIALS, false));
        classBuilder.addMethod(SolidityFunctionWrapper.buildConstructor(Credentials.class, CREDENTIALS, true));
        classBuilder.addMethod(SolidityFunctionWrapper.buildConstructor(TransactionManager.class, TRANSACTION_MANAGER, false));
        classBuilder.addMethod(SolidityFunctionWrapper.buildConstructor(TransactionManager.class, TRANSACTION_MANAGER, true));
        classBuilder.addFields(this.buildFuncNameConstants(abi));
        classBuilder.addMethods(this.buildFunctionDefinitions(className, classBuilder, abi));
        classBuilder.addMethod(SolidityFunctionWrapper.buildLoad(className, Credentials.class, CREDENTIALS, false));
        classBuilder.addMethod(SolidityFunctionWrapper.buildLoad(className, TransactionManager.class, TRANSACTION_MANAGER, false));
        classBuilder.addMethod(SolidityFunctionWrapper.buildLoad(className, Credentials.class, CREDENTIALS, true));
        classBuilder.addMethod(SolidityFunctionWrapper.buildLoad(className, TransactionManager.class, TRANSACTION_MANAGER, true));
        if (!bin.equals("Bin file was not provided")) {
            classBuilder.addMethods(this.buildDeployMethods(className, classBuilder, abi));
        }
        this.addAddressesSupport(classBuilder, addresses);
        this.write(basePackageName, classBuilder.build(), destinationDir);
    }

    private void addAddressesSupport(TypeSpec.Builder classBuilder, Map<String, String> addresses) {
        if (addresses != null) {
            ClassName stringType = ClassName.get(String.class);
            ClassName mapType = ClassName.get(HashMap.class);
            ParameterizedTypeName mapStringString = ParameterizedTypeName.get((ClassName)mapType, (TypeName[])new TypeName[]{stringType, stringType});
            FieldSpec addressesStaticField = FieldSpec.builder((TypeName)mapStringString, (String)"_addresses", (Modifier[])new Modifier[]{Modifier.PROTECTED, Modifier.STATIC, Modifier.FINAL}).build();
            classBuilder.addField(addressesStaticField);
            CodeBlock.Builder staticInit = CodeBlock.builder();
            staticInit.addStatement("_addresses = new HashMap<String, String>()", new Object[0]);
            addresses.forEach((k, v) -> staticInit.addStatement(String.format("_addresses.put(\"%1s\", \"%2s\")", k, v), new Object[0]));
            classBuilder.addStaticBlock(staticInit.build());
            MethodSpec getAddress = MethodSpec.methodBuilder((String)"getStaticDeployedAddress").addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)stringType).addParameter((TypeName)stringType, "networkId", new Modifier[0]).addCode(CodeBlock.builder().addStatement("return _addresses.get(networkId)", new Object[0]).build()).build();
            classBuilder.addMethod(getAddress);
            MethodSpec getPreviousAddress = MethodSpec.methodBuilder((String)"getPreviouslyDeployedAddress").addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.STATIC}).returns((TypeName)stringType).addParameter((TypeName)stringType, "networkId", new Modifier[0]).addCode(CodeBlock.builder().addStatement("return _addresses.get(networkId)", new Object[0]).build()).build();
            classBuilder.addMethod(getPreviousAddress);
        }
    }

    private TypeSpec.Builder createClassBuilder(String className, String binary, List<AbiDefinition> abi) {
        String javadoc = CODEGEN_WARNING + this.getWeb3jVersion();
        return TypeSpec.classBuilder((String)className).addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc(javadoc, new Object[0]).superclass(Contract.class).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"unchecked"}).build()).addField(this.createBinaryDefinition(binary)).addField(this.createABIDefinition(abi));
    }

    private String getWeb3jVersion() {
        String version;
        try {
            version = Version.getVersion();
        }
        catch (IOException | NullPointerException e) {
            version = "none";
        }
        return "\n<p>Generated with web3j version " + version + ".\n";
    }

    private FieldSpec createBinaryDefinition(String binary) {
        return FieldSpec.builder(String.class, (String)BINARY, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).initializer("$S", new Object[]{binary}).build();
    }

    private FieldSpec createABIDefinition(List<AbiDefinition> abi) {
        return FieldSpec.builder(String.class, (String)"ABI", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL, Modifier.STATIC}).initializer("$S", new Object[]{this.abiContent}).build();
    }

    private FieldSpec createEventDefinition(String name, List<NamedTypeName> parameters) {
        CodeBlock initializer = SolidityFunctionWrapper.buildVariableLengthEventInitializer(name, parameters);
        return FieldSpec.builder(Event.class, (String)this.buildEventDefinitionName(name), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer(initializer).build();
    }

    private String buildEventDefinitionName(String eventName) {
        return eventName.toUpperCase() + "_EVENT";
    }

    private List<MethodSpec> buildFunctionDefinitions(String className, TypeSpec.Builder classBuilder, List<AbiDefinition> functionDefinitions) throws ClassNotFoundException {
        ArrayList<MethodSpec> methodSpecs = new ArrayList<MethodSpec>();
        for (AbiDefinition functionDefinition : functionDefinitions) {
            if (functionDefinition.getType().equals("function")) {
                MethodSpec ms = this.buildFunction(functionDefinition);
                methodSpecs.add(ms);
                if (functionDefinition.isConstant()) continue;
                MethodSpec msCallback = this.buildFunctionWithCallback(functionDefinition);
                methodSpecs.add(msCallback);
                MethodSpec msSeq = this.buildFunctionSeq(functionDefinition);
                methodSpecs.add(msSeq);
                continue;
            }
            if (!functionDefinition.getType().equals("event")) continue;
            methodSpecs.addAll(this.buildEventFunctions(functionDefinition, classBuilder));
        }
        return methodSpecs;
    }

    List<MethodSpec> buildDeployMethods(String className, TypeSpec.Builder classBuilder, List<AbiDefinition> functionDefinitions) {
        boolean constructor = false;
        ArrayList<MethodSpec> methodSpecs = new ArrayList<MethodSpec>();
        for (AbiDefinition functionDefinition : functionDefinitions) {
            if (!functionDefinition.getType().equals("constructor")) continue;
            constructor = true;
            methodSpecs.add(this.buildDeploy(className, functionDefinition, Credentials.class, CREDENTIALS, true));
            methodSpecs.add(this.buildDeploy(className, functionDefinition, TransactionManager.class, TRANSACTION_MANAGER, true));
            methodSpecs.add(this.buildDeploy(className, functionDefinition, Credentials.class, CREDENTIALS, false));
            methodSpecs.add(this.buildDeploy(className, functionDefinition, TransactionManager.class, TRANSACTION_MANAGER, false));
        }
        if (!constructor) {
            MethodSpec.Builder credentialsMethodBuilder = SolidityFunctionWrapper.getDeployMethodSpec(className, Credentials.class, CREDENTIALS, false, true);
            methodSpecs.add(SolidityFunctionWrapper.buildDeployNoParams(credentialsMethodBuilder, className, CREDENTIALS, false, true));
            MethodSpec.Builder credentialsMethodBuilderNoGasProvider = SolidityFunctionWrapper.getDeployMethodSpec(className, Credentials.class, CREDENTIALS, false, false);
            methodSpecs.add(SolidityFunctionWrapper.buildDeployNoParams(credentialsMethodBuilderNoGasProvider, className, CREDENTIALS, false, false));
            MethodSpec.Builder transactionManagerMethodBuilder = SolidityFunctionWrapper.getDeployMethodSpec(className, TransactionManager.class, TRANSACTION_MANAGER, false, true);
            methodSpecs.add(SolidityFunctionWrapper.buildDeployNoParams(transactionManagerMethodBuilder, className, TRANSACTION_MANAGER, false, true));
            MethodSpec.Builder transactionManagerMethodBuilderNoGasProvider = SolidityFunctionWrapper.getDeployMethodSpec(className, TransactionManager.class, TRANSACTION_MANAGER, false, false);
            methodSpecs.add(SolidityFunctionWrapper.buildDeployNoParams(transactionManagerMethodBuilderNoGasProvider, className, TRANSACTION_MANAGER, false, false));
        }
        return methodSpecs;
    }

    Iterable<FieldSpec> buildFuncNameConstants(List<AbiDefinition> functionDefinitions) {
        ArrayList<FieldSpec> fields = new ArrayList<FieldSpec>();
        HashSet<String> fieldNames = new HashSet<String>();
        fieldNames.add("deploy");
        for (AbiDefinition functionDefinition : functionDefinitions) {
            String funcName;
            if (!functionDefinition.getType().equals("function") || fieldNames.contains(funcName = functionDefinition.getName())) continue;
            FieldSpec field = FieldSpec.builder(String.class, (String)SolidityFunctionWrapper.funcNameToConst(funcName), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{funcName}).build();
            fields.add(field);
            fieldNames.add(funcName);
        }
        return fields;
    }

    private static MethodSpec buildConstructor(Class authType, String authName, boolean withGasProvider) {
        MethodSpec.Builder toReturn = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter(String.class, CONTRACT_ADDRESS, new Modifier[0]).addParameter(Web3j.class, WEB3J, new Modifier[0]).addParameter((Type)authType, authName, new Modifier[0]);
        if (withGasProvider) {
            toReturn.addParameter(ContractGasProvider.class, CONTRACT_GAS_PROVIDER, new Modifier[0]).addStatement("super($N, $N, $N, $N, $N)", new Object[]{BINARY, CONTRACT_ADDRESS, WEB3J, authName, CONTRACT_GAS_PROVIDER});
        } else {
            toReturn.addParameter(BigInteger.class, GAS_PRICE, new Modifier[0]).addParameter(BigInteger.class, GAS_LIMIT, new Modifier[0]).addStatement("super($N, $N, $N, $N, $N, $N)", new Object[]{BINARY, CONTRACT_ADDRESS, WEB3J, authName, GAS_PRICE, GAS_LIMIT}).addAnnotation(Deprecated.class);
        }
        return toReturn.build();
    }

    private MethodSpec buildDeploy(String className, AbiDefinition functionDefinition, Class authType, String authName, boolean withGasProvider) {
        boolean isPayable = functionDefinition.isPayable();
        MethodSpec.Builder methodBuilder = SolidityFunctionWrapper.getDeployMethodSpec(className, authType, authName, isPayable, withGasProvider);
        String inputParams = this.addParameters(methodBuilder, functionDefinition.getInputs());
        if (!inputParams.isEmpty()) {
            return SolidityFunctionWrapper.buildDeployWithParams(methodBuilder, className, inputParams, authName, isPayable, withGasProvider);
        }
        return SolidityFunctionWrapper.buildDeployNoParams(methodBuilder, className, authName, isPayable, withGasProvider);
    }

    private static MethodSpec buildDeployWithParams(MethodSpec.Builder methodBuilder, String className, String inputParams, String authName, boolean isPayable, boolean withGasProvider) {
        methodBuilder.addStatement("$T encodedConstructor = $T.encodeConstructor($T.<$T>asList($L))", new Object[]{String.class, FunctionEncoder.class, Arrays.class, org.fisco.bcos.web3j.abi.datatypes.Type.class, inputParams});
        if (isPayable && !withGasProvider) {
            methodBuilder.addStatement("return deployRemoteCall($L.class, $L, $L, $L, $L, $L, encodedConstructor, $L)", new Object[]{className, WEB3J, authName, GAS_PRICE, GAS_LIMIT, BINARY, INITIAL_VALUE});
            methodBuilder.addAnnotation(Deprecated.class);
        } else if (isPayable && withGasProvider) {
            methodBuilder.addStatement("return deployRemoteCall($L.class, $L, $L, $L, $L, encodedConstructor, $L)", new Object[]{className, WEB3J, authName, CONTRACT_GAS_PROVIDER, BINARY, INITIAL_VALUE});
        } else if (!isPayable && !withGasProvider) {
            methodBuilder.addStatement("return deployRemoteCall($L.class, $L, $L, $L, $L, $L, encodedConstructor)", new Object[]{className, WEB3J, authName, GAS_PRICE, GAS_LIMIT, BINARY});
            methodBuilder.addAnnotation(Deprecated.class);
        } else {
            methodBuilder.addStatement("return deployRemoteCall($L.class, $L, $L, $L, $L, encodedConstructor)", new Object[]{className, WEB3J, authName, CONTRACT_GAS_PROVIDER, BINARY});
        }
        return methodBuilder.build();
    }

    private static MethodSpec buildDeployNoParams(MethodSpec.Builder methodBuilder, String className, String authName, boolean isPayable, boolean withGasPRovider) {
        if (isPayable && !withGasPRovider) {
            methodBuilder.addStatement("return deployRemoteCall($L.class, $L, $L, $L, $L, $L, \"\", $L)", new Object[]{className, WEB3J, authName, GAS_PRICE, GAS_LIMIT, BINARY, INITIAL_VALUE});
            methodBuilder.addAnnotation(Deprecated.class);
        } else if (isPayable && withGasPRovider) {
            methodBuilder.addStatement("return deployRemoteCall($L.class, $L, $L, $L, $L, \"\", $L)", new Object[]{className, WEB3J, authName, CONTRACT_GAS_PROVIDER, BINARY, INITIAL_VALUE});
        } else if (!isPayable && !withGasPRovider) {
            methodBuilder.addStatement("return deployRemoteCall($L.class, $L, $L, $L, $L, $L, \"\")", new Object[]{className, WEB3J, authName, GAS_PRICE, GAS_LIMIT, BINARY});
            methodBuilder.addAnnotation(Deprecated.class);
        } else {
            methodBuilder.addStatement("return deployRemoteCall($L.class, $L, $L, $L, $L, \"\")", new Object[]{className, WEB3J, authName, CONTRACT_GAS_PROVIDER, BINARY});
        }
        return methodBuilder.build();
    }

    private static MethodSpec.Builder getDeployMethodSpec(String className, Class authType, String authName, boolean isPayable, boolean withGasProvider) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"deploy").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)SolidityFunctionWrapper.buildRemoteCall((TypeName)TypeVariableName.get((String)className, (Type[])new Type[]{org.fisco.bcos.web3j.abi.datatypes.Type.class}))).addParameter(Web3j.class, WEB3J, new Modifier[0]).addParameter((Type)authType, authName, new Modifier[0]);
        if (isPayable && !withGasProvider) {
            return builder.addParameter(BigInteger.class, GAS_PRICE, new Modifier[0]).addParameter(BigInteger.class, GAS_LIMIT, new Modifier[0]).addParameter(BigInteger.class, INITIAL_VALUE, new Modifier[0]);
        }
        if (isPayable && withGasProvider) {
            return builder.addParameter(ContractGasProvider.class, CONTRACT_GAS_PROVIDER, new Modifier[0]).addParameter(BigInteger.class, INITIAL_VALUE, new Modifier[0]);
        }
        if (!isPayable && withGasProvider) {
            return builder.addParameter(ContractGasProvider.class, CONTRACT_GAS_PROVIDER, new Modifier[0]);
        }
        return builder.addParameter(BigInteger.class, GAS_PRICE, new Modifier[0]).addParameter(BigInteger.class, GAS_LIMIT, new Modifier[0]);
    }

    private static MethodSpec buildLoad(String className, Class authType, String authName, boolean withGasProvider) {
        MethodSpec.Builder toReturn = MethodSpec.methodBuilder((String)"load").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)TypeVariableName.get((String)className, (Type[])new Type[]{org.fisco.bcos.web3j.abi.datatypes.Type.class})).addParameter(String.class, CONTRACT_ADDRESS, new Modifier[0]).addParameter(Web3j.class, WEB3J, new Modifier[0]).addParameter((Type)authType, authName, new Modifier[0]);
        if (withGasProvider) {
            toReturn.addParameter(ContractGasProvider.class, CONTRACT_GAS_PROVIDER, new Modifier[0]).addStatement("return new $L($L, $L, $L, $L)", new Object[]{className, CONTRACT_ADDRESS, WEB3J, authName, CONTRACT_GAS_PROVIDER});
        } else {
            toReturn.addParameter(BigInteger.class, GAS_PRICE, new Modifier[0]).addParameter(BigInteger.class, GAS_LIMIT, new Modifier[0]).addStatement("return new $L($L, $L, $L, $L, $L)", new Object[]{className, CONTRACT_ADDRESS, WEB3J, authName, GAS_PRICE, GAS_LIMIT}).addAnnotation(Deprecated.class);
        }
        return toReturn.build();
    }

    private MethodSpec.Builder addParameter(MethodSpec.Builder methodBuilder, String type, String name) {
        ParameterSpec parameterSpec = this.buildParameterType(type, name);
        TypeName typeName = this.getWrapperType(parameterSpec.type);
        ParameterSpec inputParameter = ParameterSpec.builder((TypeName)typeName, (String)parameterSpec.name, (Modifier[])new Modifier[0]).build();
        methodBuilder.addParameter(inputParameter);
        return methodBuilder;
    }

    private String addParameters(MethodSpec.Builder methodBuilder, List<AbiDefinition.NamedType> namedTypes) {
        List<ParameterSpec> inputParameterTypes = SolidityFunctionWrapper.buildParameterTypes(namedTypes);
        ArrayList<ParameterSpec> nativeInputParameterTypes = new ArrayList<ParameterSpec>(inputParameterTypes.size());
        for (ParameterSpec parameterSpec2 : inputParameterTypes) {
            TypeName typeName = this.getWrapperType(parameterSpec2.type);
            nativeInputParameterTypes.add(ParameterSpec.builder((TypeName)typeName, (String)parameterSpec2.name, (Modifier[])new Modifier[0]).build());
        }
        methodBuilder.addParameters(nativeInputParameterTypes);
        if (this.useNativeJavaTypes) {
            return Collection.join(namedTypes, ", \n", this::createMappedParameterTypes);
        }
        return Collection.join(inputParameterTypes, ", ", parameterSpec -> parameterSpec.name);
    }

    private String createMappedParameterTypes(AbiDefinition.NamedType namedType) {
        String name = namedType.getName();
        String type = namedType.getType();
        AbiDefinition.NamedType.Type innerType = new AbiDefinition.NamedType.Type(type);
        ParameterSpec parameterSpec = ParameterSpec.builder((TypeName)SolidityFunctionWrapper.buildTypeName(type), (String)name, (Modifier[])new Modifier[0]).build();
        if (parameterSpec.type instanceof ParameterizedTypeName) {
            List typeNames = ((ParameterizedTypeName)parameterSpec.type).typeArguments;
            if (typeNames.size() != 1) {
                throw new UnsupportedOperationException("Only a single parameterized type is supported");
            }
            String parameterSpecType = parameterSpec.type.toString();
            TypeName typeName = (TypeName)typeNames.get(0);
            String typeMapInput = typeName + ".class";
            if (typeName instanceof ParameterizedTypeName) {
                List typeArguments = ((ParameterizedTypeName)typeName).typeArguments;
                if (typeArguments.size() != 1) {
                    throw new UnsupportedOperationException("Only a single parameterized type is supported");
                }
                TypeName innerTypeName = (TypeName)typeArguments.get(0);
                parameterSpecType = ((ParameterizedTypeName)parameterSpec.type).rawType.toString();
                typeMapInput = ((ParameterizedTypeName)typeName).rawType + ".class, " + innerTypeName + ".class";
            }
            if (innerType.dynamicArray()) {
                return parameterSpec.name + ".isEmpty()?org.fisco.bcos.web3j.abi.datatypes.DynamicArray.empty(\"" + type + "\"):new " + parameterSpecType + "(\n        org.fisco.bcos.web3j.abi.Utils.typeMap(" + parameterSpec.name + ", " + typeMapInput + "))";
            }
            return "new " + parameterSpecType + "(\n        org.fisco.bcos.web3j.abi.Utils.typeMap(" + parameterSpec.name + ", " + typeMapInput + "))";
        }
        return "new " + parameterSpec.type + "(" + parameterSpec.name + ")";
    }

    private TypeName getWrapperType(TypeName typeName) {
        if (this.useNativeJavaTypes) {
            return SolidityFunctionWrapper.getNativeType(typeName);
        }
        return typeName;
    }

    private TypeName getWrapperRawType(TypeName typeName) {
        if (this.useNativeJavaTypes) {
            if (typeName instanceof ParameterizedTypeName) {
                return ClassName.get(List.class);
            }
            return SolidityFunctionWrapper.getNativeType(typeName);
        }
        return typeName;
    }

    private TypeName getIndexedEventWrapperType(TypeName typeName) {
        if (this.useNativeJavaTypes) {
            return SolidityFunctionWrapper.getEventNativeType(typeName);
        }
        return typeName;
    }

    static TypeName getNativeType(TypeName typeName) {
        if (typeName instanceof ParameterizedTypeName) {
            return SolidityFunctionWrapper.getNativeType((ParameterizedTypeName)typeName);
        }
        String simpleName = ((ClassName)typeName).simpleName();
        if (simpleName.startsWith(Address.class.getSimpleName())) {
            return TypeName.get(String.class);
        }
        if (simpleName.startsWith("Uint")) {
            return TypeName.get(BigInteger.class);
        }
        if (simpleName.startsWith("Int")) {
            return TypeName.get(BigInteger.class);
        }
        if (simpleName.startsWith(Utf8String.class.getSimpleName())) {
            return TypeName.get(String.class);
        }
        if (simpleName.startsWith("Bytes")) {
            return TypeName.get(byte[].class);
        }
        if (simpleName.startsWith(DynamicBytes.class.getSimpleName())) {
            return TypeName.get(byte[].class);
        }
        if (simpleName.startsWith(Bool.class.getSimpleName())) {
            return TypeName.get(Boolean.class);
        }
        throw new UnsupportedOperationException("Unsupported type: " + typeName + ", no native type mapping exists.");
    }

    static TypeName getNativeType(ParameterizedTypeName parameterizedTypeName) {
        List typeNames = parameterizedTypeName.typeArguments;
        ArrayList<TypeName> nativeTypeNames = new ArrayList<TypeName>(typeNames.size());
        for (TypeName enclosedTypeName : typeNames) {
            nativeTypeNames.add(SolidityFunctionWrapper.getNativeType(enclosedTypeName));
        }
        return ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])nativeTypeNames.toArray(new TypeName[nativeTypeNames.size()]));
    }

    static TypeName getEventNativeType(TypeName typeName) {
        if (typeName instanceof ParameterizedTypeName) {
            return TypeName.get(byte[].class);
        }
        String simpleName = ((ClassName)typeName).simpleName();
        if ("Utf8String".equals(simpleName)) {
            return TypeName.get(byte[].class);
        }
        return SolidityFunctionWrapper.getNativeType(typeName);
    }

    private ParameterSpec buildParameterType(String type, String name) {
        return ParameterSpec.builder((TypeName)SolidityFunctionWrapper.buildTypeName(type), (String)name, (Modifier[])new Modifier[0]).build();
    }

    static List<ParameterSpec> buildParameterTypes(List<AbiDefinition.NamedType> namedTypes) {
        ArrayList<ParameterSpec> result = new ArrayList<ParameterSpec>(namedTypes.size());
        for (int i = 0; i < namedTypes.size(); ++i) {
            AbiDefinition.NamedType namedType = namedTypes.get(i);
            String name = SolidityFunctionWrapper.createValidParamName(namedType.getName(), i);
            String type = namedTypes.get(i).getType();
            namedType.setName(name);
            result.add(ParameterSpec.builder((TypeName)SolidityFunctionWrapper.buildTypeName(type), (String)name, (Modifier[])new Modifier[0]).build());
        }
        return result;
    }

    static String createValidParamName(String name, int idx) {
        if (name.equals("")) {
            return "param" + idx;
        }
        return name;
    }

    static List<TypeName> buildTypeNames(List<AbiDefinition.NamedType> namedTypes) {
        ArrayList<TypeName> result = new ArrayList<TypeName>(namedTypes.size());
        for (AbiDefinition.NamedType namedType : namedTypes) {
            result.add(SolidityFunctionWrapper.buildTypeName(namedType.getType()));
        }
        return result;
    }

    private MethodSpec buildFunction(AbiDefinition functionDefinition) throws ClassNotFoundException {
        String functionName = functionDefinition.getName();
        if (!SourceVersion.isName(functionName)) {
            functionName = "_" + functionName;
        }
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)functionName).addModifiers(new Modifier[]{Modifier.PUBLIC});
        String inputParams = this.addParameters(methodBuilder, functionDefinition.getInputs());
        List<TypeName> outputParameterTypes = SolidityFunctionWrapper.buildTypeNames(functionDefinition.getOutputs());
        if (functionDefinition.isConstant()) {
            this.buildConstantFunction(functionDefinition, methodBuilder, outputParameterTypes, inputParams);
        } else {
            this.buildTransactionFunction(functionDefinition, methodBuilder, inputParams);
        }
        return methodBuilder.build();
    }

    MethodSpec buildFunctionSeq(AbiDefinition functionDefinition) throws ClassNotFoundException {
        String functionName = functionDefinition.getName();
        if (!SourceVersion.isName(functionName = functionName + "Seq")) {
            functionName = "_" + functionName;
        }
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)functionName).addModifiers(new Modifier[]{Modifier.PUBLIC});
        String inputParams = this.addParameters(methodBuilder, functionDefinition.getInputs());
        this.buildTransactionFunctionSeq(functionDefinition, methodBuilder, inputParams);
        return methodBuilder.build();
    }

    MethodSpec buildFunctionWithCallback(AbiDefinition functionDefinition) throws ClassNotFoundException {
        String functionName = functionDefinition.getName();
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)functionName).addModifiers(new Modifier[]{Modifier.PUBLIC});
        List<TypeName> outputParameterTypes = SolidityFunctionWrapper.buildTypeNames(functionDefinition.getOutputs());
        if (functionDefinition.isConstant()) {
            String inputParams = this.addParameters(methodBuilder, functionDefinition.getInputs());
            this.buildConstantFunction(functionDefinition, methodBuilder, outputParameterTypes, inputParams);
        } else {
            String inputParams = this.addParameters(methodBuilder, functionDefinition.getInputs());
            methodBuilder.addParameter(ParameterSpec.builder((TypeName)SolidityFunctionWrapper.buildTypeName("TransactionSucCallback"), (String)CALLBACK_VALUE, (Modifier[])new Modifier[0]).build());
            this.buildTransactionFunctionWithCallback(functionDefinition, methodBuilder, inputParams);
        }
        return methodBuilder.build();
    }

    private void buildConstantFunction(AbiDefinition functionDefinition, MethodSpec.Builder methodBuilder, List<TypeName> outputParameterTypes, String inputParams) throws ClassNotFoundException {
        String functionName = functionDefinition.getName();
        if (outputParameterTypes.isEmpty()) {
            methodBuilder.addStatement("throw new RuntimeException(\"cannot call constant function with void return type\")", new Object[0]);
        } else if (outputParameterTypes.size() == 1) {
            TypeName typeName = outputParameterTypes.get(0);
            TypeName nativeReturnTypeName = this.useNativeJavaTypes ? this.getWrapperRawType(typeName) : this.getWrapperType(typeName);
            methodBuilder.returns((TypeName)SolidityFunctionWrapper.buildRemoteCall(nativeReturnTypeName));
            methodBuilder.addStatement("final $T function = new $T($N, \n$T.<$T>asList($L), \n$T.<$T<?>>asList(new $T<$T>() {}))", new Object[]{org.fisco.bcos.web3j.abi.datatypes.Function.class, org.fisco.bcos.web3j.abi.datatypes.Function.class, SolidityFunctionWrapper.funcNameToConst(functionName), Arrays.class, org.fisco.bcos.web3j.abi.datatypes.Type.class, inputParams, Arrays.class, TypeReference.class, TypeReference.class, typeName});
            if (this.useNativeJavaTypes) {
                if (nativeReturnTypeName.equals((Object)ClassName.get(List.class))) {
                    ParameterizedTypeName listType = ParameterizedTypeName.get(List.class, (Type[])new Type[]{org.fisco.bcos.web3j.abi.datatypes.Type.class});
                    CodeBlock.Builder callCode = CodeBlock.builder();
                    callCode.addStatement("$T result = ($T) executeCallSingleValueReturn(function, $T.class)", new Object[]{listType, listType, nativeReturnTypeName});
                    callCode.addStatement("return convertToNative(result)", new Object[0]);
                    TypeSpec callableType = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Callable.class), (TypeName[])new TypeName[]{nativeReturnTypeName})).addMethod(MethodSpec.methodBuilder((String)"call").addAnnotation(Override.class).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"unchecked"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addException(Exception.class).returns(nativeReturnTypeName).addCode(callCode.build()).build()).build();
                    methodBuilder.addStatement("return new $T(\n$L)", new Object[]{SolidityFunctionWrapper.buildRemoteCall(nativeReturnTypeName), callableType});
                } else {
                    methodBuilder.addStatement("return executeRemoteCallSingleValueReturn(function, $T.class)", new Object[]{nativeReturnTypeName});
                }
            } else {
                methodBuilder.addStatement("return executeRemoteCallSingleValueReturn(function)", new Object[0]);
            }
        } else {
            List<TypeName> returnTypes = this.buildReturnTypes(outputParameterTypes);
            ParameterizedTypeName parameterizedTupleType = ParameterizedTypeName.get((ClassName)ClassName.get((String)"org.fisco.bcos.web3j.tuples.generated", (String)("Tuple" + returnTypes.size()), (String[])new String[0]), (TypeName[])returnTypes.toArray(new TypeName[returnTypes.size()]));
            methodBuilder.returns((TypeName)SolidityFunctionWrapper.buildRemoteCall((TypeName)parameterizedTupleType));
            SolidityFunctionWrapper.buildVariableLengthReturnFunctionConstructor(methodBuilder, functionName, inputParams, outputParameterTypes);
            this.buildTupleResultContainer(methodBuilder, parameterizedTupleType, outputParameterTypes);
        }
    }

    private static ParameterizedTypeName buildRemoteCall(TypeName typeName) {
        return ParameterizedTypeName.get((ClassName)ClassName.get(RemoteCall.class), (TypeName[])new TypeName[]{typeName});
    }

    private void buildTransactionFunction(AbiDefinition functionDefinition, MethodSpec.Builder methodBuilder, String inputParams) throws ClassNotFoundException {
        if (functionDefinition.hasOutputs()) {
            this.reporter.report(String.format("Definition of the function %s returns a value but is not defined as a view function. Please ensure it contains the view modifier if you want to read the return value", functionDefinition.getName()));
        }
        if (functionDefinition.isPayable()) {
            methodBuilder.addParameter(BigInteger.class, WEI_VALUE, new Modifier[0]);
        }
        String functionName = functionDefinition.getName();
        methodBuilder.returns((TypeName)SolidityFunctionWrapper.buildRemoteCall(TypeName.get(TransactionReceipt.class)));
        methodBuilder.addStatement("final $T function = new $T(\n$N, \n$T.<$T>asList($L), \n$T.<$T<?>>emptyList())", new Object[]{org.fisco.bcos.web3j.abi.datatypes.Function.class, org.fisco.bcos.web3j.abi.datatypes.Function.class, SolidityFunctionWrapper.funcNameToConst(functionName), Arrays.class, org.fisco.bcos.web3j.abi.datatypes.Type.class, inputParams, Collections.class, TypeReference.class});
        if (functionDefinition.isPayable()) {
            methodBuilder.addStatement("return executeRemoteCallTransaction(function, $N)", new Object[]{WEI_VALUE});
        } else {
            methodBuilder.addStatement("return executeRemoteCallTransaction(function)", new Object[0]);
        }
    }

    private void buildTransactionFunctionWithCallback(AbiDefinition functionDefinition, MethodSpec.Builder methodBuilder, String inputParams) throws ClassNotFoundException {
        if (functionDefinition.hasOutputs()) {
            this.reporter.report(String.format("Definition of the function %s returns a value but is not defined as a view function. Please ensure it contains the view modifier if you want to read the return value", functionDefinition.getName()));
        }
        if (functionDefinition.isPayable()) {
            methodBuilder.addParameter(BigInteger.class, WEI_VALUE, new Modifier[0]);
        }
        String functionName = functionDefinition.getName();
        methodBuilder.returns(TypeName.VOID);
        methodBuilder.addStatement("final $T function = new $T(\n$N, \n$T.<$T>asList($L), \n$T.<$T<?>>emptyList())", new Object[]{org.fisco.bcos.web3j.abi.datatypes.Function.class, org.fisco.bcos.web3j.abi.datatypes.Function.class, SolidityFunctionWrapper.funcNameToConst(functionName), Arrays.class, org.fisco.bcos.web3j.abi.datatypes.Type.class, inputParams, Collections.class, TypeReference.class});
        methodBuilder.addStatement("asyncExecuteTransaction(function, callback)", new Object[0]);
    }

    private void buildTransactionFunctionSeq(AbiDefinition functionDefinition, MethodSpec.Builder methodBuilder, String inputParams) throws ClassNotFoundException {
        if (functionDefinition.hasOutputs()) {
            this.reporter.report(String.format("Definition of the function %s returns a value but is not defined as a view function. Please ensure it contains the view modifier if you want to read the return value", functionDefinition.getName()));
        }
        if (functionDefinition.isPayable()) {
            methodBuilder.addParameter(BigInteger.class, WEI_VALUE, new Modifier[0]);
        }
        String functionName = functionDefinition.getName();
        TypeName returnType = TypeName.get(String.class);
        methodBuilder.returns(returnType);
        methodBuilder.addStatement("final $T function = new $T(\n$N, \n$T.<$T>asList($L), \n$T.<$T<?>>emptyList())", new Object[]{org.fisco.bcos.web3j.abi.datatypes.Function.class, org.fisco.bcos.web3j.abi.datatypes.Function.class, SolidityFunctionWrapper.funcNameToConst(functionName), Arrays.class, org.fisco.bcos.web3j.abi.datatypes.Type.class, inputParams, Collections.class, TypeReference.class});
        methodBuilder.addStatement("return createTransactionSeq(function)", new Object[0]);
    }

    TypeSpec buildEventResponseObject(String className, List<NamedTypeName> indexedParameters, List<NamedTypeName> nonIndexedParameters) {
        TypeName typeName;
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)className).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        builder.addField((TypeName)LOG, "log", new Modifier[]{Modifier.PUBLIC});
        for (NamedTypeName namedType : indexedParameters) {
            typeName = this.getIndexedEventWrapperType(namedType.typeName);
            builder.addField(typeName, namedType.getName(), new Modifier[]{Modifier.PUBLIC});
        }
        for (NamedTypeName namedType : nonIndexedParameters) {
            typeName = this.getWrapperType(namedType.typeName);
            builder.addField(typeName, namedType.getName(), new Modifier[]{Modifier.PUBLIC});
        }
        return builder.build();
    }

    MethodSpec buildEventFlowableFunction(String responseClassName, String functionName, List<NamedTypeName> indexedParameters, List<NamedTypeName> nonIndexedParameters) throws ClassNotFoundException {
        String generatedFunctionName = Strings.lowercaseFirstLetter(functionName) + "EventFlowable";
        ParameterizedTypeName parameterizedTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(Flowable.class), (TypeName[])new TypeName[]{ClassName.get((String)"", (String)responseClassName, (String[])new String[0])});
        MethodSpec.Builder flowableMethodBuilder = MethodSpec.methodBuilder((String)generatedFunctionName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(BcosFilter.class, FILTER, new Modifier[0]).returns((TypeName)parameterizedTypeName);
        TypeSpec converter = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Function.class), (TypeName[])new TypeName[]{ClassName.get(Log.class), ClassName.get((String)"", (String)responseClassName, (String[])new String[0])})).addMethod(MethodSpec.methodBuilder((String)"apply").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(Log.class, "log", new Modifier[0]).returns((TypeName)ClassName.get((String)"", (String)responseClassName, (String[])new String[0])).addStatement("$T eventValues = extractEventParametersWithLog(" + this.buildEventDefinitionName(functionName) + ", log)", new Object[]{Contract.EventValuesWithLog.class}).addStatement("$1T typedResponse = new $1T()", new Object[]{ClassName.get((String)"", (String)responseClassName, (String[])new String[0])}).addCode(this.buildTypedResponse("typedResponse", indexedParameters, nonIndexedParameters, true)).addStatement("return typedResponse", new Object[0]).build()).build();
        flowableMethodBuilder.addStatement("return web3j.logFlowable(filter).map($L)", new Object[]{converter});
        return flowableMethodBuilder.build();
    }

    MethodSpec buildDefaultEventFlowableFunction(String responseClassName, String functionName) {
        String generatedFunctionName = Strings.lowercaseFirstLetter(functionName) + "EventFlowable";
        ParameterizedTypeName parameterizedTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(Flowable.class), (TypeName[])new TypeName[]{ClassName.get((String)"", (String)responseClassName, (String[])new String[0])});
        MethodSpec.Builder flowableMethodBuilder = MethodSpec.methodBuilder((String)generatedFunctionName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(String.class, FROM_BLOCK, new Modifier[0]).addParameter(String.class, TO_BLOCK, new Modifier[0]).returns((TypeName)parameterizedTypeName);
        flowableMethodBuilder.addStatement("$1T filter = new $1T($2L, $3L, getContractAddress())", new Object[]{BcosFilter.class, FROM_BLOCK, TO_BLOCK}).addStatement("filter.addSingleTopic($T.encode(" + this.buildEventDefinitionName(functionName) + "))", new Object[]{EventEncoder.class}).addStatement("return " + generatedFunctionName + "(filter)", new Object[0]);
        return flowableMethodBuilder.build();
    }

    private MethodSpec buildRegisterEventLogPushFunction(String eventName) throws ClassNotFoundException {
        String generatedFunctionName = "register" + eventName + "EventLogFilter";
        MethodSpec.Builder getEventMethodBuilder = MethodSpec.methodBuilder((String)generatedFunctionName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(String.class, FROM_BLOCK, new Modifier[0]).addParameter(String.class, TO_BLOCK, new Modifier[0]);
        this.addParameter(getEventMethodBuilder, "string[]", OTHER_TOPICS).addParameter(AbiTypes.getType("EventLogPushCallback"), CALLBACK_VALUE, new Modifier[0]);
        getEventMethodBuilder.addStatement("String topic0 = $T.encode(" + this.buildEventDefinitionName(eventName) + ")", new Object[]{EventEncoder.class});
        getEventMethodBuilder.addStatement("registerEventLogPushFilter(ABI,BINARY,topic0,fromBlock,toBlock,otherTopcs,callback)", new Object[0]);
        return getEventMethodBuilder.build();
    }

    private MethodSpec buildDefaultRegisterEventLogPushFunction(String eventName) throws ClassNotFoundException {
        String generatedFunctionName = "register" + eventName + "EventLogFilter";
        MethodSpec.Builder getEventMethodBuilder = MethodSpec.methodBuilder((String)generatedFunctionName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(AbiTypes.getType("EventLogPushCallback"), CALLBACK_VALUE, new Modifier[0]);
        getEventMethodBuilder.addStatement("String topic0 = $T.encode(" + this.buildEventDefinitionName(eventName) + ")", new Object[]{EventEncoder.class});
        getEventMethodBuilder.addStatement("registerEventLogPushFilter(ABI,BINARY,topic0,callback)", new Object[0]);
        return getEventMethodBuilder.build();
    }

    MethodSpec buildEventTransactionReceiptFunction(String responseClassName, String functionName, List<NamedTypeName> indexedParameters, List<NamedTypeName> nonIndexedParameters) {
        ParameterizedTypeName parameterizedTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{ClassName.get((String)"", (String)responseClassName, (String[])new String[0])});
        String generatedFunctionName = "get" + Strings.capitaliseFirstLetter(functionName) + "Events";
        MethodSpec.Builder transactionMethodBuilder = MethodSpec.methodBuilder((String)generatedFunctionName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(TransactionReceipt.class, "transactionReceipt", new Modifier[0]).returns((TypeName)parameterizedTypeName);
        transactionMethodBuilder.addStatement("$T valueList = extractEventParametersWithLog(" + this.buildEventDefinitionName(functionName) + ", transactionReceipt)", new Object[]{ParameterizedTypeName.get(List.class, (Type[])new Type[]{Contract.EventValuesWithLog.class})}).addStatement("$1T responses = new $1T(valueList.size())", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(ArrayList.class), (TypeName[])new TypeName[]{ClassName.get((String)"", (String)responseClassName, (String[])new String[0])})}).beginControlFlow("for ($T eventValues : valueList)", new Object[]{Contract.EventValuesWithLog.class}).addStatement("$1T typedResponse = new $1T()", new Object[]{ClassName.get((String)"", (String)responseClassName, (String[])new String[0])}).addCode(this.buildTypedResponse("typedResponse", indexedParameters, nonIndexedParameters, false)).addStatement("responses.add(typedResponse)", new Object[0]).endControlFlow();
        transactionMethodBuilder.addStatement("return responses", new Object[0]);
        return transactionMethodBuilder.build();
    }

    List<MethodSpec> buildEventFunctions(AbiDefinition functionDefinition, TypeSpec.Builder classBuilder) throws ClassNotFoundException {
        String functionName = functionDefinition.getName();
        List<AbiDefinition.NamedType> inputs = functionDefinition.getInputs();
        String responseClassName = Strings.capitaliseFirstLetter(functionName) + "EventResponse";
        ArrayList<NamedTypeName> parameters = new ArrayList<NamedTypeName>();
        ArrayList<NamedTypeName> indexedParameters = new ArrayList<NamedTypeName>();
        ArrayList<NamedTypeName> nonIndexedParameters = new ArrayList<NamedTypeName>();
        for (AbiDefinition.NamedType namedType : inputs) {
            NamedTypeName parameter = new NamedTypeName(namedType.getName(), SolidityFunctionWrapper.buildTypeName(namedType.getType()), namedType.isIndexed());
            if (namedType.isIndexed()) {
                indexedParameters.add(parameter);
            } else {
                nonIndexedParameters.add(parameter);
            }
            parameters.add(parameter);
        }
        classBuilder.addField(this.createEventDefinition(functionName, parameters));
        classBuilder.addType(this.buildEventResponseObject(responseClassName, indexedParameters, nonIndexedParameters));
        ArrayList<MethodSpec> methods = new ArrayList<MethodSpec>();
        methods.add(this.buildEventTransactionReceiptFunction(responseClassName, functionName, indexedParameters, nonIndexedParameters));
        methods.add(this.buildRegisterEventLogPushFunction(functionName));
        methods.add(this.buildDefaultRegisterEventLogPushFunction(functionName));
        return methods;
    }

    CodeBlock buildTypedResponse(String objectName, List<NamedTypeName> indexedParameters, List<NamedTypeName> nonIndexedParameters, boolean flowable) {
        int i;
        String nativeConversion = this.useNativeJavaTypes ? ".getValue()" : "";
        CodeBlock.Builder builder = CodeBlock.builder();
        if (flowable) {
            builder.addStatement("$L.log = log", new Object[]{objectName});
        } else {
            builder.addStatement("$L.log = eventValues.getLog()", new Object[]{objectName});
        }
        for (i = 0; i < indexedParameters.size(); ++i) {
            builder.addStatement("$L.$L = ($T) eventValues.getIndexedValues().get($L)" + nativeConversion, new Object[]{objectName, indexedParameters.get(i).getName(), this.getIndexedEventWrapperType(indexedParameters.get(i).getTypeName()), i});
        }
        for (i = 0; i < nonIndexedParameters.size(); ++i) {
            builder.addStatement("$L.$L = ($T) eventValues.getNonIndexedValues().get($L)" + nativeConversion, new Object[]{objectName, nonIndexedParameters.get(i).getName(), this.getWrapperType(nonIndexedParameters.get(i).getTypeName()), i});
        }
        return builder.build();
    }

    static TypeName buildTypeName(String typeDeclaration) {
        String type = SolidityFunctionWrapper.trimStorageDeclaration(typeDeclaration);
        Matcher matcher = pattern.matcher(type);
        if (matcher.find()) {
            Class<?> rawType;
            ParameterizedTypeName typeName;
            Class<?> baseType = AbiTypes.getType(matcher.group(1));
            String firstArrayDimension = matcher.group(2);
            String secondArrayDimension = matcher.group(3);
            if ("".equals(firstArrayDimension)) {
                typeName = ParameterizedTypeName.get(DynamicArray.class, (Type[])new Type[]{baseType});
            } else {
                rawType = SolidityFunctionWrapper.getStaticArrayTypeReferenceClass(firstArrayDimension);
                typeName = ParameterizedTypeName.get(rawType, (Type[])new Type[]{baseType});
            }
            if (secondArrayDimension != null) {
                if ("".equals(secondArrayDimension)) {
                    return ParameterizedTypeName.get((ClassName)ClassName.get(DynamicArray.class), (TypeName[])new TypeName[]{typeName});
                }
                rawType = SolidityFunctionWrapper.getStaticArrayTypeReferenceClass(secondArrayDimension);
                return ParameterizedTypeName.get((ClassName)ClassName.get(rawType), (TypeName[])new TypeName[]{typeName});
            }
            return typeName;
        }
        Class<?> cls = AbiTypes.getType(type);
        return ClassName.get(cls);
    }

    private static Class<?> getStaticArrayTypeReferenceClass(String type) {
        try {
            return Class.forName("org.fisco.bcos.web3j.abi.datatypes.generated.StaticArray" + type);
        }
        catch (ClassNotFoundException e) {
            return StaticArray.class;
        }
    }

    private static String trimStorageDeclaration(String type) {
        if (type.endsWith(" storage") || type.endsWith(" memory")) {
            return type.split(" ")[0];
        }
        return type;
    }

    private List<TypeName> buildReturnTypes(List<TypeName> outputParameterTypes) {
        ArrayList<TypeName> result = new ArrayList<TypeName>(outputParameterTypes.size());
        for (TypeName typeName : outputParameterTypes) {
            result.add(this.getWrapperType(typeName));
        }
        return result;
    }

    private static void buildVariableLengthReturnFunctionConstructor(MethodSpec.Builder methodBuilder, String functionName, String inputParameters, List<TypeName> outputParameterTypes) throws ClassNotFoundException {
        ArrayList<Object> objects = new ArrayList<Object>();
        objects.add(org.fisco.bcos.web3j.abi.datatypes.Function.class);
        objects.add(org.fisco.bcos.web3j.abi.datatypes.Function.class);
        objects.add(SolidityFunctionWrapper.funcNameToConst(functionName));
        objects.add(Arrays.class);
        objects.add(org.fisco.bcos.web3j.abi.datatypes.Type.class);
        objects.add(inputParameters);
        objects.add(Arrays.class);
        objects.add(TypeReference.class);
        for (TypeName outputParameterType : outputParameterTypes) {
            objects.add(TypeReference.class);
            objects.add(outputParameterType);
        }
        String asListParams = Collection.join(outputParameterTypes, ", ", typeName -> "new $T<$T>() {}");
        methodBuilder.addStatement("final $T function = new $T($N, \n$T.<$T>asList($L), \n$T.<$T<?>>asList(" + asListParams + "))", objects.toArray());
    }

    private void buildTupleResultContainer(MethodSpec.Builder methodBuilder, ParameterizedTypeName tupleType, List<TypeName> outputParameterTypes) throws ClassNotFoundException {
        List typeArguments = tupleType.typeArguments;
        CodeBlock.Builder tupleConstructor = CodeBlock.builder();
        tupleConstructor.addStatement("$T results = executeCallMultipleValueReturn(function)", new Object[]{ParameterizedTypeName.get(List.class, (Type[])new Type[]{org.fisco.bcos.web3j.abi.datatypes.Type.class})}).add("return new $T(", new Object[]{tupleType}).add("$>$>", new Object[0]);
        String resultStringSimple = "\n($T) results.get($L)";
        if (this.useNativeJavaTypes) {
            resultStringSimple = resultStringSimple + ".getValue()";
        }
        String resultStringNativeList = "\nconvertToNative(($T) results.get($L).getValue())";
        int size = typeArguments.size();
        ClassName classList = ClassName.get(List.class);
        for (int i = 0; i < size; ++i) {
            TypeName param = outputParameterTypes.get(i);
            TypeName convertTo = (TypeName)typeArguments.get(i);
            String resultString = resultStringSimple;
            if (this.useNativeJavaTypes && param instanceof ParameterizedTypeName) {
                ParameterizedTypeName oldContainer = (ParameterizedTypeName)param;
                ParameterizedTypeName newContainer = (ParameterizedTypeName)convertTo;
                if (newContainer.rawType.compareTo(classList) == 0 && newContainer.typeArguments.size() == 1) {
                    convertTo = ParameterizedTypeName.get((ClassName)classList, (TypeName[])new TypeName[]{(TypeName)oldContainer.typeArguments.get(0)});
                    resultString = resultStringNativeList;
                }
            }
            tupleConstructor.add(resultString, new Object[]{convertTo, i});
            tupleConstructor.add(i < size - 1 ? ", " : ");\n", new Object[0]);
        }
        tupleConstructor.add("$<$<", new Object[0]);
        TypeSpec callableType = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Callable.class), (TypeName[])new TypeName[]{tupleType})).addMethod(MethodSpec.methodBuilder((String)"call").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addException(Exception.class).returns((TypeName)tupleType).addCode(tupleConstructor.build()).build()).build();
        methodBuilder.addStatement("return new $T(\n$L)", new Object[]{SolidityFunctionWrapper.buildRemoteCall((TypeName)tupleType), callableType});
    }

    private static CodeBlock buildVariableLengthEventInitializer(String eventName, List<NamedTypeName> parameterTypes) {
        ArrayList<Object> objects = new ArrayList<Object>();
        objects.add(Event.class);
        objects.add(eventName);
        objects.add(Arrays.class);
        objects.add(TypeReference.class);
        for (NamedTypeName parameterType : parameterTypes) {
            objects.add(TypeReference.class);
            objects.add(parameterType.getTypeName());
        }
        String asListParams = parameterTypes.stream().map(type -> {
            if (type.isIndexed()) {
                return "new $T<$T>(true) {}";
            }
            return "new $T<$T>() {}";
        }).collect(Collectors.joining(", "));
        return CodeBlock.builder().addStatement("new $T($S, \n$T.<$T<?>>asList(" + asListParams + "))", objects.toArray()).build();
    }

    private List<AbiDefinition> loadContractDefinition(String abi) throws IOException {
        ObjectMapper objectMapper = ObjectMapperFactory.getObjectMapper();
        AbiDefinition[] abiDefinition = (AbiDefinition[])objectMapper.readValue(abi, AbiDefinition[].class);
        return Arrays.asList(abiDefinition);
    }

    private static String funcNameToConst(String funcName) {
        return FUNC_NAME_PREFIX + funcName.toUpperCase();
    }

    private static class NamedTypeName {
        private final TypeName typeName;
        private final String name;
        private final boolean indexed;

        NamedTypeName(String name, TypeName typeName, boolean indexed) {
            this.name = name;
            this.typeName = typeName;
            this.indexed = indexed;
        }

        public String getName() {
            return this.name;
        }

        public TypeName getTypeName() {
            return this.typeName;
        }

        public boolean isIndexed() {
            return this.indexed;
        }
    }
}

