/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.crypto.gm;

import java.math.BigInteger;
import java.security.KeyPair;
import org.fisco.bcos.web3j.crypto.Credentials;
import org.fisco.bcos.web3j.crypto.ECKeyPair;
import org.fisco.bcos.web3j.crypto.EncryptType;
import org.fisco.bcos.web3j.crypto.Keys;
import org.fisco.bcos.web3j.crypto.gm.sm2.crypto.asymmetric.SM2KeyGenerator;
import org.fisco.bcos.web3j.crypto.gm.sm2.crypto.asymmetric.SM2PrivateKey;
import org.fisco.bcos.web3j.crypto.gm.sm2.crypto.asymmetric.SM2PublicKey;
import org.fisco.bcos.web3j.crypto.gm.sm2.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenCredential {
    private static Logger logger = LoggerFactory.getLogger(GenCredential.class);

    public static ECKeyPair createGuomiKeyPair() {
        SM2KeyGenerator generator = new SM2KeyGenerator();
        KeyPair keyPairData = generator.generateKeyPair();
        if (keyPairData != null) {
            return GenCredential.genEcPairFromKeyPair(keyPairData);
        }
        return null;
    }

    private static ECKeyPair genEcPairFromKeyPair(KeyPair keyPairData) {
        try {
            SM2PrivateKey vk = (SM2PrivateKey)keyPairData.getPrivate();
            SM2PublicKey pk = (SM2PublicKey)keyPairData.getPublic();
            byte[] publicKey = pk.getEncoded();
            byte[] privateKey = vk.getEncoded();
            BigInteger biPublic = new BigInteger(Hex.toHexString(publicKey), 16);
            BigInteger biPrivate = new BigInteger(Hex.toHexString(privateKey), 16);
            ECKeyPair keyPair = new ECKeyPair(biPrivate, biPublic);
            return keyPair;
        }
        catch (Exception e) {
            logger.error("create ec_keypair of guomi failed, error msg:" + e.getMessage());
            return null;
        }
    }

    private static ECKeyPair createGuomiKeyPair(String privKey) {
        SM2KeyGenerator generator = new SM2KeyGenerator();
        KeyPair keyPairData = generator.generateKeyPair(privKey);
        if (keyPairData != null) {
            return GenCredential.genEcPairFromKeyPair(keyPairData);
        }
        return null;
    }

    private static ECKeyPair createECDSAKeyPair(String privKey) {
        try {
            BigInteger bigPrivKey = new BigInteger(privKey, 16);
            ECKeyPair keyPair = ECKeyPair.create(bigPrivKey);
            return keyPair;
        }
        catch (Exception e) {
            logger.error("create keypair of ECDSA failed, error msg:" + e.getMessage());
            return null;
        }
    }

    private static ECKeyPair createECDSAKeyPair() {
        try {
            ECKeyPair keyPair = Keys.createEcKeyPair();
            return keyPair;
        }
        catch (Exception e) {
            logger.error("create keypair of ECDSA failed, error msg:" + e.getMessage());
            return null;
        }
    }

    private static ECKeyPair createKeyPair() {
        if (EncryptType.encryptType == 1) {
            return GenCredential.createGuomiKeyPair();
        }
        return GenCredential.createECDSAKeyPair();
    }

    private static ECKeyPair createKeyPair(String privKey) {
        if (EncryptType.encryptType == 1) {
            return GenCredential.createGuomiKeyPair(privKey);
        }
        return GenCredential.createECDSAKeyPair(privKey);
    }

    public static Credentials create() {
        try {
            ECKeyPair keyPair = GenCredential.createKeyPair();
            if (keyPair == null) {
                return null;
            }
            Credentials credentials = Credentials.create(keyPair);
            return credentials;
        }
        catch (Exception e) {
            System.out.println("init credential failed");
            logger.error("init credential failed, error msg:" + e.getMessage());
            return null;
        }
    }

    public static Credentials create(String privKey) {
        try {
            ECKeyPair keyPair = GenCredential.createKeyPair(privKey);
            if (keyPair == null) {
                return null;
            }
            Credentials credentials = Credentials.create(keyPair);
            return credentials;
        }
        catch (Exception e) {
            System.out.println("init credential from private key failed ");
            logger.error("init credential from private key failed, error msg:" + e.getMessage());
            return null;
        }
    }

    public static Credentials create(ECKeyPair keyPair) {
        try {
            ECKeyPair newKeyPair = GenCredential.createKeyPair(keyPair.getPrivateKey().toString(16));
            if (newKeyPair == null) {
                return null;
            }
            Credentials credentials = Credentials.create(newKeyPair);
            return credentials;
        }
        catch (Exception e) {
            System.out.println("init credential from private key failed ");
            logger.error("init credential from private key failed, error msg:" + e.getMessage());
            return null;
        }
    }
}

